/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.types;

import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_KIND_OF_OBJECT;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014JH\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015R\u00020\u0013H\u0016\u00a8\u0006\u0016"}, d2={"Lavail/interpreter/primitive/types/P_IsInstanceOf;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "arguments", "", "argumentTypes", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_IsInstanceOf
extends Primitive {
    @NotNull
    public static final P_IsInstanceOf INSTANCE = new P_IsInstanceOf();

    private P_IsInstanceOf() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        List<AvailObject> list2 = interpreter.argsBuffer;
        AvailObject value = list2.get(0);
        AvailObject type = list2.get(1);
        return interpreter.primitiveSuccess(AtomDescriptor.Companion.objectFromBoolean(value.isInstanceOf(type)));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ANY.getO(), InstanceMetaDescriptor.Companion.topMeta()), EnumerationTypeDescriptor.Companion.getBooleanType(), null, 4, null);
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        L2ReadBoxedOperand xReg = arguments.get(0);
        L2ReadBoxedOperand yTypeReg = arguments.get(1);
        L2Generator generator = translator.getGenerator();
        if (xReg.restriction().metaRestriction().intersection(yTypeReg.restriction()).getType().isVacuousType()) {
            callSiteHelper.useAnswer(generator.boxedConstant(AtomDescriptor.Companion.getFalseObject()));
            return true;
        }
        L2BasicBlock ifInstance = generator.createBasicBlock("if instance");
        L2BasicBlock ifNotInstance = generator.createBasicBlock("not instance");
        AvailObject constantYType = yTypeReg.constantOrNull();
        if (constantYType != null) {
            generator.jumpIfKindOfConstant(xReg, A_Type.Companion.typeIntersection(constantYType, xReg.type()), ifInstance, ifNotInstance);
        } else {
            L2Operand[] l2OperandArray = new L2Operand[]{xReg, yTypeReg, L2Generator.Companion.edgeTo$default(L2Generator.Companion, ifInstance, null, 2, null), L2Generator.Companion.edgeTo$default(L2Generator.Companion, ifNotInstance, null, 2, null)};
            translator.addInstruction(L2_JUMP_IF_KIND_OF_OBJECT.INSTANCE, l2OperandArray);
        }
        L2Generator.startBlock$default(generator, ifInstance, false, null, 6, null);
        if (generator.currentlyReachable()) {
            callSiteHelper.useAnswer(generator.boxedConstant(AtomDescriptor.Companion.getTrueObject()));
        }
        L2Generator.startBlock$default(generator, ifNotInstance, false, null, 6, null);
        if (generator.currentlyReachable()) {
            callSiteHelper.useAnswer(generator.boxedConstant(AtomDescriptor.Companion.getFalseObject()));
        }
        return true;
    }
}

