/*
 * Decompiled with CFR 0.152.
 */
package avail.performance;

import avail.performance.ReportingUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001BC\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u000fJ\u0006\u0010\u0010\u001a\u00020\rJ\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\r\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0017J\u001a\u0010\u0018\u001a\u00020\r2\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u0007J\"\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#H\u0082\b\u00a2\u0006\u0002\u0010$J\r\u0010%\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b&J\r\u0010'\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b(J\r\u0010)\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b*R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lavail/performance/PerInterpreterStatistic;", "", "lock", "Ljava/util/concurrent/atomic/AtomicInteger;", "count", "", "min", "", "max", "mean", "sumOfDeltaSquares", "(Ljava/util/concurrent/atomic/AtomicInteger;JDDDD)V", "addTo", "", "target", "addTo$avail", "clear", "compareTo", "", "other", "computeVariance", "theCount", "theSumOfDeltaSquares", "count$avail", "describeOn", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "unit", "Lavail/performance/ReportingUnit;", "record", "sample", "spinLockWhile", "A", "body", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "standardDeviation", "standardDeviation$avail", "sum", "sum$avail", "variance", "variance$avail", "avail"})
@SourceDebugExtension(value={"SMAP\nPerInterpreterStatistic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerInterpreterStatistic.kt\navail/performance/PerInterpreterStatistic\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n103#1,9:290\n112#1:300\n103#1,9:301\n112#1:311\n103#1,9:312\n112#1:322\n1#2:289\n1#2:299\n1#2:310\n1#2:321\n*S KotlinDebug\n*F\n+ 1 PerInterpreterStatistic.kt\navail/performance/PerInterpreterStatistic\n*L\n237#1:290,9\n237#1:300\n257#1:301,9\n257#1:311\n279#1:312,9\n279#1:322\n237#1:299\n257#1:310\n279#1:321\n*E\n"})
public final class PerInterpreterStatistic
implements Comparable<PerInterpreterStatistic> {
    @NotNull
    private final AtomicInteger lock;
    private long count;
    private double min;
    private double max;
    private double mean;
    private double sumOfDeltaSquares;

    public PerInterpreterStatistic(@NotNull AtomicInteger lock, long count, double min2, double max2, double mean, double sumOfDeltaSquares) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        this.lock = lock;
        this.count = count;
        this.min = min2;
        this.max = max2;
        this.mean = mean;
        this.sumOfDeltaSquares = sumOfDeltaSquares;
    }

    public /* synthetic */ PerInterpreterStatistic(AtomicInteger atomicInteger, long l, double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            atomicInteger = new AtomicInteger(0);
        }
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            d = Double.POSITIVE_INFINITY;
        }
        if ((n & 8) != 0) {
            d2 = Double.NEGATIVE_INFINITY;
        }
        if ((n & 0x10) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x20) != 0) {
            d4 = 0.0;
        }
        this(atomicInteger, l, d, d2, d3, d4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <A> A spinLockWhile(Function0<? extends A> body2) {
        Object object;
        boolean $i$f$spinLockWhile = false;
        while (!this.lock.compareAndSet(0, 1)) {
            Thread.onSpinWait();
        }
        try {
            object = body2.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            boolean ok = this.lock.compareAndSet(1, 0);
            if (_Assertions.ENABLED && !ok) {
                boolean $i$a$-assert-PerInterpreterStatistic$spinLockWhile$22 = false;
                String $i$a$-assert-PerInterpreterStatistic$spinLockWhile$22 = "Invalid spinlock state";
                throw new AssertionError((Object)$i$a$-assert-PerInterpreterStatistic$spinLockWhile$22);
            }
            InlineMarker.finallyEnd((int)1);
        }
        return (A)object;
    }

    @Override
    public int compareTo(@NotNull PerInterpreterStatistic other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Double.compare(other.sum$avail(), this.sum$avail());
    }

    public final long count$avail() {
        return this.count;
    }

    public final double sum$avail() {
        return this.mean * (double)this.count;
    }

    public final double variance$avail() {
        return this.computeVariance(this.count, this.sumOfDeltaSquares);
    }

    private final double computeVariance(long theCount, double theSumOfDeltaSquares) {
        return theCount <= 1L ? 0.0 : theSumOfDeltaSquares / (double)(theCount - 1L);
    }

    public final double standardDeviation$avail() {
        return Math.sqrt(this.variance$avail());
    }

    public final void describeOn(@NotNull StringBuilder builder, @NotNull ReportingUnit unit) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        long capturedCount = this.count;
        double capturedMean = this.mean;
        double capturedSumOfDeltaSquares = this.sumOfDeltaSquares;
        double standardDeviation = Math.sqrt(this.computeVariance(capturedCount, capturedSumOfDeltaSquares));
        builder.append(unit.describe$avail(capturedCount, capturedMean, 0.0, false));
        Object[] objectArray = new Object[]{capturedCount};
        builder.append(String.format(" [N=%,10d] ", objectArray));
        builder.append("(mean=");
        builder.append(unit.describe$avail(1L, capturedMean, standardDeviation, true));
        builder.append(")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void record(double sample) {
        PerInterpreterStatistic this_$iv = this;
        boolean $i$f$spinLockWhile = false;
        while (!this_$iv.lock.compareAndSet(0, 1)) {
            Thread.onSpinWait();
        }
        try {
            boolean bl = false;
            long l = this.count;
            this.count = l + 1L;
            this.min = Math.min(sample, this.min);
            this.max = Math.max(sample, this.max);
            double delta = sample - this.mean;
            this.mean += delta / (double)this.count;
            this.sumOfDeltaSquares += delta * (sample - this.mean);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            boolean ok$iv = this_$iv.lock.compareAndSet(1, 0);
            if (_Assertions.ENABLED && !ok$iv) {
                boolean $i$a$-assert-PerInterpreterStatistic$spinLockWhile$1$iv22 = false;
                String $i$a$-assert-PerInterpreterStatistic$spinLockWhile$1$iv22 = "Invalid spinlock state";
                throw new AssertionError((Object)$i$a$-assert-PerInterpreterStatistic$spinLockWhile$1$iv22);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTo$avail(@NotNull PerInterpreterStatistic target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        PerInterpreterStatistic this_$iv = this;
        boolean $i$f$spinLockWhile = false;
        while (!this_$iv.lock.compareAndSet(0, 1)) {
            Thread.onSpinWait();
        }
        try {
            boolean bl = false;
            if (this.count > 0L) {
                long newCount = target.count + this.count;
                double delta = this.mean - target.mean;
                target.mean = ((double)target.count * target.mean + (double)this.count * this.mean) / (double)newCount;
                target.sumOfDeltaSquares += this.sumOfDeltaSquares + delta * delta / (double)newCount * (double)target.count * (double)this.count;
                target.count = newCount;
                target.min = Math.min(target.min, this.min);
                target.max = Math.max(target.max, this.max);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            boolean ok$iv = this_$iv.lock.compareAndSet(1, 0);
            if (_Assertions.ENABLED && !ok$iv) {
                boolean $i$a$-assert-PerInterpreterStatistic$spinLockWhile$1$iv22 = false;
                String $i$a$-assert-PerInterpreterStatistic$spinLockWhile$1$iv22 = "Invalid spinlock state";
                throw new AssertionError((Object)$i$a$-assert-PerInterpreterStatistic$spinLockWhile$1$iv22);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        PerInterpreterStatistic this_$iv = this;
        boolean $i$f$spinLockWhile = false;
        while (!this_$iv.lock.compareAndSet(0, 1)) {
            Thread.onSpinWait();
        }
        try {
            boolean bl = false;
            this.count = 0L;
            this.min = Double.POSITIVE_INFINITY;
            this.max = Double.NEGATIVE_INFINITY;
            this.mean = 0.0;
            this.sumOfDeltaSquares = 0.0;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            boolean ok$iv = this_$iv.lock.compareAndSet(1, 0);
            if (_Assertions.ENABLED && !ok$iv) {
                boolean $i$a$-assert-PerInterpreterStatistic$spinLockWhile$1$iv22 = false;
                String $i$a$-assert-PerInterpreterStatistic$spinLockWhile$1$iv22 = "Invalid spinlock state";
                throw new AssertionError((Object)$i$a$-assert-PerInterpreterStatistic$spinLockWhile$1$iv22);
            }
        }
    }

    public PerInterpreterStatistic() {
        this(null, 0L, 0.0, 0.0, 0.0, 0.0, 63, null);
    }
}

