/*
 * Decompiled with CFR 0.152.
 */
package avail.persistence.cache.record;

import avail.persistence.cache.Repository;
import avail.utility.CodingKt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006BG\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0015\u0010 \u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lavail/persistence/cache/record/ModuleCompilation;", "", "repository", "Lavail/persistence/cache/Repository;", "binaryStream", "Ljava/io/DataInputStream;", "(Lavail/persistence/cache/Repository;Ljava/io/DataInputStream;)V", "compilationTime", "", "recordNumber", "recordNumberOfBlockPhrases", "recordNumberOfManifest", "recordNumberOfStyling", "recordNumberOfPhrasePaths", "recordNumberOfNamesIndex", "(Lavail/persistence/cache/Repository;JJJJJJJ)V", "bytes", "", "getBytes", "()[B", "getCompilationTime", "()J", "getRecordNumber", "getRecordNumberOfBlockPhrases", "getRecordNumberOfManifest", "getRecordNumberOfNamesIndex", "getRecordNumberOfPhrasePaths", "getRecordNumberOfStyling", "getRepository", "()Lavail/persistence/cache/Repository;", "toString", "", "write", "", "Ljava/io/DataOutputStream;", "write$avail", "avail"})
public final class ModuleCompilation {
    @NotNull
    private final Repository repository;
    private final long compilationTime;
    private final long recordNumber;
    private final long recordNumberOfBlockPhrases;
    private final long recordNumberOfManifest;
    private final long recordNumberOfStyling;
    private final long recordNumberOfPhrasePaths;
    private final long recordNumberOfNamesIndex;

    @NotNull
    public final Repository getRepository() {
        return this.repository;
    }

    public final long getCompilationTime() {
        return this.compilationTime;
    }

    public final long getRecordNumber() {
        return this.recordNumber;
    }

    public final long getRecordNumberOfBlockPhrases() {
        return this.recordNumberOfBlockPhrases;
    }

    public final long getRecordNumberOfManifest() {
        return this.recordNumberOfManifest;
    }

    public final long getRecordNumberOfStyling() {
        return this.recordNumberOfStyling;
    }

    public final long getRecordNumberOfPhrasePaths() {
        return this.recordNumberOfPhrasePaths;
    }

    public final long getRecordNumberOfNamesIndex() {
        return this.recordNumberOfNamesIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] getBytes() {
        byte[] byArray;
        Lock lock = this.repository.getLock$avail();
        lock.lock();
        try {
            boolean bl = false;
            byArray = this.repository.get(this.recordNumber);
        }
        finally {
            lock.unlock();
        }
        return byArray;
    }

    public final void write$avail(@NotNull DataOutputStream binaryStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
        binaryStream.writeLong(this.compilationTime);
        CodingKt.zigzag(binaryStream, this.recordNumber);
        CodingKt.zigzag(binaryStream, this.recordNumberOfBlockPhrases);
        CodingKt.zigzag(binaryStream, this.recordNumberOfManifest);
        CodingKt.zigzag(binaryStream, this.recordNumberOfStyling);
        CodingKt.zigzag(binaryStream, this.recordNumberOfPhrasePaths);
        CodingKt.zigzag(binaryStream, this.recordNumberOfNamesIndex);
    }

    @NotNull
    public String toString() {
        String string2 = "Compilation(%tFT%<tTZ, rec=%d, phrases=%d, manifest=%d, styling=%d, phrase paths=%d, names index=%d)";
        Object[] objectArray = new Object[]{this.compilationTime, this.recordNumber, this.recordNumberOfBlockPhrases, this.recordNumberOfManifest, this.recordNumberOfStyling, this.recordNumberOfPhrasePaths, this.recordNumberOfNamesIndex};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        return string3;
    }

    public ModuleCompilation(@NotNull Repository repository, @NotNull DataInputStream binaryStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
        this(repository, binaryStream.readLong(), CodingKt.unzigzagLong(binaryStream), CodingKt.unzigzagLong(binaryStream), CodingKt.unzigzagLong(binaryStream), CodingKt.unzigzagLong(binaryStream), CodingKt.unzigzagLong(binaryStream), CodingKt.unzigzagLong(binaryStream));
    }

    public ModuleCompilation(@NotNull Repository repository, long compilationTime, long recordNumber, long recordNumberOfBlockPhrases, long recordNumberOfManifest, long recordNumberOfStyling, long recordNumberOfPhrasePaths, long recordNumberOfNamesIndex) throws IOException {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.repository = repository;
        this.compilationTime = compilationTime;
        this.recordNumber = recordNumber;
        this.recordNumberOfBlockPhrases = recordNumberOfBlockPhrases;
        this.recordNumberOfManifest = recordNumberOfManifest;
        this.recordNumberOfStyling = recordNumberOfStyling;
        this.recordNumberOfPhrasePaths = recordNumberOfPhrasePaths;
        this.recordNumberOfNamesIndex = recordNumberOfNamesIndex;
    }
}

