/*
 * Decompiled with CFR 0.152.
 */
package avail.tools.bootstrap;

import avail.descriptor.representation.AvailObject;
import avail.descriptor.types.A_Type;
import avail.interpreter.Primitive;
import avail.tools.bootstrap.BootstrapGenerator;
import avail.tools.bootstrap.PropertiesFileGenerator;
import avail.tools.bootstrap.Resources;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lavail/tools/bootstrap/PrimitiveNamesGenerator;", "Lavail/tools/bootstrap/PropertiesFileGenerator;", "locale", "Ljava/util/Locale;", "(Ljava/util/Locale;)V", "generateProperties", "", "properties", "Ljava/util/Properties;", "writer", "Ljava/io/PrintWriter;", "Companion", "avail"})
@SourceDebugExtension(value={"SMAP\nPrimitiveNamesGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimitiveNamesGenerator.kt\navail/tools/bootstrap/PrimitiveNamesGenerator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n215#2:233\n216#2:236\n1855#3,2:234\n1855#3,2:237\n*S KotlinDebug\n*F\n+ 1 PrimitiveNamesGenerator.kt\navail/tools/bootstrap/PrimitiveNamesGenerator\n*L\n78#1:233\n78#1:236\n174#1:234,2\n195#1:237,2\n*E\n"})
public final class PrimitiveNamesGenerator
extends PropertiesFileGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public PrimitiveNamesGenerator(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        super(Resources.INSTANCE.getPrimitivesBaseName(), locale);
    }

    @Override
    protected void generateProperties(@NotNull Properties properties, @NotNull PrintWriter writer) {
        Map.Entry<String, Primitive.PrimitiveHolder> element$iv;
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        PrintWriter $this$generateProperties_u24lambda_u244 = writer;
        boolean bl = false;
        Set keys = new LinkedHashSet();
        Object $this$forEach$iv = Primitive.PrimitiveHolder.Companion.getHoldersByName();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Primitive.PrimitiveHolder>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Primitive.PrimitiveHolder> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            Primitive.PrimitiveHolder holder = entry.getValue();
            Primitive primitive2 = holder.getPrimitive();
            if (primitive2.hasFlag(Primitive.Flag.Private)) continue;
            keys.add(primitive2.getSimpleName());
            Object[] objectArray = new Object[]{primitive2.getName(), primitive2.getArgCount()};
            $this$generateProperties_u24lambda_u244.format("# %s : _=%d%n", objectArray);
            $this$generateProperties_u24lambda_u244.print(primitive2.getSimpleName());
            $this$generateProperties_u24lambda_u244.print('=');
            String primitiveName = properties.getProperty(primitive2.getSimpleName());
            if (primitiveName != null) {
                $this$generateProperties_u24lambda_u244.print(Resources.INSTANCE.escape(primitiveName));
            }
            $this$generateProperties_u24lambda_u244.println();
            int i2 = 1;
            int n = primitive2.getArgCount();
            if (i2 <= n) {
                while (true) {
                    String argNameKey = Resources.INSTANCE.primitiveParameterNameKey(primitive2, i2);
                    keys.add(argNameKey);
                    $this$generateProperties_u24lambda_u244.print(argNameKey);
                    $this$generateProperties_u24lambda_u244.print('=');
                    String argName = properties.getProperty(argNameKey);
                    if (argName != null) {
                        $this$generateProperties_u24lambda_u244.print(Resources.INSTANCE.escape(argName));
                    }
                    $this$generateProperties_u24lambda_u244.println();
                    if (i2 == n) break;
                    ++i2;
                }
            }
            String commentKey = Resources.INSTANCE.primitiveCommentKey(primitive2);
            keys.add(commentKey);
            $this$generateProperties_u24lambda_u244.print(commentKey);
            $this$generateProperties_u24lambda_u244.print('=');
            String comment = properties.getProperty(commentKey);
            if (comment != null && ((CharSequence)comment).length() > 0) {
                $this$generateProperties_u24lambda_u244.print(Resources.INSTANCE.escape(comment));
            } else {
                String raises;
                Object[] objectArray2;
                int templateParameters = 0;
                templateParameters = 1;
                String commentTemplate = this.getPreambleBundle().getString("methodCommentTemplate");
                String parameters = null;
                int argCount = primitive2.getArgCount();
                if (argCount > 0) {
                    String parameterTemplate = this.getPreambleBundle().getString("methodCommentParameterTemplate");
                    StringBuilder builder = new StringBuilder(500);
                    int n2 = primitive2.getArgCount();
                    for (int i3 = 0; i3 < n2; ++i3) {
                        Intrinsics.checkNotNull((Object)parameterTemplate);
                        Object[] objectArray3 = new Object[]{"{" + templateParameters + "}", "{" + (templateParameters + argCount) + "}"};
                        builder.append(BootstrapGenerator.Companion.checkedFormat(parameterTemplate, objectArray3));
                        ++templateParameters;
                    }
                    templateParameters += argCount;
                    String string2 = builder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    parameters = string2;
                } else {
                    parameters = "";
                }
                String returnsTemplate = this.getPreambleBundle().getString("methodCommentReturnsTemplate");
                Intrinsics.checkNotNull((Object)returnsTemplate);
                Object[] i3 = new Object[]{"{" + templateParameters + "}"};
                String returns = BootstrapGenerator.Companion.checkedFormat(returnsTemplate, i3);
                ++templateParameters;
                Object[] $this$generateProperties_u24lambda_u244_u24lambda_u242_u24lambda_u241 = objectArray2 = new StringBuilder();
                boolean bl3 = false;
                if (!primitive2.hasFlag(Primitive.Flag.CannotFail)) {
                    String raisesTemplate = this.getPreambleBundle().getString("methodCommentRaisesTemplate");
                    AvailObject failureType = primitive2.getFailureVariableType();
                    if (failureType.isEnumeration()) {
                        Iterable $this$forEach$iv2 = A_Type.Companion.getInstances(failureType);
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            AvailObject cfr_ignored_0 = (AvailObject)element$iv2;
                            boolean bl4 = false;
                            Intrinsics.checkNotNull((Object)raisesTemplate);
                            Object[] objectArray4 = new Object[]{"{" + templateParameters + "}"};
                            $this$generateProperties_u24lambda_u244_u24lambda_u242_u24lambda_u241.append(BootstrapGenerator.Companion.checkedFormat(raisesTemplate, objectArray4));
                            ++templateParameters;
                        }
                    } else {
                        Intrinsics.checkNotNull((Object)raisesTemplate);
                        Object[] objectArray5 = new Object[]{"{" + templateParameters + "}"};
                        BootstrapGenerator.Companion.checkedFormat(raisesTemplate, objectArray5);
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2.toString(), (String)"StringBuilder().apply(builderAction).toString()");
                Intrinsics.checkNotNull((Object)commentTemplate);
                objectArray2 = new Object[]{parameters, returns, raises};
                $this$generateProperties_u24lambda_u244.print(Resources.INSTANCE.escape(BootstrapGenerator.Companion.checkedFormat(commentTemplate, objectArray2)));
            }
            $this$generateProperties_u24lambda_u244.println();
        }
        Set<Object> set2 = properties.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
        $this$forEach$iv = set2;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Primitive.PrimitiveHolder> property = element$iv = iterator2.next();
            boolean bl5 = false;
            Intrinsics.checkNotNull(property, (String)"null cannot be cast to non-null type kotlin.String");
            String key = (String)((Object)property);
            if (keys.contains(key)) continue;
            keys.add(key);
            $this$generateProperties_u24lambda_u244.print(key);
            $this$generateProperties_u24lambda_u244.print('=');
            String string3 = properties.getProperty(key);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(...)");
            $this$generateProperties_u24lambda_u244.println(Resources.INSTANCE.escape(string3));
        }
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) throws Exception {
        Companion.main(args);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lavail/tools/bootstrap/PrimitiveNamesGenerator$Companion;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "avail"})
    @SourceDebugExtension(value={"SMAP\nPrimitiveNamesGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimitiveNamesGenerator.kt\navail/tools/bootstrap/PrimitiveNamesGenerator$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,232:1\n13309#2,2:233\n*S KotlinDebug\n*F\n+ 1 PrimitiveNamesGenerator.kt\navail/tools/bootstrap/PrimitiveNamesGenerator$Companion\n*L\n226#1:233,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) throws Exception {
            String[] languages;
            String[] stringArray;
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (!(args.length == 0)) {
                stringArray = args;
            } else {
                String[] stringArray2 = new String[]{System.getProperty("user.language")};
                stringArray = stringArray2;
            }
            String[] $this$forEach$iv = languages = stringArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String language = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                new PrimitiveNamesGenerator(new Locale(language)).generate();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

