/*
 * Decompiled with CFR 0.152.
 */
package org.aws4s;

import cats.effect.Effect;
import cats.implicits$;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.aws4s.RequestSigning;
import org.aws4s.s3.PayloadSigning;
import org.http4s.Header;
import org.http4s.Header$;
import org.http4s.Headers;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RequestSigning$ {
    public static RequestSigning$ MODULE$;

    static {
        new RequestSigning$();
    }

    public RequestSigning apply(AWSCredentialsProvider credentialsProvider, String region, String service, PayloadSigning payloadSigning, Function0<LocalDateTime> clock) {
        return new RequestSigning(credentialsProvider, region, service, payloadSigning, clock);
    }

    public <F> F org$aws4s$RequestSigning$$sha256(FreeC<?, BoxedUnit> payload, Effect<F> evidence$1) {
        return (F)implicits$.MODULE$.toFunctorOps(Stream.InvariantOps$.MODULE$.runFold$extension(Stream$.MODULE$.InvariantOps(Stream$.MODULE$.chunks$extension(payload)), (Object)MessageDigest.getInstance("SHA-256"), (Function2 & Serializable & scala.Serializable)(md, chunk) -> {
            md.update((byte[])chunk.toArray(ClassTag$.MODULE$.Byte()));
            return md;
        }, evidence$1), evidence$1).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.digest());
    }

    public byte[] org$aws4s$RequestSigning$$sha256(byte[] payload) {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(payload);
        return md.digest();
    }

    public String org$aws4s$RequestSigning$$base16(byte[] data) {
        Seq BASE16MAP = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'}));
        return new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps((char[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).flatMap((Function1 & Serializable & scala.Serializable)object -> new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(new char[]{BoxesRunTime.unboxToChar((Object)BASE16MAP.apply(BoxesRunTime.unboxToByte((Object)object) >> 4 & 0xF)), BoxesRunTime.unboxToChar((Object)BASE16MAP.apply(BoxesRunTime.unboxToByte((Object)object) & 0xF))})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char())))).mkString();
    }

    public String org$aws4s$RequestSigning$$renderCanonicalQueryString(Map<String, String> queryParams) {
        return ((TraversableOnce)((TraversableLike)queryParams.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._1(), implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForString()))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = k + "=" + URLEncoder.encode(v, StandardCharsets.UTF_8.toString());
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("&");
    }

    private byte[] hmacSha256(String data, byte[] key) {
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(key, "HmacSHA256"));
        return mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
    }

    public String org$aws4s$RequestSigning$$renderCanonicalHeaders(Headers headers) {
        return ((TraversableOnce)((List)headers.toList().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name().value().toLowerCase(), implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForString()))).map((Function1 & Serializable & scala.Serializable)h -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{h.name().value().toLowerCase(), h.value()})), List$.MODULE$.canBuildFrom())).mkString();
    }

    public Header org$aws4s$RequestSigning$$xAmzDateHeader(LocalDateTime d) {
        return Header$.MODULE$.apply("x-amz-date", d.format(DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'")));
    }

    public Header org$aws4s$RequestSigning$$xAmzSecurityTokenHeader(String tokenValue) {
        return Header$.MODULE$.apply("x-amz-security-token", tokenValue);
    }

    public Header org$aws4s$RequestSigning$$xAmzContentSha256(String digest) {
        return Header$.MODULE$.apply("x-amz-content-sha256", digest);
    }

    public String org$aws4s$RequestSigning$$sign(String stringToSign, LocalDateTime now, AWSCredentials credentials, String region, String service) {
        byte[] kSecret = ("AWS4" + credentials.getAWSSecretKey()).getBytes(StandardCharsets.UTF_8);
        byte[] kDate = this.hmacSha256(now.format(DateTimeFormatter.BASIC_ISO_DATE), kSecret);
        byte[] kRegion = this.hmacSha256(region, kDate);
        byte[] kService = this.hmacSha256(service, kRegion);
        byte[] key = this.hmacSha256("aws4_request", kService);
        return this.org$aws4s$RequestSigning$$base16(this.hmacSha256(stringToSign, key));
    }

    private RequestSigning$() {
        MODULE$ = this;
    }
}

