/*
 * Decompiled with CFR 0.152.
 */
package org.axway.grapes.commons.datamodel;

import org.axway.grapes.commons.datamodel.Artifact;
import org.axway.grapes.commons.datamodel.Dependency;
import org.axway.grapes.commons.datamodel.License;
import org.axway.grapes.commons.datamodel.Module;
import org.axway.grapes.commons.datamodel.Scope;
import org.axway.grapes.commons.exceptions.UnsupportedScopeException;

public final class DataModelFactory {
    private DataModelFactory() {
    }

    public static Module createModule(String name, String version) {
        Module module = new Module();
        module.setName(name);
        module.setVersion(version);
        module.setPromoted(false);
        return module;
    }

    public static Artifact createArtifact(String groupId, String artifactId, String version, String classifier, String type, String extension) {
        Artifact artifact = new Artifact();
        artifact.setGroupId(groupId);
        artifact.setArtifactId(artifactId);
        artifact.setVersion(version);
        if (classifier != null) {
            artifact.setClassifier(classifier);
        }
        if (type != null) {
            artifact.setType(type);
        }
        if (extension != null) {
            artifact.setExtension(extension);
        }
        return artifact;
    }

    public static License createLicense(String name, String longName, String comments, String regexp, String url) {
        License license = new License();
        license.setName(name);
        license.setLongName(longName);
        license.setComments(comments);
        license.setRegexp(regexp);
        license.setUrl(url);
        return license;
    }

    public static Dependency createDependency(Artifact artifact, Scope scope) {
        Dependency dependency = new Dependency();
        dependency.setTarget(artifact);
        dependency.setScope(scope);
        return dependency;
    }

    public static Dependency createDependency(Artifact artifact, String scope) throws UnsupportedScopeException {
        try {
            Scope depScope = Scope.valueOf(scope.toUpperCase());
            return DataModelFactory.createDependency(artifact, depScope);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedScopeException();
        }
    }
}

