/*
 * Decompiled with CFR 0.152.
 */
package org.axway.grapes.commons.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class FileUtils {
    private FileUtils() {
    }

    public static void serialize(File folder, String content, String fileName) throws IOException {
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File output = new File(folder, fileName);
        FileWriter writer = null;
        try {
            writer = new FileWriter(output);
            writer.write(content);
            writer.flush();
        }
        catch (Exception e) {
            throw new IOException("Failed to serialize the notification in folder " + folder.getPath(), e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static String read(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            String sCurrentLine;
            br = new BufferedReader(new FileReader(file));
            while ((sCurrentLine = br.readLine()) != null) {
                sb.append(sCurrentLine);
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to read file: " + file.getAbsolutePath(), e);
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return sb.toString();
    }

    public static Long getSize(File file) {
        if (file != null && file.exists()) {
            return file.length();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void touch(File folder, String fileName) throws IOException {
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File touchedFile = new File(folder, fileName);
        FileOutputStream doneFOS = null;
        try {
            doneFOS = new FileOutputStream(touchedFile);
        }
        catch (FileNotFoundException e) {
        }
        finally {
            if (doneFOS != null) {
                doneFOS.close();
            }
        }
    }
}

