/*
 * Decompiled with CFR 0.152.
 */
package org.axway.grapes.utils.client;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.IOException;
import java.util.List;
import javax.naming.AuthenticationException;
import org.axway.grapes.commons.datamodel.Artifact;
import org.axway.grapes.commons.datamodel.Dependency;
import org.axway.grapes.commons.datamodel.License;
import org.axway.grapes.commons.datamodel.Module;
import org.axway.grapes.utils.client.GrapesCommunicationException;
import org.axway.grapes.utils.client.RequestUtils;
import org.axway.grapes.utils.data.model.ArtifactList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrapesClient {
    private static final Logger LOG = LoggerFactory.getLogger(GrapesClient.class);
    private final String serverURL;
    private Integer timeout = 60000;

    public GrapesClient(String host, String port) {
        StringBuilder sb = new StringBuilder();
        sb.append("http://");
        sb.append(host);
        if (port != null && !port.isEmpty()) {
            sb.append(":");
            sb.append(port);
        }
        sb.append("/");
        this.serverURL = sb.toString();
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    private Client getClient() {
        DefaultClientConfig cfg = new DefaultClientConfig();
        cfg.getClasses().add(JacksonJsonProvider.class);
        cfg.getProperties().put("com.sun.jersey.client.property.connectTimeout", this.timeout);
        Client jerseyClient = Client.create(cfg);
        return jerseyClient;
    }

    private Client getClient(String user, String password) throws AuthenticationException {
        if (user == null || password == null) {
            LOG.error("You are currently using a method that requires credentials. Please use '-user' '-password'.");
            throw new AuthenticationException();
        }
        Client client = this.getClient();
        client.addFilter(new HTTPBasicAuthFilter(user, password));
        return client;
    }

    public boolean isServerAvailable() {
        Client client = this.getClient();
        ClientResponse response = client.resource(this.serverURL).get(ClientResponse.class);
        if (ClientResponse.Status.OK.getStatusCode() == response.getStatus()) {
            return true;
        }
        LOG.error("Failed to reach the targeted Grapes server. Http status: " + response.getStatus());
        client.destroy();
        return false;
    }

    public void postModule(Module module, String user, String password) throws GrapesCommunicationException, AuthenticationException {
        Client client = this.getClient(user, password);
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.moduleResourcePath());
        ClientResponse response = resource.type("application/json").post(ClientResponse.class, (Object)module);
        client.destroy();
        if (ClientResponse.Status.CREATED.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to POST module. Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
    }

    public void deleteModule(String name, String version, String user, String password) throws GrapesCommunicationException, AuthenticationException {
        Client client = this.getClient(user, password);
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.getModulePath(name, version));
        ClientResponse response = resource.delete(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to DELETE module " + name + " in version " + version + ". Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
    }

    public Module getModule(String name, String version) throws GrapesCommunicationException {
        Client client = this.getClient();
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.getModulePath(name, version));
        ClientResponse response = resource.accept("application/json").get(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to get module " + name + " in version " + version + ". Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
        return response.getEntity(Module.class);
    }

    public void promoteModule(String name, String version, String user, String password) throws GrapesCommunicationException, AuthenticationException {
        Client client = this.getClient(user, password);
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.promoteModulePath(name, version));
        ClientResponse response = resource.type("application/json").post(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to promote module " + name + " in version " + version + ". Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
    }

    public Boolean moduleCanBePromoted(String name, String version) throws GrapesCommunicationException {
        Client client = this.getClient();
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.canBePromotedModulePath(name, version));
        ClientResponse response = resource.accept("application/json").get(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to get the promotion status of module " + name + " in version " + version + ". Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
        return response.getEntity(Boolean.class);
    }

    public void postArtifact(Artifact artifact, String user, String password) throws GrapesCommunicationException, AuthenticationException {
        Client client = this.getClient(user, password);
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.artifactResourcePath());
        ClientResponse response = resource.type("application/json").post(ClientResponse.class, (Object)artifact);
        client.destroy();
        if (ClientResponse.Status.CREATED.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to POST artifact. Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
    }

    public void deleteArtifact(String gavc, String user, String password) throws GrapesCommunicationException, AuthenticationException {
        Client client = this.getClient(user, password);
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.getArtifactPath(gavc));
        ClientResponse response = resource.delete(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to DELETE artifact " + gavc + ". Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
    }

    public Artifact getArtifact(String gavc) throws GrapesCommunicationException {
        Client client = this.getClient();
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.getArtifactPath(gavc));
        ClientResponse response = resource.accept("application/json").get(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to get artifact " + gavc + ". Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
        return response.getEntity(Artifact.class);
    }

    public List<Artifact> getArtifacts(Boolean isCorporate, Boolean hasLicense) throws GrapesCommunicationException {
        Client client = this.getClient();
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.getArtifactsPath());
        ClientResponse response = resource.queryParam("corporate", isCorporate.toString()).queryParam("hasLicense", hasLicense.toString()).accept("application/json").get(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to get artifacts. Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
        return response.getEntity(ArtifactList.class);
    }

    public void postDoNotUseArtifact(String gavc, Boolean doNotUse, String user, String password) throws GrapesCommunicationException, AuthenticationException {
        Client client = this.getClient(user, password);
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.getDoNotUseArtifact(gavc));
        ClientResponse response = resource.queryParam("doNotUse", doNotUse.toString()).accept("application/json").post(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to post do not use artifact. Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
    }

    public List<String> getArtifactVersions(String gavc) throws GrapesCommunicationException {
        Client client = this.getClient();
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.getArtifactVersions(gavc));
        ClientResponse response = resource.accept("application/json").get(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to get Corporate filters. Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
        return response.getEntity(new GenericType<List<String>>(){});
    }

    public String getArtifactLastVersion(String gavc) throws GrapesCommunicationException {
        Client client = this.getClient();
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.getArtifactLastVersion(gavc));
        ClientResponse response = resource.accept("application/json").get(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to get Corporate filters. Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
        return response.getEntity(String.class);
    }

    public void addLicense(String gavc, String licenseId, String user, String password) throws GrapesCommunicationException, AuthenticationException {
        Client client = this.getClient(user, password);
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.getArtifactLicensesPath(gavc));
        ClientResponse response = resource.queryParam("licenseId", licenseId).post(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to add license " + licenseId + " to artifact " + gavc + ". Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
    }

    public void postLicense(License license, String user, String password) throws GrapesCommunicationException, AuthenticationException {
        Client client = this.getClient(user, password);
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.licenseResourcePath());
        ClientResponse response = resource.type("application/json").post(ClientResponse.class, (Object)license);
        client.destroy();
        if (ClientResponse.Status.CREATED.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to POST license. Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
    }

    public void deleteLicense(String licenseId, String user, String password) throws GrapesCommunicationException, AuthenticationException {
        Client client = this.getClient(user, password);
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.getLicensePath(licenseId));
        ClientResponse response = resource.delete(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to DELETE license " + licenseId + ". Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
    }

    public License getLicense(String licenseId) throws GrapesCommunicationException {
        Client client = this.getClient();
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.getLicensePath(licenseId));
        ClientResponse response = resource.accept("application/json").get(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to get license " + licenseId + ". Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
        return response.getEntity(License.class);
    }

    public void approveLicense(String licenseId, Boolean approve, String user, String password) throws GrapesCommunicationException, AuthenticationException {
        Client client = this.getClient(user, password);
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.getLicensePath(licenseId));
        ClientResponse response = resource.queryParam("approved", approve.toString()).post(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to approve license " + licenseId + ". Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
    }

    public List<Dependency> getModuleAncestors(String moduleName, String moduleVersion) throws GrapesCommunicationException {
        Client client = this.getClient();
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.getArtifactAncestors(moduleName, moduleVersion));
        ClientResponse response = resource.queryParam("scopeComp", "true").queryParam("scopePro", "true").queryParam("scopeRun", "true").queryParam("scopeTest", "true").accept("application/json").get(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to get module ancestors " + moduleName + " in version " + moduleVersion + ". Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
        return response.getEntity(new GenericType<List<Dependency>>(){});
    }

    public List<Dependency> getModuleDependencies(String moduleName, String moduleVersion, Boolean fullRecursive, Boolean corporate, Boolean thirdParty) throws GrapesCommunicationException {
        Client client = this.getClient();
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.getArtifactDependencies(moduleName, moduleVersion));
        ClientResponse response = resource.queryParam("scopeComp", "true").queryParam("scopePro", "true").queryParam("scopeRun", "true").queryParam("scopeTest", "true").queryParam("fullRecursive", fullRecursive.toString()).queryParam("corporate", corporate.toString()).queryParam("showThirdparty", thirdParty.toString()).accept("application/json").get(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to get module ancestors " + moduleName + " in version " + moduleVersion + ". Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
        return response.getEntity(new GenericType<List<Dependency>>(){});
    }

    public List<String> getCorporateFilters() throws GrapesCommunicationException, IOException {
        Client client = this.getClient();
        WebResource resource = client.resource(this.serverURL).path(RequestUtils.getCorporateFilters());
        ClientResponse response = resource.accept("application/json").get(ClientResponse.class);
        client.destroy();
        if (ClientResponse.Status.OK.getStatusCode() != response.getStatus()) {
            LOG.error("Failed to get Corporate filters. Http status: " + response.getStatus());
            throw new GrapesCommunicationException(response.getStatus());
        }
        return response.getEntity(new GenericType<List<String>>(){});
    }
}

