/*
 * Decompiled with CFR 0.152.
 */
package org.axway.grapes.utils.client;

public final class RequestUtils {
    private RequestUtils() {
    }

    public static String moduleResourcePath() {
        StringBuilder path = new StringBuilder();
        path.append("module");
        return path.toString();
    }

    public static String artifactResourcePath() {
        StringBuilder path = new StringBuilder();
        path.append("artifact");
        return path.toString();
    }

    public static String licenseResourcePath() {
        StringBuilder path = new StringBuilder();
        path.append("license");
        return path.toString();
    }

    public static String getModulePath(String name, String version) {
        StringBuilder path = new StringBuilder();
        path.append(RequestUtils.moduleResourcePath());
        path.append("/");
        path.append(name);
        path.append("/");
        path.append(version);
        return path.toString();
    }

    public static String getArtifactPath(String gavc) {
        StringBuilder path = new StringBuilder();
        path.append(RequestUtils.artifactResourcePath());
        path.append("/");
        path.append(gavc);
        return path.toString();
    }

    public static String getLicensePath(String licenseId) {
        StringBuilder path = new StringBuilder();
        path.append(RequestUtils.licenseResourcePath());
        path.append("/");
        path.append(licenseId);
        return path.toString();
    }

    public static String promoteModulePath(String name, String version) {
        StringBuilder path = new StringBuilder();
        path.append(RequestUtils.getModulePath(name, version));
        path.append("/promotion");
        return path.toString();
    }

    public static String canBePromotedModulePath(String name, String version) {
        StringBuilder path = new StringBuilder();
        path.append(RequestUtils.getModulePath(name, version));
        path.append("/promotion");
        path.append("/doable");
        return path.toString();
    }

    public static String getArtifactLicensesPath(String gavc) {
        StringBuilder path = new StringBuilder();
        path.append(RequestUtils.getArtifactPath(gavc));
        path.append("/licenses");
        return path.toString();
    }

    public static String getArtifactAncestors(String name, String version) {
        StringBuilder path = new StringBuilder();
        path.append(RequestUtils.getModulePath(name, version));
        path.append("/ancestors");
        return path.toString();
    }

    public static String getArtifactDependencies(String name, String version) {
        StringBuilder path = new StringBuilder();
        path.append(RequestUtils.getModulePath(name, version));
        path.append("/dependencies");
        return path.toString();
    }

    public static String getArtifactsPath() {
        StringBuilder path = new StringBuilder();
        path.append(RequestUtils.artifactResourcePath());
        path.append("/all");
        return path.toString();
    }

    public static String getDoNotUseArtifact(String gavc) {
        StringBuilder path = new StringBuilder();
        path.append(RequestUtils.artifactResourcePath());
        path.append("/");
        path.append(gavc);
        path.append("/donotuse");
        return path.toString();
    }

    public static String getArtifactVersions(String gavc) {
        StringBuilder path = new StringBuilder();
        path.append(RequestUtils.artifactResourcePath());
        path.append("/");
        path.append(gavc);
        path.append("/versions");
        return path.toString();
    }

    public static String getArtifactLastVersion(String gavc) {
        StringBuilder path = new StringBuilder();
        path.append(RequestUtils.artifactResourcePath());
        path.append("/");
        path.append(gavc);
        path.append("/lastversion");
        return path.toString();
    }

    public static String getCorporateFilters() {
        return "/corporatefilters";
    }
}

