/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jaxb.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DomElementJsonSerializer
extends StdSerializer<Element> {
    public DomElementJsonSerializer() {
        super(Element.class);
    }

    @Override
    public void serialize(Element element, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        NodeList nodeList;
        Object object;
        NamedNodeMap namedNodeMap;
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("name", element.getTagName());
        if (element.getNamespaceURI() != null) {
            jsonGenerator.writeStringField("namespace", element.getNamespaceURI());
        }
        if ((namedNodeMap = element.getAttributes()) != null && namedNodeMap.getLength() > 0) {
            jsonGenerator.writeArrayFieldStart("attributes");
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("$", attr.getValue());
                jsonGenerator.writeStringField("name", attr.getName());
                object = attr.getNamespaceURI();
                if (object != null) {
                    jsonGenerator.writeStringField("namespace", (String)object);
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        }
        if ((nodeList = element.getChildNodes()) != null && nodeList.getLength() > 0) {
            jsonGenerator.writeArrayFieldStart("children");
            block5: for (int i = 0; i < nodeList.getLength(); ++i) {
                object = nodeList.item(i);
                switch (object.getNodeType()) {
                    case 3: 
                    case 4: {
                        jsonGenerator.writeStartObject();
                        jsonGenerator.writeStringField("$", object.getNodeValue());
                        jsonGenerator.writeEndObject();
                        continue block5;
                    }
                    case 1: {
                        this.serialize((Element)object, jsonGenerator, serializerProvider);
                    }
                }
            }
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        ObjectNode objectNode = this.createSchemaNode("object", true);
        objectNode.put("name", this.createSchemaNode("string"));
        objectNode.put("namespace", this.createSchemaNode("string", true));
        objectNode.put("attributes", this.createSchemaNode("array", true));
        objectNode.put("children", this.createSchemaNode("array", true));
        return objectNode;
    }
}

