/*
 * Decompiled with CFR 0.152.
 */
package org.axway.grapes.commons.datamodel;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.axway.grapes.commons.datamodel.Artifact;
import org.axway.grapes.commons.datamodel.Dependency;

public class Module {
    private String name;
    private String version;
    private boolean promoted = false;
    private boolean isSubmodule = false;
    private Set<Artifact> artifacts = new HashSet<Artifact>();
    private Set<Dependency> dependencies = new HashSet<Dependency>();
    private Set<Module> submodules = new HashSet<Module>();

    protected Module() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Set<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public boolean isPromoted() {
        return this.promoted;
    }

    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public Set<Module> getSubmodules() {
        return this.submodules;
    }

    public boolean isSubmodule() {
        return this.isSubmodule;
    }

    public void setSubmodule(boolean isSubmodule) {
        this.isSubmodule = isSubmodule;
    }

    public void setPromoted(boolean promoted) {
        this.promoted = promoted;
        for (Artifact artifact : this.artifacts) {
            artifact.setPromoted(promoted);
        }
        for (Module suModule : this.submodules) {
            suModule.setPromoted(promoted);
        }
    }

    public void addDependency(Dependency dependency) {
        if (dependency != null && !this.dependencies.contains(dependency)) {
            this.dependencies.add(dependency);
        }
    }

    public void addSubmodule(Module submodule) {
        if (!this.submodules.contains(submodule)) {
            submodule.setSubmodule(true);
            if (this.promoted) {
                submodule.setPromoted(this.promoted);
            }
            this.submodules.add(submodule);
        }
    }

    public void addArtifact(Artifact artifact) {
        if (!this.artifacts.contains(artifact)) {
            if (this.promoted) {
                artifact.setPromoted(this.promoted);
            }
            this.artifacts.add(artifact);
        }
    }

    public void addAllArtifacts(List<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            this.addArtifact(artifact);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Module) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(this.version);
        return sb.toString().hashCode();
    }
}

