/*
 * Decompiled with CFR 0.152.
 */
package org.axway.grapes.commons.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.axway.grapes.commons.datamodel.Artifact;
import org.axway.grapes.commons.datamodel.License;
import org.axway.grapes.commons.datamodel.Module;
import org.axway.grapes.commons.datamodel.Organization;

public final class JsonUtils {
    public static final String JSON_CONTENT_TYPE = "application/json";

    private JsonUtils() {
    }

    public static String serialize(Object obj) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(MapperFeature.USE_GETTERS_AS_SETTERS);
        return mapper.writeValueAsString(obj);
    }

    public static Organization unserializeOrganization(String organization) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(MapperFeature.USE_GETTERS_AS_SETTERS);
        return mapper.readValue(organization, Organization.class);
    }

    public static Module unserializeModule(String module) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(MapperFeature.USE_GETTERS_AS_SETTERS);
        return mapper.readValue(module, Module.class);
    }

    public static Map<String, String> unserializeBuildInfo(String buildInfo) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(MapperFeature.USE_GETTERS_AS_SETTERS);
        return (Map)mapper.readValue(buildInfo, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static Artifact unserializeArtifact(String artifact) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(MapperFeature.USE_GETTERS_AS_SETTERS);
        return mapper.readValue(artifact, Artifact.class);
    }

    public static License unserializeLicense(String license) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(MapperFeature.USE_GETTERS_AS_SETTERS);
        return mapper.readValue(license, License.class);
    }
}

