/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete;

import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.value.Ref;
import org.aya.api.concrete.ConcretePat;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.LocalVar;
import org.aya.api.ref.Var;
import org.aya.api.util.WithPos;
import org.aya.concrete.Expr;
import org.aya.distill.ConcreteDistiller;
import org.aya.pretty.doc.Doc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Pattern
extends ConcretePat {
    @NotNull
    default public Doc toDoc(@NotNull DistillerOptions options) {
        return this.accept(new ConcreteDistiller(options), false);
    }

    default public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
        visitor.traceEntrance(this, p);
        R ret = this.doAccept(visitor, p);
        visitor.traceExit(ret, this, p);
        return ret;
    }

    public <P, R> R doAccept(@NotNull Visitor<P, R> var1, P var2);

    public static interface Visitor<P, R> {
        public R visitTuple(@NotNull Tuple var1, P var2);

        public R visitNumber(@NotNull Number var1, P var2);

        public R visitAbsurd(@NotNull Absurd var1, P var2);

        public R visitBind(@NotNull Bind var1, P var2);

        public R visitCalmFace(@NotNull CalmFace var1, P var2);

        public R visitCtor(@NotNull Ctor var1, P var2);

        default public void traceEntrance(@NotNull Pattern pat, P p) {
        }

        default public void traceExit(R r, @NotNull Pattern pat, P p) {
        }
    }

    public static final class Clause {
        @NotNull
        public final SourcePos sourcePos;
        @NotNull
        public final ImmutableSeq<Pattern> patterns;
        @NotNull
        public Option<Expr> expr;
        public boolean hasError = false;

        public Clause(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Pattern> patterns, @NotNull Option<Expr> expr) {
            this.sourcePos = sourcePos;
            this.patterns = patterns;
            this.expr = expr;
        }
    }

    public record Ctor(@NotNull SourcePos sourcePos, boolean explicit, @NotNull WithPos<String> name, @NotNull ImmutableSeq<Pattern> params, @Nullable LocalVar as, @NotNull Ref<@Nullable Var> resolved) implements Pattern
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitCtor(this, p);
        }
    }

    public record Bind(@NotNull SourcePos sourcePos, boolean explicit, @NotNull LocalVar bind, @NotNull Ref<@Nullable Var> resolved) implements Pattern
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitBind(this, p);
        }
    }

    public record CalmFace(@NotNull SourcePos sourcePos, boolean explicit) implements Pattern
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitCalmFace(this, p);
        }
    }

    public record Absurd(@NotNull SourcePos sourcePos, boolean explicit) implements Pattern
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitAbsurd(this, p);
        }
    }

    public record Number(@NotNull SourcePos sourcePos, boolean explicit, int number) implements Pattern
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitNumber(this, p);
        }
    }

    public record Tuple(@NotNull SourcePos sourcePos, boolean explicit, @NotNull ImmutableSeq<Pattern> patterns, @Nullable LocalVar as) implements Pattern
    {
        @Override
        public <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitTuple(this, p);
        }
    }
}

