/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.desugar;

import java.util.function.Function;
import kala.collection.Seq;
import kala.collection.SeqView;
import kala.collection.Set;
import kala.collection.mutable.Buffer;
import kala.collection.mutable.DoubleLinkedBuffer;
import kala.collection.mutable.LinkedBuffer;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableSet;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.api.distill.AyaDocile;
import org.aya.api.error.Problem;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.LocalVar;
import org.aya.api.ref.Var;
import org.aya.api.util.Arg;
import org.aya.api.util.Assoc;
import org.aya.concrete.Expr;
import org.aya.concrete.desugar.BinOpSet;
import org.aya.concrete.desugar.error.OperatorProblem;
import org.aya.concrete.stmt.OpDecl;
import org.aya.concrete.stmt.Signatured;
import org.aya.pretty.doc.Doc;
import org.aya.util.Constants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BinOpParser {
    @NotNull
    private final BinOpSet opSet;
    @NotNull
    private final @NotNull SeqView<@NotNull Elem> seq;
    private final LinkedBuffer<Tuple2<Elem, BinOpSet.BinOP>> opStack = LinkedBuffer.of();
    private final DoubleLinkedBuffer<Elem> prefixes = DoubleLinkedBuffer.of();
    private final MutableMap<Elem, MutableSet<AppliedSide>> appliedOperands = MutableMap.create();

    public BinOpParser(@NotNull BinOpSet opSet, @NotNull @NotNull SeqView<@NotNull Elem> seq) {
        this.opSet = opSet;
        this.seq = seq;
    }

    @NotNull
    public Expr build(@NotNull SourcePos sourcePos) {
        if (this.seq.sizeEquals(1)) {
            return ((Elem)this.seq.get((int)0)).expr;
        }
        if (this.seq.sizeEquals(2)) {
            Elem first = (Elem)this.seq.get(0);
            Elem second = (Elem)this.seq.get(1);
            if (this.opSet.assocOf((OpDecl)first.asOpDecl()).infix && first.argc() == 2) {
                return this.makeSectionApp(sourcePos, first, elem -> new BinOpParser(this.opSet, (SeqView<Elem>)this.seq.prepended(elem)).build(sourcePos));
            }
            if (this.opSet.assocOf((OpDecl)second.asOpDecl()).infix && second.argc() == 2) {
                return this.makeSectionApp(sourcePos, second, elem -> new BinOpParser(this.opSet, (SeqView<Elem>)this.seq.appended(elem)).build(sourcePos));
            }
        }
        return this.convertToPrefix(sourcePos);
    }

    public @NotNull Expr.LamExpr makeSectionApp(@NotNull SourcePos sourcePos, @NotNull Elem op, @NotNull Function<Elem, Expr> lamBody) {
        LocalVar missing = Constants.randomlyNamed(op.expr.sourcePos());
        Elem missingElem = new Elem(new Expr.RefExpr(SourcePos.NONE, (Var)missing), true);
        Expr.Param missingParam = new Expr.Param(missing.definition(), missing, true);
        return new Expr.LamExpr(sourcePos, missingParam, lamBody.apply(missingElem));
    }

    @NotNull
    private Expr convertToPrefix(@NotNull SourcePos sourcePos) {
        for (Elem expr : this.insertApplication(this.seq)) {
            if (expr.isOperand(this.opSet)) {
                this.prefixes.append((Object)expr);
                continue;
            }
            BinOpSet.BinOP currentOp = expr.toSetElem(this.opSet);
            while (this.opStack.isNotEmpty()) {
                Tuple2 top = (Tuple2)this.opStack.peek();
                BinOpSet.PredCmp cmp = this.opSet.compare((BinOpSet.BinOP)top._2, currentOp);
                if (cmp == BinOpSet.PredCmp.Tighter) {
                    this.foldLhsFor(expr);
                    continue;
                }
                if (cmp == BinOpSet.PredCmp.Equal) {
                    Assoc currentAssoc;
                    Assoc topAssoc = ((BinOpSet.BinOP)top._2).assoc();
                    if (topAssoc != (currentAssoc = currentOp.assoc()) || topAssoc == Assoc.Infix) {
                        this.opSet.reporter().report((Problem)new OperatorProblem.FixityError(currentOp.name(), currentAssoc, ((BinOpSet.BinOP)top._2).name(), topAssoc, ((Elem)top._1).expr.sourcePos()));
                        return new Expr.ErrorExpr(sourcePos, Doc.english((String)"an application"));
                    }
                    if (topAssoc != Assoc.InfixL) break;
                    this.foldLhsFor(expr);
                    continue;
                }
                if (cmp == BinOpSet.PredCmp.Looser) break;
                this.opSet.reporter().report((Problem)new OperatorProblem.AmbiguousPredError(currentOp.name(), ((BinOpSet.BinOP)top._2).name(), ((Elem)top._1).expr.sourcePos()));
                return new Expr.ErrorExpr(sourcePos, Doc.english((String)"an application"));
            }
            this.opStack.push((Object)Tuple.of((Object)expr, (Object)currentOp));
        }
        while (this.opStack.isNotEmpty()) {
            this.foldTop();
            if (!this.opStack.isNotEmpty()) continue;
            this.markAppliedOperand((Elem)((Tuple2)this.opStack.peek())._1, AppliedSide.Rhs);
        }
        assert (this.prefixes.sizeEquals(1));
        return ((Elem)this.prefixes.first()).expr;
    }

    @NotNull
    private Seq<Elem> insertApplication(@NotNull @NotNull SeqView<@NotNull Elem> seq) {
        Buffer seqWithApp = Buffer.create();
        boolean lastIsOperand = true;
        for (Elem expr : seq) {
            boolean isOperand = expr.isOperand(this.opSet);
            if (isOperand && lastIsOperand && seqWithApp.isNotEmpty()) {
                seqWithApp.append((Object)Elem.OP_APP);
            }
            lastIsOperand = isOperand;
            seqWithApp.append((Object)expr);
        }
        return seqWithApp;
    }

    private void markAppliedOperand(@NotNull Elem elem, @NotNull AppliedSide side) {
        ((MutableSet)this.appliedOperands.getOrPut((Object)elem, MutableSet::of)).add((Object)side);
    }

    @NotNull
    private Set<AppliedSide> getAppliedSides(@NotNull Elem elem) {
        return (Set)this.appliedOperands.getOrPut((Object)elem, MutableSet::of);
    }

    private void foldLhsFor(@NotNull Elem forOp) {
        this.foldTop();
        this.markAppliedOperand(forOp, AppliedSide.Lhs);
    }

    private void foldTop() {
        Tuple2 op = (Tuple2)this.opStack.pop();
        Expr app = this.makeBinApp((Elem)op._1);
        this.prefixes.append((Object)new Elem(app, ((Elem)op._1).explicit));
    }

    @NotNull
    private Expr makeBinApp(@NotNull Elem op) {
        int argc = op.argc();
        if (argc == 1) {
            Elem operand = (Elem)this.prefixes.dequeue();
            return new Expr.AppExpr(this.union(operand, op), op.expr, operand.toNamedArg());
        }
        if (argc == 2) {
            if (this.prefixes.sizeGreaterThanOrEquals(2)) {
                Elem rhs = (Elem)this.prefixes.dequeue();
                Elem lhs = (Elem)this.prefixes.dequeue();
                return this.makeBinApp(op, rhs, lhs);
            }
            if (this.prefixes.sizeEquals(1)) {
                Set<AppliedSide> sides = this.getAppliedSides(op);
                Elem applied = (Elem)this.prefixes.dequeue();
                AppliedSide side = (AppliedSide)((Object)sides.elementAt(0));
                return this.makeSectionApp(this.union(op, applied), op, elem -> switch (side) {
                    default -> throw new IncompatibleClassChangeError();
                    case AppliedSide.Lhs -> this.makeBinApp(op, (Elem)elem, applied);
                    case AppliedSide.Rhs -> this.makeBinApp(op, applied, (Elem)elem);
                });
            }
        }
        throw new UnsupportedOperationException("TODO?");
    }

    @NotNull
    private Expr makeBinApp(@NotNull Elem op, @NotNull Elem rhs, @NotNull Elem lhs) {
        if (op == Elem.OP_APP) {
            return new Expr.AppExpr(this.union(lhs, rhs), lhs.expr, rhs.toNamedArg());
        }
        return new Expr.AppExpr(this.union(op, lhs, rhs), new Expr.AppExpr(this.union(op, lhs), op.expr, lhs.toNamedArg()), rhs.toNamedArg());
    }

    @NotNull
    private SourcePos union(@NotNull Elem a, @NotNull Elem b, @NotNull Elem c) {
        return this.union(a, b).union(c.expr.sourcePos());
    }

    @NotNull
    private SourcePos union(@NotNull Elem a, @NotNull Elem b) {
        return a.expr.sourcePos().union(b.expr.sourcePos());
    }

    public record Elem(@Nullable String name, @NotNull Expr expr, boolean explicit) {
        private static final Elem OP_APP = new Elem(BinOpSet.APP_ELEM.name(), new Expr.ErrorExpr(SourcePos.NONE, Doc.english((String)"fakeApp escaped from BinOpParser")), true);

        public Elem(@NotNull Expr expr, boolean explicit) {
            this(null, expr, explicit);
        }

        @Nullable
        private OpDecl asOpDecl() {
            Expr.RefExpr ref;
            Expr expr = this.expr;
            if (expr instanceof Expr.RefExpr && (expr = (ref = (Expr.RefExpr)expr).resolvedVar()) instanceof DefVar) {
                DefVar defVar = (DefVar)expr;
                expr = defVar.concrete;
                if (expr instanceof OpDecl) {
                    OpDecl opDecl = (OpDecl)((Object)expr);
                    return opDecl;
                }
            }
            return null;
        }

        public boolean isOperand(@NotNull BinOpSet opSet) {
            if (this == OP_APP) {
                return false;
            }
            OpDecl tryOp = this.asOpDecl();
            return opSet.isOperand(tryOp);
        }

        public @NotNull BinOpSet.BinOP toSetElem(@NotNull BinOpSet opSet) {
            if (this == OP_APP) {
                return BinOpSet.APP_ELEM;
            }
            OpDecl tryOp = this.asOpDecl();
            assert (tryOp != null);
            return opSet.ensureHasElem(tryOp);
        }

        private int argc() {
            if (this == OP_APP) {
                return 2;
            }
            OpDecl opDecl = this.asOpDecl();
            if (opDecl instanceof Signatured) {
                Signatured sig = (Signatured)((Object)opDecl);
                return this.countExplicitParam((Seq<Expr.Param>)sig.telescope);
            }
            throw new IllegalArgumentException("not an operator");
        }

        private int countExplicitParam(@NotNull Seq<Expr.Param> telescope) {
            return telescope.view().count(Expr.Param::explicit);
        }

        @NotNull
        public Arg<Expr.NamedArg> toNamedArg() {
            return new Arg((AyaDocile)new Expr.NamedArg(this.name, this.expr), this.explicit);
        }
    }

    static enum AppliedSide {
        Lhs,
        Rhs;

    }
}

