/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.desugar;

import kala.collection.mutable.Buffer;
import kala.collection.mutable.LinkedBuffer;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableHashSet;
import kala.collection.mutable.MutableSet;
import kala.control.Option;
import kala.value.Ref;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourcePos;
import org.aya.api.util.Assoc;
import org.aya.concrete.desugar.error.OperatorProblem;
import org.aya.concrete.resolve.context.Context;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.OpDecl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BinOpSet(@NotNull Reporter reporter, @NotNull MutableSet<BinOP> ops, @NotNull MutableHashMap<BinOP, MutableHashSet<BinOP>> tighterGraph) {
    @NotNull
    static final BinOP APP_ELEM = BinOP.from(SourcePos.NONE, () -> new OpDecl.Operator("application", Assoc.InfixL));

    public BinOpSet(@NotNull Reporter reporter) {
        this(reporter, (MutableSet<BinOP>)MutableSet.of((Object)APP_ELEM), (MutableHashMap<BinOP, MutableHashSet<BinOP>>)MutableHashMap.of());
    }

    public void bind(@NotNull OpDecl op, @NotNull Command.BindPred pred, @NotNull OpDecl target, @NotNull SourcePos sourcePos) {
        BinOP targetElem;
        BinOP opElem = this.ensureHasElem(op, sourcePos);
        if (opElem == (targetElem = this.ensureHasElem(target, sourcePos))) {
            this.reporter.report((Problem)new OperatorProblem.BindSelfError(sourcePos));
            throw new Context.ResolvingInterruptedException();
        }
        switch (pred) {
            case Tighter: {
                this.addTighter(opElem, targetElem);
                break;
            }
            case Looser: {
                this.addTighter(targetElem, opElem);
            }
        }
    }

    public PredCmp compare(@NotNull BinOP lhs, @NotNull BinOP rhs) {
        if (lhs == APP_ELEM) {
            return PredCmp.Tighter;
        }
        if (rhs == APP_ELEM) {
            return PredCmp.Looser;
        }
        if (lhs == rhs) {
            return PredCmp.Equal;
        }
        if (this.hasPath((MutableSet<BinOP>)MutableSet.of(), lhs, rhs)) {
            return PredCmp.Tighter;
        }
        if (this.hasPath((MutableSet<BinOP>)MutableSet.of(), rhs, lhs)) {
            return PredCmp.Looser;
        }
        return PredCmp.Undefined;
    }

    private boolean hasPath(@NotNull MutableSet<BinOP> book, @NotNull BinOP from, @NotNull BinOP to) {
        if (from == to) {
            return true;
        }
        if (book.contains((Object)from)) {
            return false;
        }
        for (BinOP test : this.ensureGraphHas(from)) {
            if (!this.hasPath(book, test, to)) continue;
            return true;
        }
        book.add((Object)from);
        return false;
    }

    public Assoc assocOf(@Nullable OpDecl opDecl) {
        if (this.isOperand(opDecl)) {
            return Assoc.Invalid;
        }
        return this.ensureHasElem((OpDecl)opDecl).assoc;
    }

    public boolean isOperand(@Nullable OpDecl opDecl) {
        return opDecl == null || opDecl.asOperator() == null;
    }

    public BinOP ensureHasElem(@NotNull OpDecl opDecl) {
        return this.ensureHasElem(opDecl, SourcePos.NONE);
    }

    public BinOP ensureHasElem(@NotNull OpDecl opDecl, @NotNull SourcePos sourcePos) {
        Option elem = this.ops.find(e -> e.op == opDecl);
        if (elem.isDefined()) {
            return (BinOP)elem.get();
        }
        BinOP newElem = BinOP.from(sourcePos, opDecl);
        this.ops.add((Object)newElem);
        return newElem;
    }

    private MutableHashSet<BinOP> ensureGraphHas(@NotNull BinOP elem) {
        return (MutableHashSet)this.tighterGraph.getOrPut((Object)elem, MutableHashSet::of);
    }

    private void addTighter(@NotNull BinOP from, @NotNull BinOP to) {
        this.ensureGraphHas(to);
        this.ensureGraphHas(from).add((Object)to);
    }

    public void sort() {
        MutableHashMap ind = MutableHashMap.of();
        this.tighterGraph.forEach((from, tos) -> {
            ind.putIfAbsent(from, (Object)new Ref((Object)0));
            tos.forEach(to -> {
                Ref ref = (Ref)ind.getOrPut(to, () -> new Ref((Object)0));
                ref.value = (Integer)ref.value + 1;
            });
        });
        LinkedBuffer stack = LinkedBuffer.of();
        ind.forEach((e, i) -> {
            if ((Integer)i.value == 0) {
                stack.push(e);
            }
        });
        int count = 0;
        while (stack.isNotEmpty()) {
            BinOP elem = (BinOP)stack.pop();
            ++count;
            ((MutableHashSet)this.tighterGraph.get((Object)elem)).forEach(to -> {
                Ref ref = (Ref)ind.get(to);
                ref.value = (Integer)ref.value - 1;
                if ((Integer)ref.value == 0) {
                    stack.push(to);
                }
            });
        }
        if (count != this.tighterGraph.size()) {
            Buffer circle = Buffer.create();
            ind.forEach((e, i) -> {
                if ((Integer)i.value > 0) {
                    circle.append(e);
                }
            });
            this.reporter.report((Problem)new OperatorProblem.CircleError((Buffer<BinOP>)circle));
            throw new Context.ResolvingInterruptedException();
        }
    }

    public record BinOP(@NotNull SourcePos firstBind, @NotNull OpDecl op, @NotNull String name, @NotNull Assoc assoc) {
        @NotNull
        private static OpDecl.Operator ensureOperator(@NotNull OpDecl opDecl) {
            OpDecl.Operator op = opDecl.asOperator();
            if (op == null) {
                throw new IllegalArgumentException("not an operator");
            }
            return op;
        }

        @NotNull
        private static BinOP from(@NotNull SourcePos sourcePos, @NotNull OpDecl opDecl) {
            OpDecl.Operator op = BinOP.ensureOperator(opDecl);
            return new BinOP(sourcePos, opDecl, op.name(), op.assoc());
        }
    }

    public static enum PredCmp {
        Looser,
        Tighter,
        Undefined,
        Equal;

    }
}

