/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.desugar;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.function.CheckedSupplier;
import kala.tuple.Unit;
import org.aya.api.distill.AyaDocile;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.ref.PreLevelVar;
import org.aya.api.ref.Var;
import org.aya.concrete.Expr;
import org.aya.concrete.desugar.BinOpParser;
import org.aya.concrete.desugar.BinOpSet;
import org.aya.concrete.desugar.error.LevelProblem;
import org.aya.concrete.visitor.StmtFixpoint;
import org.aya.generic.Level;
import org.aya.util.Constants;
import org.jetbrains.annotations.NotNull;

public record Desugarer(@NotNull Reporter reporter, @NotNull BinOpSet opSet) implements StmtFixpoint<Unit>
{
    @Override
    @NotNull
    public Expr visitApp(@NotNull Expr.AppExpr expr, Unit unit) {
        Expr expr2 = expr.function();
        if (expr2 instanceof Expr.RawUnivExpr) {
            Expr.RawUnivExpr univ = (Expr.RawUnivExpr)expr2;
            return this.desugarUniv(expr, univ);
        }
        return StmtFixpoint.super.visitApp(expr, unit);
    }

    @Override
    @NotNull
    public Expr visitRawUniv(@NotNull Expr.RawUnivExpr expr, Unit unit) {
        return new Expr.UnivExpr(expr.sourcePos(), new Level.Polymorphic(0));
    }

    @Override
    @NotNull
    public Expr visitRawUnivArgs(@NotNull Expr.RawUnivArgsExpr expr, Unit unit) {
        return this.catching(expr, (CheckedSupplier<Expr, DesugarInterruption>)((CheckedSupplier)() -> new Expr.UnivArgsExpr(expr.sourcePos(), (ImmutableSeq<Level<PreLevelVar>>)expr.univArgs().mapChecked(this::levelVar))));
    }

    @NotNull
    private Expr desugarUniv(@NotNull Expr.AppExpr expr, Expr.RawUnivExpr univ) {
        return this.catching(expr, (CheckedSupplier<Expr, DesugarInterruption>)((CheckedSupplier)() -> new Expr.UnivExpr(univ.sourcePos(), this.levelVar(((Expr.NamedArg)expr.argument().term()).expr()))));
    }

    @NotNull
    private Expr catching(@NotNull Expr expr, @NotNull @NotNull CheckedSupplier<@NotNull Expr, DesugarInterruption> f) {
        try {
            return (Expr)f.getChecked();
        }
        catch (DesugarInterruption e) {
            return new Expr.ErrorExpr(expr.sourcePos(), (AyaDocile)expr);
        }
    }

    @NotNull
    private Level<PreLevelVar> levelVar(@NotNull Expr expr) throws DesugarInterruption {
        Level<PreLevelVar> level;
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        block8: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.BinOpSeq.class, Expr.LMaxExpr.class, Expr.LSucExpr.class, Expr.LitIntExpr.class, Expr.RefExpr.class, Expr.HoleExpr.class}, (Object)expr3, n)) {
                case 0: {
                    Expr.BinOpSeq binOpSeq = (Expr.BinOpSeq)expr3;
                    level = this.levelVar(this.visitBinOpSeq(binOpSeq, Unit.unit()));
                    break block8;
                }
                case 1: {
                    Expr.LMaxExpr uMax = (Expr.LMaxExpr)expr3;
                    level = new Level.Maximum((ImmutableSeq<Level<PreLevelVar>>)uMax.levels().mapChecked(this::levelVar));
                    break block8;
                }
                case 2: {
                    Expr.LSucExpr uSuc = (Expr.LSucExpr)expr3;
                    level = this.levelVar(uSuc.expr()).lift(1);
                    break block8;
                }
                case 3: {
                    Expr.LitIntExpr uLit = (Expr.LitIntExpr)expr3;
                    level = new Level.Constant(uLit.integer());
                    break block8;
                }
                case 4: {
                    Expr.RefExpr ref = (Expr.RefExpr)expr3;
                    Var var = ref.resolvedVar();
                    if (!(var instanceof PreLevelVar)) {
                        n = 5;
                        continue block8;
                    }
                    PreLevelVar lv = (PreLevelVar)var;
                    level = new Level.Reference<PreLevelVar>(lv);
                    break block8;
                }
                case 5: {
                    Expr.HoleExpr hole = (Expr.HoleExpr)expr3;
                    level = new Level.Reference<PreLevelVar>(new PreLevelVar(Constants.randomName(hole), hole.sourcePos()));
                    break block8;
                }
                default: {
                    this.reporter.report((Problem)new LevelProblem.BadLevelExpr(expr));
                    throw new DesugarInterruption();
                }
            }
            break;
        }
        return level;
    }

    @Override
    @NotNull
    public Expr visitBinOpSeq(@NotNull Expr.BinOpSeq binOpSeq, Unit unit) {
        ImmutableSeq<BinOpParser.Elem> seq = binOpSeq.seq();
        assert (seq.isNotEmpty()) : binOpSeq.sourcePos().toString();
        return new BinOpParser(this.opSet, (SeqView<BinOpParser.Elem>)seq.view()).build(binOpSeq.sourcePos()).accept(this, Unit.unit());
    }

    public static class DesugarInterruption
    extends Exception {
    }
}

