/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.desugar.error;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.ExprProblem;
import org.aya.api.error.Problem;
import org.aya.concrete.Expr;
import org.aya.pretty.doc.Doc;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface LevelProblem
extends ExprProblem {
    @NotNull
    default public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    public static final class BadLevelExpr
    extends Record
    implements LevelProblem {
        @NotNull
        private final Expr expr;

        public BadLevelExpr(@NotNull Expr expr) {
            this.expr = expr;
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Expected level expression, got:"), this.expr.toDoc(options)});
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BadLevelExpr.class, "expr", "expr"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BadLevelExpr.class, "expr", "expr"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BadLevelExpr.class, "expr", "expr"}, this, o);
        }

        @NotNull
        public Expr expr() {
            return this.expr;
        }
    }

    public static final class BadTypeExpr
    extends Record
    implements LevelProblem {
        @NotNull
        private final Expr.AppExpr expr;
        private final int expected;

        public BadTypeExpr(@NotNull Expr.AppExpr expr, int expected) {
            this.expr = expr;
            this.expected = expected;
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.english((String)("Expected " + this.expected + " level(s)"));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BadTypeExpr.class, "expr;expected", "expr", "expected"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BadTypeExpr.class, "expr;expected", "expr", "expected"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BadTypeExpr.class, "expr;expected", "expr", "expected"}, this, o);
        }

        @NotNull
        public Expr.AppExpr expr() {
            return this.expr;
        }

        public int expected() {
            return this.expected;
        }
    }
}

