/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.desugar.error;

import java.util.Comparator;
import kala.collection.SeqLike;
import kala.collection.mutable.Buffer;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.Problem;
import org.aya.api.error.SourcePos;
import org.aya.api.util.Assoc;
import org.aya.concrete.desugar.BinOpSet;
import org.aya.distill.CoreDistiller;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.pretty.doc.Styles;
import org.jetbrains.annotations.NotNull;

public final class OperatorProblem {

    public record CircleError(@NotNull Buffer<BinOpSet.BinOP> items) implements Problem
    {
        @NotNull
        public SourcePos sourcePos() {
            return (SourcePos)this.items.view().map(BinOpSet.BinOP::firstBind).max(Comparator.comparingInt(SourcePos::endLine));
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Precedence circle found between"), Doc.commaList((SeqLike)this.items.view().map(BinOpSet.BinOP::name).toImmutableSeq().sorted().view().map(Doc::plain))});
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }
    }

    public record BindSelfError(@NotNull SourcePos sourcePos) implements Problem
    {
        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.english((String)"Self bind is not allowed");
        }
    }

    public record AmbiguousPredError(@NotNull String op1, @NotNull String op2, @NotNull SourcePos sourcePos) implements Problem
    {
        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Ambiguous operator precedence detected between"), Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)this.op1)), Doc.plain((String)"and"), Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)this.op2))});
        }

        @NotNull
        public Doc hint() {
            return Doc.sep((Doc[])new Doc[]{Doc.plain((String)"Use"), Doc.styled((Styles)CoreDistiller.KEYWORD.and().code(), (Doc)Doc.plain((String)"bind")), Doc.english((String)"statement or insert parentheses to make it clear.")});
        }
    }

    public record FixityError(@NotNull String op1, @NotNull Assoc assoc1, @NotNull String op2, @NotNull Assoc assoc2, @NotNull SourcePos sourcePos) implements Problem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Cannot figure out computation order because"), Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)this.op1)), Doc.parened((Doc)Doc.plain((String)this.assoc1.name())), Doc.plain((String)"and"), Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)this.op2)), Doc.parened((Doc)Doc.plain((String)this.assoc1.name())), this.reason()});
        }

        @NotNull
        private Doc reason() {
            return this.assoc1 == this.assoc2 && this.assoc1 == Assoc.Infix ? Doc.english((String)"share the same precedence but no associativity was specified.") : Doc.english((String)"share the same precedence but don't share the same associativity.");
        }

        @NotNull
        public Doc hint() {
            return Doc.english((String)"Make them both left/right-associative to resolve this problem.");
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }
    }
}

