/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.parse;

import java.io.IOException;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Either;
import kala.control.Option;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CodePointBuffer;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourceFile;
import org.aya.api.error.SourceFileLocator;
import org.aya.concrete.Expr;
import org.aya.concrete.parse.AyaProducer;
import org.aya.concrete.parse.ReporterErrorListener;
import org.aya.concrete.stmt.Stmt;
import org.aya.parser.AyaLexer;
import org.aya.parser.AyaParser;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface AyaParsing {
    @Contract(value="_ -> new")
    @NotNull
    public static AyaParser parser(@NotNull String text) {
        return new AyaParser((TokenStream)AyaParsing.tokenize(text));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Seq<Token> tokens(@NotNull String text) {
        CommonTokenStream tokenStream = AyaParsing.tokenize(text);
        tokenStream.fill();
        return Seq.wrapJava((List)tokenStream.getTokens());
    }

    @NotNull
    private static CommonTokenStream tokenize(@NotNull String text) {
        return new CommonTokenStream((TokenSource)AyaParsing.lexer(text));
    }

    @NotNull
    private static AyaLexer lexer(@NotNull String text) {
        IntBuffer intBuffer = IntBuffer.wrap(text.codePoints().toArray());
        CodePointBuffer codePointBuffer = CodePointBuffer.withInts((IntBuffer)intBuffer);
        CodePointCharStream charStream = CodePointCharStream.fromBuffer((CodePointBuffer)codePointBuffer);
        return new AyaLexer((CharStream)charStream);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    private static AyaParser parser(@NotNull SourceFile sourceFile, @NotNull Reporter reporter) {
        AyaLexer lexer = AyaParsing.lexer(sourceFile.sourceCode());
        lexer.removeErrorListeners();
        ReporterErrorListener listener = new ReporterErrorListener(sourceFile, reporter);
        lexer.addErrorListener((ANTLRErrorListener)listener);
        AyaParser parser = new AyaParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        return parser;
    }

    @NotNull
    public static ImmutableSeq<Stmt> program(@NotNull SourceFileLocator locator, @NotNull Reporter reporter, @NotNull Path path) throws IOException {
        String sourceCode = Files.readString(path);
        SourceFile sourceFile = new SourceFile(Option.some((Object)locator.displayName(path)), sourceCode);
        AyaParser parser = AyaParsing.parser(sourceFile, reporter);
        return new AyaProducer(sourceFile, reporter).visitProgram(parser.program());
    }

    @NotNull
    private static <T> T replParser(@NotNull Reporter reporter, @NotNull String text, @NotNull BiFunction<AyaProducer, AyaParser, T> tree) {
        SourceFile sourceFile = new SourceFile(Option.some((Object)Path.of("stdin", new String[0])), text);
        AyaParser parser = AyaParsing.parser(sourceFile, reporter);
        return tree.apply(new AyaProducer(sourceFile, reporter), parser);
    }

    @NotNull
    public static Either<ImmutableSeq<Stmt>, Expr> repl(@NotNull Reporter reporter, @NotNull String text) {
        return AyaParsing.replParser(reporter, text, (pro, par) -> pro.visitRepl(par.repl()));
    }

    @NotNull
    public static Expr expr(@NotNull Reporter reporter, @NotNull String text) {
        return AyaParsing.replParser(reporter, text, (pro, par) -> pro.visitExpr(par.expr()));
    }
}

