/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.parse;

import java.lang.invoke.LambdaMetafactory;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.LinkedBuffer;
import kala.collection.mutable.MutableHashSet;
import kala.control.Either;
import kala.control.Option;
import kala.function.BooleanFunction;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.value.Ref;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourceFile;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.LocalVar;
import org.aya.api.ref.PreLevelVar;
import org.aya.api.ref.Var;
import org.aya.api.util.Assoc;
import org.aya.api.util.WithPos;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.desugar.BinOpParser;
import org.aya.concrete.parse.ParseError;
import org.aya.concrete.parse.ParsingInterruptedException;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.resolve.context.Context;
import org.aya.concrete.resolve.error.PrimDependencyError;
import org.aya.concrete.resolve.error.RedefinitionError;
import org.aya.concrete.resolve.error.UnknownPrimError;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.OpDecl;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Sample;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.def.PrimDef;
import org.aya.generic.Modifier;
import org.aya.parser.AyaParser;
import org.aya.util.Constants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AyaProducer {
    @NotNull
    public final SourceFile sourceFile;
    @NotNull
    public final Reporter reporter;
    @Nullable
    private SourcePos overridingSourcePos;

    public AyaProducer(@NotNull SourceFile sourceFile, @NotNull Reporter reporter) {
        this.sourceFile = sourceFile;
        this.reporter = reporter;
    }

    public Either<ImmutableSeq<Stmt>, Expr> visitRepl(AyaParser.ReplContext ctx) {
        AyaParser.ExprContext expr = ctx.expr();
        if (expr != null) {
            return Either.right((Object)this.visitExpr(expr));
        }
        return Either.left((Object)ImmutableSeq.from((Collection)ctx.stmt()).flatMap(this::visitStmt));
    }

    public ImmutableSeq<Stmt> visitProgram(AyaParser.ProgramContext ctx) {
        return ImmutableSeq.from((Collection)ctx.stmt()).flatMap(this::visitStmt);
    }

    public Decl.PrimDecl visitPrimDecl(AyaParser.PrimDeclContext ctx) {
        TerminalNode id = ctx.ID();
        String name = id.getText();
        SourcePos sourcePos = this.sourcePosOf(id);
        PrimDef.ID primID = PrimDef.ID.find(name);
        if (primID == null) {
            this.reporter.report((Problem)new UnknownPrimError(sourcePos, name));
            throw new ParsingInterruptedException();
        }
        Option<ImmutableSeq<PrimDef.ID>> lack = PrimDef.Factory.INSTANCE.checkDependency(primID);
        if (lack.isNotEmpty() && ((ImmutableSeq)lack.get()).isNotEmpty()) {
            this.reporter.report((Problem)new PrimDependencyError(name, (ImmutableSeq<PrimDef.ID>)((ImmutableSeq)lack.get()), sourcePos));
            throw new ParsingInterruptedException();
        }
        if (PrimDef.Factory.INSTANCE.have(primID)) {
            this.reporter.report((Problem)new RedefinitionError(RedefinitionError.Kind.Prim, name, sourcePos));
            throw new ParsingInterruptedException();
        }
        PrimDef core = PrimDef.Factory.INSTANCE.factory(primID);
        AyaParser.TypeContext type = ctx.type();
        AyaParser.AssocContext assoc = ctx.assoc();
        return new Decl.PrimDecl(sourcePos, this.sourcePosOf((ParserRuleContext)ctx), assoc == null ? null : this.makeInfix(assoc, name), core.ref(), this.visitTelescope(ctx.tele()), type == null ? null : this.visitType(type));
    }

    @NotNull
    public SeqLike<Stmt> visitStmt(AyaParser.StmtContext ctx) {
        AyaParser.ImportCmdContext importCmd = ctx.importCmd();
        if (importCmd != null) {
            return ImmutableSeq.of((Object)this.visitImportCmd(importCmd));
        }
        AyaParser.OpenCmdContext openCmd = ctx.openCmd();
        if (openCmd != null) {
            return this.visitOpenCmd(openCmd);
        }
        AyaParser.DeclContext decl = ctx.decl();
        if (decl != null) {
            Tuple2<Decl, ImmutableSeq<Stmt>> result = this.visitDecl(decl);
            return ((ImmutableSeq)result._2).view().prepended((Object)((Stmt)result._1));
        }
        AyaParser.SampleContext sample = ctx.sample();
        if (sample != null) {
            return ImmutableSeq.of((Object)this.visitSample(sample));
        }
        AyaParser.ModuleContext mod = ctx.module();
        if (mod != null) {
            return ImmutableSeq.of((Object)this.visitModule(mod));
        }
        AyaParser.LevelsContext levels = ctx.levels();
        if (levels != null) {
            return ImmutableSeq.of((Object)this.visitLevels(levels));
        }
        AyaParser.BindContext bind = ctx.bind();
        if (bind != null) {
            return ImmutableSeq.of((Object)this.visitBind(bind));
        }
        AyaParser.RemarkContext remark = ctx.remark();
        if (remark != null) {
            return ImmutableSeq.of((Object)this.visitRemark(remark));
        }
        return (SeqLike)this.unreachable((ParserRuleContext)ctx);
    }

    @NotNull
    private Remark visitRemark(AyaParser.RemarkContext remark) {
        SourcePos pos;
        assert (this.overridingSourcePos == null) : "Doc comments shall not nest";
        this.overridingSourcePos = pos = this.sourcePosOf((ParserRuleContext)remark);
        StringBuilder sb = new StringBuilder();
        for (TerminalNode docComment : remark.DOC_COMMENT()) {
            sb.append(docComment.getText().substring(3)).append("\n");
        }
        Remark core = Remark.make(sb.toString(), pos, this);
        this.overridingSourcePos = null;
        return core;
    }

    public Generalize visitLevels(AyaParser.LevelsContext ctx) {
        return new Generalize.Levels(this.sourcePosOf((ParserRuleContext)ctx), (ImmutableSeq<WithPos<PreLevelVar>>)((ImmutableSeq)this.visitIds(ctx.ids()).map(t -> t.map(PreLevelVar::new)).collect(ImmutableSeq.factory())));
    }

    public  @NotNull Command.Bind visitBind(AyaParser.BindContext ctx) {
        List bindOp = ctx.qualifiedId();
        return new Command.Bind(this.sourcePosOf((ParserRuleContext)ctx), this.visitQualifiedId((AyaParser.QualifiedIdContext)bindOp.get(0)), ctx.TIGHTER() != null ? Command.BindPred.Tighter : Command.BindPred.Looser, this.visitQualifiedId((AyaParser.QualifiedIdContext)bindOp.get(1)), (Ref<Context>)new Ref(null), (Ref<OpDecl>)new Ref(null), (Ref<OpDecl>)new Ref(null));
    }

    @NotNull
    public Sample visitSample(AyaParser.SampleContext ctx) {
        Tuple2<Decl, ImmutableSeq<Stmt>> decl = this.visitDecl(ctx.decl());
        return ctx.COUNTEREXAMPLE() != null ? new Sample.Counter((Decl)decl._1) : new Sample.Working((Stmt)decl._1);
    }

    private <T> T unreachable(ParserRuleContext ctx) {
        throw new IllegalArgumentException(ctx.getClass() + ": " + ctx.getText());
    }

    @NotNull
    public Tuple2<Decl, ImmutableSeq<Stmt>> visitDecl(AyaParser.DeclContext ctx) {
        Stmt.Accessibility accessibility = ctx.PRIVATE() == null ? Stmt.Accessibility.Public : Stmt.Accessibility.Private;
        AyaParser.FnDeclContext fnDecl = ctx.fnDecl();
        if (fnDecl != null) {
            return Tuple.of((Object)this.visitFnDecl(fnDecl, accessibility), (Object)ImmutableSeq.empty());
        }
        AyaParser.DataDeclContext dataDecl = ctx.dataDecl();
        if (dataDecl != null) {
            return this.visitDataDecl(dataDecl, accessibility);
        }
        AyaParser.StructDeclContext structDecl = ctx.structDecl();
        if (structDecl != null) {
            return Tuple.of((Object)this.visitStructDecl(structDecl, accessibility), (Object)ImmutableSeq.empty());
        }
        AyaParser.PrimDeclContext primDecl = ctx.primDecl();
        if (primDecl != null) {
            return Tuple.of((Object)this.visitPrimDecl(primDecl), (Object)ImmutableSeq.empty());
        }
        return (Tuple2)this.unreachable((ParserRuleContext)ctx);
    }

    public Tuple2<@NotNull String, @Nullable OpDecl.Operator> visitDeclNameOrInfix(@NotNull AyaParser.DeclNameOrInfixContext ctx) {
        AyaParser.AssocContext assoc = ctx.assoc();
        String id = ctx.ID().getText();
        if (assoc == null) {
            return Tuple.of((Object)id, null);
        }
        OpDecl.Operator infix = this.makeInfix(assoc, id);
        return Tuple.of((Object)infix.name(), (Object)infix);
    }

    @NotNull
    private OpDecl.Operator makeInfix(@NotNull AyaParser.AssocContext assoc, @NotNull String id) {
        if (assoc.INFIX() != null) {
            return new OpDecl.Operator(id, Assoc.Infix);
        }
        if (assoc.INFIXL() != null) {
            return new OpDecl.Operator(id, Assoc.InfixL);
        }
        if (assoc.INFIXR() != null) {
            return new OpDecl.Operator(id, Assoc.InfixR);
        }
        throw new IllegalArgumentException("Unknown assoc: " + assoc.getText());
    }

    public @NotNull Decl.FnDecl visitFnDecl(AyaParser.FnDeclContext ctx, Stmt.Accessibility accessibility) {
        EnumSet modifiers = ctx.fnModifiers().stream().map(this::visitFnModifiers).distinct().collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class)));
        AyaParser.AbuseContext abuseCtx = ctx.abuse();
        Tuple2<String, OpDecl.Operator> nameOrInfix = this.visitDeclNameOrInfix(ctx.declNameOrInfix());
        return new Decl.FnDecl(this.sourcePosOf((ParserRuleContext)ctx.declNameOrInfix()), this.sourcePosOf((ParserRuleContext)ctx), accessibility, modifiers, (OpDecl.Operator)nameOrInfix._2, (String)nameOrInfix._1, this.visitTelescope(ctx.tele()), this.type(ctx.type(), this.sourcePosOf((ParserRuleContext)ctx)), this.visitFnBody(ctx.fnBody()), abuseCtx == null ? ImmutableSeq.empty() : this.visitAbuse(abuseCtx));
    }

    @NotNull
    public @NotNull ImmutableSeq<@NotNull Expr.Param> visitTelescope(List<AyaParser.TeleContext> telescope) {
        return ImmutableSeq.from(telescope).flatMap(t -> this.visitTele((AyaParser.TeleContext)t, false));
    }

    @NotNull
    public @NotNull ImmutableSeq<@NotNull Expr.Param> visitLamTelescope(List<AyaParser.TeleContext> telescope) {
        return ImmutableSeq.from(telescope).flatMap(t -> this.visitTele((AyaParser.TeleContext)t, true));
    }

    @NotNull
    public @NotNull ImmutableSeq<@NotNull Expr.Param> visitForallTelescope(List<AyaParser.TeleContext> telescope) {
        return ImmutableSeq.from(telescope).flatMap(t -> this.visitTele((AyaParser.TeleContext)t, true));
    }

    @NotNull
    public @NotNull ImmutableSeq<@NotNull Stmt> visitAbuse(AyaParser.AbuseContext ctx) {
        return ImmutableSeq.from((Collection)ctx.stmt()).flatMap(this::visitStmt);
    }

    @NotNull
    public Either<Expr, ImmutableSeq<Pattern.Clause>> visitFnBody(AyaParser.FnBodyContext ctx) {
        AyaParser.ExprContext expr = ctx.expr();
        if (expr != null) {
            return Either.left((Object)this.visitExpr(expr));
        }
        return Either.right((Object)ImmutableSeq.from((Collection)ctx.clause()).map(this::visitClause));
    }

    public QualifiedID visitQualifiedId(AyaParser.QualifiedIdContext ctx) {
        return new QualifiedID(this.sourcePosOf((ParserRuleContext)ctx), (ImmutableSeq<String>)((ImmutableSeq)ctx.ID().stream().map(ParseTree::getText).collect(ImmutableSeq.factory())));
    }

    @NotNull
    public Expr visitLiteral(AyaParser.LiteralContext ctx) {
        SourcePos pos = this.sourcePosOf((ParserRuleContext)ctx);
        if (ctx.CALM_FACE() != null) {
            return new Expr.HoleExpr(pos, false, null);
        }
        AyaParser.QualifiedIdContext id = ctx.qualifiedId();
        if (id != null) {
            return new Expr.UnresolvedExpr(pos, this.visitQualifiedId(id));
        }
        if (ctx.TYPE() != null) {
            return new Expr.RawUnivExpr(pos);
        }
        if (ctx.LGOAL() != null) {
            AyaParser.ExprContext fillingExpr = ctx.expr();
            Expr filling = fillingExpr == null ? null : this.visitExpr(fillingExpr);
            return new Expr.HoleExpr(pos, true, filling);
        }
        TerminalNode number = ctx.NUMBER();
        if (number != null) {
            return new Expr.LitIntExpr(pos, Integer.parseInt(number.getText()));
        }
        TerminalNode string = ctx.STRING();
        if (string != null) {
            return new Expr.LitStringExpr(pos, string.getText());
        }
        return (Expr)this.unreachable((ParserRuleContext)ctx);
    }

    @NotNull
    private LocalVar visitParamLiteral(AyaParser.LiteralContext ctx) {
        AyaParser.QualifiedIdContext idCtx = ctx.qualifiedId();
        if (idCtx == null) {
            this.reporter.report((Problem)new ParseError(this.sourcePosOf((ParserRuleContext)ctx), "`" + ctx.getText() + "` is not a parameter name"));
            throw new ParsingInterruptedException();
        }
        QualifiedID id = this.visitQualifiedId(idCtx);
        if (id.isQualified()) {
            this.reporter.report((Problem)new ParseError(this.sourcePosOf((ParserRuleContext)ctx), "parameter name `" + ctx.getText() + "` should not be qualified"));
            throw new ParsingInterruptedException();
        }
        return new LocalVar(id.justName(), this.sourcePosOf((ParserRuleContext)idCtx));
    }

    @NotNull
    public @NotNull ImmutableSeq<@NotNull Expr.Param> visitTele(AyaParser.TeleContext ctx, boolean isParamLiteral) {
        AyaParser.LiteralContext literal = ctx.literal();
        if (literal != null) {
            SourcePos pos = this.sourcePosOf((ParserRuleContext)ctx);
            return ImmutableSeq.of((Object)(isParamLiteral ? new Expr.Param(pos, this.visitParamLiteral(literal), this.type(null, pos), true) : new Expr.Param(pos, Constants.randomlyNamed(pos), this.visitLiteral(literal), true)));
        }
        AyaParser.TeleBinderContext teleBinder = ctx.teleBinder();
        AyaParser.TeleMaybeTypedExprContext teleMaybeTypedExpr = ctx.teleMaybeTypedExpr();
        if (teleBinder != null) {
            AyaParser.ExprContext type = teleBinder.expr();
            if (type != null) {
                SourcePos pos = this.sourcePosOf((ParserRuleContext)ctx);
                return ImmutableSeq.of((Object)new Expr.Param(pos, Constants.randomlyNamed(pos), this.visitExpr(type), true));
            }
            teleMaybeTypedExpr = teleBinder.teleMaybeTypedExpr();
        }
        if (ctx.LPAREN() != null) {
            return this.visitTeleMaybeTypedExpr(teleMaybeTypedExpr).apply(true);
        }
        if (ctx.LBRACE() != null) {
            return this.visitTeleMaybeTypedExpr(teleMaybeTypedExpr).apply(false);
        }
        return (ImmutableSeq)this.unreachable((ParserRuleContext)ctx);
    }

    @NotNull
    public Function<Boolean, ImmutableSeq<Expr.Param>> visitTeleMaybeTypedExpr(AyaParser.TeleMaybeTypedExprContext ctx) {
        Expr type = this.type(ctx.type(), this.sourcePosOf((ParserRuleContext)ctx.ids()));
        return explicit -> (ImmutableSeq)this.visitIds(ctx.ids()).map(v -> new Expr.Param(v.sourcePos(), WithPos.toVar((WithPos)v), type, (boolean)explicit)).collect(ImmutableSeq.factory());
    }

    @NotNull
    public Expr visitExpr(AyaParser.ExprContext ctx) {
        AyaParser.ExprContext exprContext = ctx;
        Objects.requireNonNull(exprContext);
        AyaParser.ExprContext exprContext2 = exprContext;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AyaParser.SingleContext.class, AyaParser.AppContext.class, AyaParser.ProjContext.class, AyaParser.PiContext.class, AyaParser.SigmaContext.class, AyaParser.LamContext.class, AyaParser.ArrContext.class, AyaParser.NewContext.class, AyaParser.LsucContext.class, AyaParser.LmaxContext.class, AyaParser.ForallContext.class}, (Object)exprContext2, n)) {
            case 0 -> {
                AyaParser.SingleContext sin = (AyaParser.SingleContext)exprContext2;
                yield this.visitAtom(sin.atom());
            }
            case 1 -> {
                AyaParser.AppContext app = (AyaParser.AppContext)exprContext2;
                yield this.visitApp(app);
            }
            case 2 -> {
                AyaParser.ProjContext proj = (AyaParser.ProjContext)exprContext2;
                yield this.visitProj(proj);
            }
            case 3 -> {
                AyaParser.PiContext pi = (AyaParser.PiContext)exprContext2;
                yield this.visitPi(pi);
            }
            case 4 -> {
                AyaParser.SigmaContext sig = (AyaParser.SigmaContext)exprContext2;
                yield this.visitSigma(sig);
            }
            case 5 -> {
                AyaParser.LamContext lam = (AyaParser.LamContext)exprContext2;
                yield this.visitLam(lam);
            }
            case 6 -> {
                AyaParser.ArrContext arr = (AyaParser.ArrContext)exprContext2;
                yield this.visitArr(arr);
            }
            case 7 -> {
                AyaParser.NewContext n = (AyaParser.NewContext)exprContext2;
                yield this.visitNew(n);
            }
            case 8 -> {
                AyaParser.LsucContext lsuc = (AyaParser.LsucContext)exprContext2;
                yield this.visitLsuc(lsuc);
            }
            case 9 -> {
                AyaParser.LmaxContext lmax = (AyaParser.LmaxContext)exprContext2;
                yield this.visitLmax(lmax);
            }
            case 10 -> {
                AyaParser.ForallContext forall = (AyaParser.ForallContext)exprContext2;
                yield this.visitForall(forall);
            }
            default -> throw new UnsupportedOperationException("TODO: " + ctx.getClass());
        };
    }

    @NotNull
    public Expr visitLsuc(AyaParser.LsucContext ctx) {
        return new Expr.LSucExpr(this.sourcePosOf((ParserRuleContext)ctx), this.visitAtom(ctx.atom()));
    }

    @NotNull
    public Expr visitLmax(AyaParser.LmaxContext ctx) {
        return new Expr.LMaxExpr(this.sourcePosOf((ParserRuleContext)ctx), (ImmutableSeq<Expr>)ImmutableSeq.from((Collection)ctx.atom()).map(this::visitAtom));
    }

    @NotNull
    public Expr visitNew(AyaParser.NewContext ctx) {
        return new Expr.NewExpr(this.sourcePosOf((ParserRuleContext)ctx), this.visitExpr(ctx.expr()), (ImmutableSeq<Expr.Field>)ImmutableSeq.from((Collection)ctx.newArg()).map(na -> new Expr.Field(na.ID().getText(), (ImmutableSeq<WithPos<LocalVar>>)((ImmutableSeq)this.visitIds(na.ids()).map(t -> new WithPos(t.sourcePos(), (Object)WithPos.toVar((WithPos)t))).collect(ImmutableSeq.factory())), this.visitExpr(na.expr()))));
    }

    @NotNull
    public Expr visitArr(AyaParser.ArrContext ctx) {
        Expr from = this.visitExpr(ctx.expr(0));
        Expr to = this.visitExpr(ctx.expr(1));
        SourcePos pos = this.sourcePosOf((ParserRuleContext)ctx.expr(0));
        return new Expr.PiExpr(this.sourcePosOf((ParserRuleContext)ctx), false, new Expr.Param(pos, Constants.randomlyNamed(pos), from, true), to);
    }

    @NotNull
    public Expr visitApp(AyaParser.AppContext ctx) {
        BinOpParser.Elem head = new BinOpParser.Elem(null, this.visitExpr(ctx.expr()), true);
        LinkedBuffer tail = (LinkedBuffer)ctx.argument().stream().map(this::visitArgument).collect(LinkedBuffer.factory());
        tail.push((Object)head);
        return new Expr.BinOpSeq(this.sourcePosOf((ParserRuleContext)ctx), (ImmutableSeq<BinOpParser.Elem>)tail.toImmutableSeq());
    }

    @NotNull
    public Expr visitAtom(AyaParser.AtomContext ctx) {
        AyaParser.LiteralContext literal = ctx.literal();
        if (literal != null) {
            return this.visitLiteral(literal);
        }
        List expr = ctx.exprList().expr();
        if (expr.size() == 1) {
            return this.newBinOPScope(this.visitExpr((AyaParser.ExprContext)expr.get(0)));
        }
        return new Expr.TupExpr(this.sourcePosOf((ParserRuleContext)ctx), (ImmutableSeq<Expr>)((ImmutableSeq)expr.stream().map(this::visitExpr).collect(ImmutableSeq.factory())));
    }

    @NotNull
    public BinOpParser.Elem visitArgument(AyaParser.ArgumentContext ctx) {
        AyaParser.AtomContext atom = ctx.atom();
        if (atom != null) {
            List fixes = ctx.projFix();
            Expr expr = this.visitAtom(atom);
            Expr projected = (Expr)((Tuple2)ImmutableSeq.from((Collection)fixes).foldLeft((Object)Tuple.of((Object)this.sourcePosOf((ParserRuleContext)ctx), (Object)expr), (BiFunction<Tuple2, AyaParser.ProjFixContext, Tuple2>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$visitArgument$9(kala.tuple.Tuple2 org.aya.parser.AyaParser$ProjFixContext ), (Lkala/tuple/Tuple2;Lorg/aya/parser/AyaParser$ProjFixContext;)Lkala/tuple/Tuple2;)((AyaProducer)this)))._2;
            return new BinOpParser.Elem(projected, true);
        }
        TerminalNode id = ctx.ID();
        if (id != null) {
            return new BinOpParser.Elem(id.getText(), this.visitExpr(ctx.expr()), false);
        }
        ImmutableSeq items = ImmutableSeq.from((Collection)ctx.exprList().expr()).map(this::visitExpr);
        if (ctx.ULEVEL() != null) {
            Expr.RawUnivArgsExpr univArgsExpr = new Expr.RawUnivArgsExpr(this.sourcePosOf((ParserRuleContext)ctx), (ImmutableSeq<Expr>)items);
            return new BinOpParser.Elem(univArgsExpr, false);
        }
        if (items.sizeEquals(1)) {
            return new BinOpParser.Elem(this.newBinOPScope((Expr)items.first()), false);
        }
        Expr.TupExpr tupExpr = new Expr.TupExpr(this.sourcePosOf((ParserRuleContext)ctx), (ImmutableSeq<Expr>)items);
        return new BinOpParser.Elem(tupExpr, false);
    }

    @NotNull
    public Expr newBinOPScope(@NotNull Expr expr) {
        return new Expr.BinOpSeq(expr.sourcePos(), (ImmutableSeq<BinOpParser.Elem>)ImmutableSeq.of((Object)new BinOpParser.Elem(expr, true)));
    }

    public @NotNull Expr.LamExpr visitLam(AyaParser.LamContext ctx) {
        return (Expr.LamExpr)AyaProducer.buildLam(this.sourcePosOf((ParserRuleContext)ctx), (SeqLike<Expr.Param>)this.visitLamTelescope(ctx.tele()).view(), this.visitLamBody(ctx));
    }

    @NotNull
    public static Expr buildLam(SourcePos sourcePos, SeqLike<Expr.Param> params, Expr body) {
        if (params.isEmpty()) {
            return body;
        }
        return new Expr.LamExpr(sourcePos, (Expr.Param)params.first(), AyaProducer.buildLam(AyaProducer.sourcePosForSubExpr(sourcePos.file(), params, body), (SeqLike<Expr.Param>)params.view().drop(1), body));
    }

    @NotNull
    private Expr visitLamBody(@NotNull AyaParser.LamContext ctx) {
        AyaParser.ExprContext bodyExpr = ctx.expr();
        if (bodyExpr == null) {
            TerminalNode impliesToken = ctx.IMPLIES();
            SourcePos bodyHolePos = impliesToken == null ? this.sourcePosOf((ParserRuleContext)ctx) : this.sourcePosOf(impliesToken);
            return new Expr.HoleExpr(bodyHolePos, false, null);
        }
        return this.visitExpr(bodyExpr);
    }

    public @NotNull Expr.SigmaExpr visitSigma(AyaParser.SigmaContext ctx) {
        return new Expr.SigmaExpr(this.sourcePosOf((ParserRuleContext)ctx), false, (ImmutableSeq<Expr.Param>)this.visitTelescope(ctx.tele()).appended((Object)new Expr.Param(this.visitExpr(ctx.expr()).sourcePos(), Constants.anonymous(), this.visitExpr(ctx.expr()), true)));
    }

    public @NotNull Expr.PiExpr visitPi(AyaParser.PiContext ctx) {
        return (Expr.PiExpr)AyaProducer.buildPi(this.sourcePosOf((ParserRuleContext)ctx), false, (SeqLike<Expr.Param>)this.visitTelescope(ctx.tele()).view(), this.visitExpr(ctx.expr()));
    }

    public @NotNull Expr.PiExpr visitForall(AyaParser.ForallContext ctx) {
        return (Expr.PiExpr)AyaProducer.buildPi(this.sourcePosOf((ParserRuleContext)ctx), false, (SeqLike<Expr.Param>)this.visitForallTelescope(ctx.tele()).view(), this.visitExpr(ctx.expr()));
    }

    @NotNull
    public static Expr buildPi(SourcePos sourcePos, boolean co, SeqLike<Expr.Param> params, Expr body) {
        if (params.isEmpty()) {
            return body;
        }
        Expr.Param first = (Expr.Param)params.first();
        return new Expr.PiExpr(sourcePos, co, first, AyaProducer.buildPi(AyaProducer.sourcePosForSubExpr(sourcePos.file(), params, body), co, (SeqLike<Expr.Param>)params.view().drop(1), body));
    }

    @NotNull
    private static SourcePos sourcePosForSubExpr(@NotNull SourceFile sourceFile, SeqLike<Expr.Param> params, Expr body) {
        SourcePos restParamSourcePos = params.stream().skip(1L).map(Expr.Param::sourcePos).reduce(SourcePos.NONE, (acc, it) -> {
            if (acc == SourcePos.NONE) {
                return it;
            }
            return new SourcePos(sourceFile, acc.tokenStartIndex(), it.tokenEndIndex(), acc.startLine(), acc.startColumn(), it.endLine(), it.endColumn());
        });
        SourcePos bodySourcePos = body.sourcePos();
        return new SourcePos(sourceFile, restParamSourcePos.tokenStartIndex(), bodySourcePos.tokenEndIndex(), restParamSourcePos.startLine(), restParamSourcePos.startColumn(), bodySourcePos.endLine(), bodySourcePos.endColumn());
    }

    public @NotNull Expr.ProjExpr visitProj(AyaParser.ProjContext proj) {
        return this.buildProj(this.sourcePosOf((ParserRuleContext)proj), this.visitExpr(proj.expr()), proj.projFix());
    }

    private @NotNull Expr.ProjExpr buildProj(@NotNull SourcePos sourcePos, @NotNull Expr projectee, @NotNull AyaParser.ProjFixContext fix) {
        TerminalNode number = fix.NUMBER();
        return new Expr.ProjExpr(sourcePos, projectee, (Either<Integer, WithPos<String>>)(number != null ? Either.left((Object)Integer.parseInt(number.getText())) : Either.right((Object)new WithPos(this.sourcePosOf((ParserRuleContext)fix), (Object)fix.ID().getText()))), (Ref<Var>)new Ref(null));
    }

    @NotNull
    public Tuple2<Decl, ImmutableSeq<Stmt>> visitDataDecl(AyaParser.DataDeclContext ctx, Stmt.Accessibility accessibility) {
        AyaParser.AbuseContext abuseCtx = ctx.abuse();
        Stmt.Accessibility openAccessibility = ctx.PUBLIC() != null ? Stmt.Accessibility.Public : Stmt.Accessibility.Private;
        ImmutableSeq body = (ImmutableSeq)ctx.dataBody().stream().map(this::visitDataBody).collect(ImmutableSeq.factory());
        this.checkRedefinition(RedefinitionError.Kind.Ctor, (SeqLike<WithPos<String>>)body.view().map(ctor -> new WithPos(ctor.sourcePos, (Object)ctor.ref.name())));
        Tuple2<String, OpDecl.Operator> nameOrInfix = this.visitDeclNameOrInfix(ctx.declNameOrInfix());
        Decl.DataDecl data = new Decl.DataDecl(this.sourcePosOf((ParserRuleContext)ctx.declNameOrInfix()), this.sourcePosOf((ParserRuleContext)ctx), accessibility, (OpDecl.Operator)nameOrInfix._2, (String)nameOrInfix._1, this.visitTelescope(ctx.tele()), this.type(ctx.type(), this.sourcePosOf((ParserRuleContext)ctx)), (ImmutableSeq<Decl.DataCtor>)body, abuseCtx == null ? ImmutableSeq.empty() : this.visitAbuse(abuseCtx));
        return Tuple2.of((Object)data, (Object)(ctx.OPEN() == null ? ImmutableSeq.empty() : ImmutableSeq.of((Object)new Command.Open(this.sourcePosOf((ParserRuleContext)ctx.declNameOrInfix()), openAccessibility, new QualifiedID(this.sourcePosOf((ParserRuleContext)ctx), (String)nameOrInfix._1), Command.Open.UseHide.EMPTY))));
    }

    @NotNull
    public Expr type(@Nullable AyaParser.TypeContext typeCtx, SourcePos sourcePos) {
        return typeCtx == null ? new Expr.HoleExpr(sourcePos, false, null) : this.visitType(typeCtx);
    }

    @NotNull
    private Decl.DataCtor visitDataBody(AyaParser.DataBodyContext ctx) {
        if (ctx instanceof AyaParser.DataCtorsContext) {
            AyaParser.DataCtorsContext dcc = (AyaParser.DataCtorsContext)ctx;
            return this.visitDataCtor((ImmutableSeq<Pattern>)ImmutableSeq.empty(), dcc.dataCtor());
        }
        if (ctx instanceof AyaParser.DataClausesContext) {
            AyaParser.DataClausesContext dcc = (AyaParser.DataClausesContext)ctx;
            return this.visitDataCtorClause(dcc.dataCtorClause());
        }
        return (Decl.DataCtor)this.unreachable((ParserRuleContext)ctx);
    }

    public Decl.DataCtor visitDataCtor(@NotNull ImmutableSeq<Pattern> patterns, AyaParser.DataCtorContext ctx) {
        ImmutableSeq<Expr.Param> telescope = this.visitTelescope(ctx.tele());
        Tuple2<String, OpDecl.Operator> nameOrInfix = this.visitDeclNameOrInfix(ctx.declNameOrInfix());
        return new Decl.DataCtor(this.sourcePosOf((ParserRuleContext)ctx.declNameOrInfix()), this.sourcePosOf((ParserRuleContext)ctx), (OpDecl.Operator)nameOrInfix._2, (String)nameOrInfix._1, telescope, this.visitClauses(ctx.clauses()), patterns, ctx.COERCE() != null);
    }

    public ImmutableSeq<Pattern.Clause> visitClauses(@Nullable AyaParser.ClausesContext ctx) {
        if (ctx == null) {
            return ImmutableSeq.empty();
        }
        return ImmutableSeq.from((Collection)ctx.clause()).map(this::visitClause);
    }

    @NotNull
    public Decl.DataCtor visitDataCtorClause(AyaParser.DataCtorClauseContext ctx) {
        return this.visitDataCtor(this.visitPatterns(ctx.patterns()), ctx.dataCtor());
    }

    @NotNull
    public Pattern visitPattern(AyaParser.PatternContext ctx) {
        return this.visitAtomPatterns(ctx.atomPatterns()).apply(true, null);
    }

    public BiFunction<Boolean, LocalVar, Pattern> visitAtomPatterns(@NotNull AyaParser.AtomPatternsContext ctx) {
        ImmutableSeq atoms = (ImmutableSeq)ctx.atomPattern().stream().map(this::visitAtomPattern).collect(ImmutableSeq.factory());
        if (atoms.sizeEquals(1)) {
            return (ex, as) -> (Pattern)((BooleanFunction)atoms.first()).apply(ex.booleanValue());
        }
        Pattern first = (Pattern)((BooleanFunction)atoms.first()).apply(true);
        if (!(first instanceof Pattern.Bind)) {
            this.reporter.report((Problem)new ParseError(first.sourcePos(), "`" + first.toDoc(DistillerOptions.DEBUG).debugRender() + "` is not a constructor name"));
            throw new ParsingInterruptedException();
        }
        Pattern.Bind bind = (Pattern.Bind)first;
        return (ex, as) -> new Pattern.Ctor(this.sourcePosOf((ParserRuleContext)ctx), (boolean)ex, (WithPos<String>)new WithPos(bind.sourcePos(), (Object)bind.bind().name()), (ImmutableSeq<Pattern>)atoms.view().drop(1).map(p -> (Pattern)p.apply(true)).toImmutableSeq(), (LocalVar)as, (Ref<Var>)new Ref(null));
    }

    @NotNull
    public BooleanFunction<Pattern> visitAtomPattern(AyaParser.AtomPatternContext ctx) {
        SourcePos sourcePos = this.sourcePosOf((ParserRuleContext)ctx);
        if (ctx.LPAREN() != null || ctx.LBRACE() != null) {
            boolean forceEx = ctx.LPAREN() != null;
            TerminalNode id = ctx.ID();
            LocalVar as = id != null ? new LocalVar(id.getText(), this.sourcePosOf(id)) : null;
            ImmutableSeq tupElem = (ImmutableSeq)ctx.patterns().pattern().stream().map(t -> this.visitAtomPatterns(t.atomPatterns())).collect(ImmutableSeq.factory());
            return tupElem.sizeEquals(1) ? exIgnored -> (Pattern)((BiFunction)tupElem.first()).apply(forceEx, as) : exIgnored -> new Pattern.Tuple(sourcePos, forceEx, (ImmutableSeq<Pattern>)tupElem.map(p -> (Pattern)p.apply(true, null)), as);
        }
        if (ctx.CALM_FACE() != null) {
            return ex -> new Pattern.CalmFace(sourcePos, ex);
        }
        TerminalNode number = ctx.NUMBER();
        if (number != null) {
            return ex -> new Pattern.Number(sourcePos, ex, Integer.parseInt(number.getText()));
        }
        TerminalNode id = ctx.ID();
        if (id != null) {
            return ex -> new Pattern.Bind(sourcePos, ex, new LocalVar(id.getText(), this.sourcePosOf(id)), (Ref<Var>)new Ref());
        }
        if (ctx.ABSURD() != null) {
            return ex -> new Pattern.Absurd(sourcePos, ex);
        }
        return (BooleanFunction)this.unreachable((ParserRuleContext)ctx);
    }

    @NotNull
    public ImmutableSeq<Pattern> visitPatterns(AyaParser.PatternsContext ctx) {
        return (ImmutableSeq)ctx.pattern().stream().map(this::visitPattern).collect(ImmutableSeq.factory());
    }

    @NotNull
    public Pattern.Clause visitClause(AyaParser.ClauseContext ctx) {
        return new Pattern.Clause(this.sourcePosOf((ParserRuleContext)ctx), this.visitPatterns(ctx.patterns()), (Option<Expr>)Option.of((Object)ctx.expr()).map(this::visitExpr));
    }

    private void checkRedefinition(@NotNull RedefinitionError.Kind kind, @NotNull SeqLike<WithPos<String>> names) {
        MutableHashSet set = MutableHashSet.of();
        ImmutableSeq redefs = names.view().filterNot(n -> set.add((Object)((String)n.data()))).toImmutableSeq();
        if (redefs.isNotEmpty()) {
            WithPos last = (WithPos)redefs.last();
            this.reporter.report((Problem)new RedefinitionError(kind, (String)last.data(), last.sourcePos()));
            throw new ParsingInterruptedException();
        }
    }

    @NotNull
    public Decl.StructDecl visitStructDecl(AyaParser.StructDeclContext ctx, Stmt.Accessibility accessibility) {
        AyaParser.AbuseContext abuseCtx = ctx.abuse();
        ImmutableSeq<Decl.StructField> fields = this.visitFields(ctx.field());
        this.checkRedefinition(RedefinitionError.Kind.Field, (SeqLike<WithPos<String>>)fields.view().map(field -> new WithPos(field.sourcePos, (Object)field.ref.name())));
        Tuple2<String, OpDecl.Operator> nameOrIndex = this.visitDeclNameOrInfix(ctx.declNameOrInfix());
        return new Decl.StructDecl(this.sourcePosOf((ParserRuleContext)ctx.declNameOrInfix()), this.sourcePosOf((ParserRuleContext)ctx), accessibility, (OpDecl.Operator)nameOrIndex._2, (String)nameOrIndex._1, this.visitTelescope(ctx.tele()), this.type(ctx.type(), this.sourcePosOf((ParserRuleContext)ctx)), fields, abuseCtx == null ? ImmutableSeq.empty() : this.visitAbuse(abuseCtx));
    }

    private ImmutableSeq<Decl.StructField> visitFields(List<AyaParser.FieldContext> field) {
        return ImmutableSeq.from(field).map(fieldCtx -> {
            if (fieldCtx instanceof AyaParser.FieldDeclContext) {
                AyaParser.FieldDeclContext fieldDecl = (AyaParser.FieldDeclContext)fieldCtx;
                return this.visitFieldDecl(fieldDecl);
            }
            if (fieldCtx instanceof AyaParser.FieldImplContext) {
                AyaParser.FieldImplContext fieldImpl = (AyaParser.FieldImplContext)fieldCtx;
                return this.visitFieldImpl(fieldImpl);
            }
            throw new IllegalArgumentException(fieldCtx.getClass() + " is neither FieldDecl nor FieldImpl!");
        });
    }

    public Decl.StructField visitFieldImpl(AyaParser.FieldImplContext ctx) {
        ImmutableSeq<Expr.Param> telescope = this.visitTelescope(ctx.tele());
        TerminalNode id = ctx.ID();
        return new Decl.StructField(this.sourcePosOf(id), this.sourcePosOf((ParserRuleContext)ctx), id.getText(), telescope, this.type(ctx.type(), this.sourcePosOf((ParserRuleContext)ctx)), (Option<Expr>)Option.of((Object)ctx.expr()).map(this::visitExpr), (ImmutableSeq<Pattern.Clause>)ImmutableSeq.empty(), false);
    }

    public Decl.StructField visitFieldDecl(AyaParser.FieldDeclContext ctx) {
        ImmutableSeq<Expr.Param> telescope = this.visitTelescope(ctx.tele());
        TerminalNode id = ctx.ID();
        return new Decl.StructField(this.sourcePosOf(id), this.sourcePosOf((ParserRuleContext)ctx), id.getText(), telescope, this.type(ctx.type(), this.sourcePosOf((ParserRuleContext)ctx)), (Option<Expr>)Option.none(), this.visitClauses(ctx.clauses()), ctx.COERCE() != null);
    }

    @NotNull
    public Expr visitType(@NotNull AyaParser.TypeContext ctx) {
        return this.visitExpr(ctx.expr());
    }

    @NotNull
    public Stmt visitImportCmd(AyaParser.ImportCmdContext ctx) {
        TerminalNode id = ctx.ID();
        return new Command.Import(this.sourcePosOf((ParserRuleContext)ctx.qualifiedId()), this.visitQualifiedId(ctx.qualifiedId()), id == null ? null : id.getText());
    }

    @NotNull
    public ImmutableSeq<Stmt> visitOpenCmd(AyaParser.OpenCmdContext ctx) {
        Stmt.Accessibility accessibility = ctx.PUBLIC() == null ? Stmt.Accessibility.Private : Stmt.Accessibility.Public;
        AyaParser.UseHideContext useHide = ctx.useHide();
        AyaParser.QualifiedIdContext modNameCtx = ctx.qualifiedId();
        SourcePos namePos = this.sourcePosOf((ParserRuleContext)modNameCtx);
        QualifiedID modName = this.visitQualifiedId(modNameCtx);
        Command.Open open = new Command.Open(namePos, accessibility, modName, useHide != null ? this.visitUseHide(useHide) : Command.Open.UseHide.EMPTY);
        if (ctx.IMPORT() != null) {
            return ImmutableSeq.of((Object)new Command.Import(namePos, modName, null), (Object)open);
        }
        return ImmutableSeq.of((Object)open);
    }

    public Command.Open.UseHide visitUse(List<AyaParser.UseContext> ctxs) {
        return new Command.Open.UseHide((ImmutableSeq<String>)((ImmutableSeq)ctxs.stream().map(AyaParser.UseContext::useHideList).map(AyaParser.UseHideListContext::idsComma).flatMap(this::visitIdsComma).collect(ImmutableSeq.factory())), Command.Open.UseHide.Strategy.Using);
    }

    public Command.Open.UseHide visitHide(List<AyaParser.HideContext> ctxs) {
        return new Command.Open.UseHide((ImmutableSeq<String>)((ImmutableSeq)ctxs.stream().map(AyaParser.HideContext::useHideList).map(AyaParser.UseHideListContext::idsComma).flatMap(this::visitIdsComma).collect(ImmutableSeq.factory())), Command.Open.UseHide.Strategy.Hiding);
    }

    @NotNull
    public Command.Open.UseHide visitUseHide(@NotNull AyaParser.UseHideContext ctx) {
        List use = ctx.use();
        if (use != null) {
            return this.visitUse(use);
        }
        return this.visitHide(ctx.hide());
    }

    @NotNull
    public Command.Module visitModule(AyaParser.ModuleContext ctx) {
        return new Command.Module(this.sourcePosOf(ctx.ID()), ctx.ID().getText(), (ImmutableSeq<Stmt>)ImmutableSeq.from((Collection)ctx.stmt()).flatMap(this::visitStmt));
    }

    @NotNull
    public Stream<WithPos<String>> visitIds(AyaParser.IdsContext ctx) {
        return ctx.ID().stream().map(id -> new WithPos(this.sourcePosOf((TerminalNode)id), (Object)id.getText()));
    }

    @NotNull
    public Stream<String> visitIdsComma(AyaParser.IdsCommaContext ctx) {
        return ctx.ID().stream().map(ParseTree::getText);
    }

    @NotNull
    public Modifier visitFnModifiers(AyaParser.FnModifiersContext ctx) {
        if (ctx.ERASE() != null) {
            return Modifier.Erase;
        }
        if (ctx.INLINE() != null) {
            return Modifier.Inline;
        }
        return (Modifier)((Object)this.unreachable((ParserRuleContext)ctx));
    }

    @NotNull
    private SourcePos sourcePosOf(ParserRuleContext ctx) {
        if (this.overridingSourcePos != null) {
            return this.overridingSourcePos;
        }
        Token start = ctx.getStart();
        Token end = ctx.getStop();
        return new SourcePos(this.sourceFile, start.getStartIndex(), end.getStopIndex(), start.getLine(), start.getCharPositionInLine(), end.getLine(), end.getCharPositionInLine() + end.getText().length() - 1);
    }

    @NotNull
    private SourcePos sourcePosOf(TerminalNode node) {
        if (this.overridingSourcePos != null) {
            return this.overridingSourcePos;
        }
        Token token = node.getSymbol();
        int line = token.getLine();
        return new SourcePos(this.sourceFile, token.getStartIndex(), token.getStopIndex(), line, token.getCharPositionInLine(), line, token.getCharPositionInLine() + token.getText().length() - 1);
    }

    private /* synthetic */ Tuple2 lambda$visitArgument$9(Tuple2 acc, AyaParser.ProjFixContext proj) {
        return Tuple.of((Object)((Expr)acc._2).sourcePos(), (Object)this.buildProj((SourcePos)acc._1, (Expr)acc._2, proj));
    }
}

