/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.parse;

import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourceFile;
import org.aya.api.error.SourcePos;
import org.aya.concrete.parse.ParseError;
import org.aya.concrete.parse.ParsingInterruptedException;
import org.jetbrains.annotations.NotNull;

public class ReporterErrorListener
extends BaseErrorListener {
    @NotNull
    private final Reporter reporter;
    @NotNull
    private final SourceFile sourceFile;

    public ReporterErrorListener(@NotNull SourceFile sourceFile, @NotNull Reporter reporter) {
        this.sourceFile = sourceFile;
        this.reporter = reporter;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object o, int line, int pos, String msg, RecognitionException e) {
        Token offendingToken = (Token)o;
        if (offendingToken == null) {
            this.lexerError(line, pos, msg, (LexerNoViableAltException)e);
        } else {
            this.parserError(line, pos, msg, offendingToken);
        }
        throw new ParsingInterruptedException();
    }

    private void parserError(int line, int pos, String msg, Token offendingToken) {
        int start = offendingToken.getStartIndex();
        int end = offendingToken.getStopIndex();
        if (offendingToken.getType() == -1) {
            end = -114514;
            start = -114514;
        }
        this.reporter.report((Problem)new ParseError(new SourcePos(this.sourceFile, start, end, line, pos, line, pos + offendingToken.getText().length()), msg));
    }

    private void lexerError(int line, int pos, String msg, LexerNoViableAltException e) {
        this.reporter.report((Problem)new ParseError(new SourcePos(this.sourceFile, e.getStartIndex(), e.getInputStream().index(), line, pos, line, pos), msg));
    }
}

