/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.remark;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.Buffer;
import kala.value.Ref;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.Problem;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.PreLevelVar;
import org.aya.api.ref.Var;
import org.aya.api.util.NormalizeMode;
import org.aya.concrete.Expr;
import org.aya.concrete.desugar.BinOpSet;
import org.aya.concrete.remark.CodeOptions;
import org.aya.concrete.resolve.context.Context;
import org.aya.concrete.resolve.visitor.ExprResolver;
import org.aya.concrete.visitor.ExprConsumer;
import org.aya.concrete.visitor.ExprFixpoint;
import org.aya.core.def.UserDef;
import org.aya.core.term.Term;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Docile;
import org.aya.pretty.doc.Style;
import org.aya.tyck.ExprTycker;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Literate
extends Docile {
    default public <P> void modify(@NotNull ExprFixpoint<P> fixpoint, P p) {
    }

    default public <P> void visit(@NotNull ExprConsumer<P> consumer, P p) {
    }

    default public void tyck(@NotNull ExprTycker tycker) {
    }

    public void resolve(@NotNull BinOpSet var1, @NotNull Context var2);

    public static final class Code
    implements Literate {
        @NotNull
        public Expr expr;
        @Nullable
        public ExprTycker.Result tyckResult;
        @NotNull
        public final CodeOptions options;

        public Code(@NotNull Expr expr, @NotNull CodeOptions options) {
            this.expr = expr;
            this.options = options;
        }

        @Override
        @Contract(mutates="this")
        public <P> void modify(@NotNull ExprFixpoint<P> fixpoint, P p) {
            this.expr = (Expr)this.expr.accept(fixpoint, p);
        }

        @Override
        public <P> void visit(@NotNull ExprConsumer<P> consumer, P p) {
            this.expr.accept(consumer, p);
        }

        @Override
        public void tyck(@NotNull ExprTycker tycker) {
            this.tyckResult = tycker.zonk(this.expr, tycker.synthesize(this.expr));
        }

        @Override
        public void resolve(@NotNull BinOpSet opSet, @NotNull Context context) {
            this.modify(new ExprResolver(false, (Buffer<PreLevelVar>)Buffer.create()), context);
        }

        @NotNull
        private Doc normalize(@NotNull Term term) {
            NormalizeMode mode = this.options.mode();
            return (mode == null ? term : term.normalize(null, mode)).toDoc(this.options.options());
        }

        @NotNull
        public Doc toDoc() {
            if (this.tyckResult == null) {
                return Doc.plain((String)"Error");
            }
            Style style = Style.code();
            return Doc.styled((Style)style, (Doc)(switch (this.options.showCode()) {
                default -> throw new IncompatibleClassChangeError();
                case CodeOptions.ShowCode.Concrete -> this.expr.toDoc(this.options.options());
                case CodeOptions.ShowCode.Core -> this.normalize(this.tyckResult.wellTyped());
                case CodeOptions.ShowCode.Type -> this.normalize(this.tyckResult.type());
            }));
        }
    }

    public record Err(@NotNull Ref<Var> def, @NotNull SourcePos sourcePos) implements Literate
    {
        @Override
        public void resolve(@NotNull BinOpSet opSet, @NotNull Context context) {
            this.def.set((Object)context.getUnqualified(((Var)this.def.value).name(), this.sourcePos));
        }

        @NotNull
        public Doc toDoc() {
            Object object = this.def.value;
            if (object instanceof DefVar) {
                DefVar defVar = (DefVar)object;
                object = defVar.core;
                if (object instanceof UserDef) {
                    UserDef userDef = (UserDef)object;
                    ImmutableSeq<Problem> problems = userDef.problems;
                    if (problems == null) {
                        return Doc.styled((Style)Style.bold(), (Doc)Doc.english((String)"No error message."));
                    }
                    return Doc.vcat((SeqLike)problems.map(problem -> problem.brief(DistillerOptions.DEFAULT)));
                }
            }
            return Doc.styled((Style)Style.bold(), (Doc)Doc.english((String)"Not a definition that can obtain error message."));
        }
    }

    public record Many(@Nullable Style style, @NotNull ImmutableSeq<Literate> children) implements Literate
    {
        @Override
        public void resolve(@NotNull BinOpSet opSet, @NotNull Context context) {
            this.children.forEach(child -> child.resolve(opSet, context));
        }

        @Override
        public <P> void modify(@NotNull ExprFixpoint<P> fixpoint, P p) {
            this.children.forEach(literate -> literate.modify(fixpoint, p));
        }

        @Override
        public <P> void visit(@NotNull ExprConsumer<P> consumer, P p) {
            this.children.forEach(literate -> literate.visit(consumer, p));
        }

        @Override
        public void tyck(@NotNull ExprTycker tycker) {
            this.children.forEach(literate -> literate.tyck(tycker));
        }

        @NotNull
        public Doc toDoc() {
            Doc cat = Doc.cat((SeqLike)this.children.map(Docile::toDoc));
            return this.style == null ? cat : Doc.styled((Style)this.style, (Doc)cat);
        }
    }

    public record Raw(@NotNull Doc toDoc) implements Literate
    {
        @Override
        public void resolve(@NotNull BinOpSet opSet, @NotNull Context context) {
        }
    }
}

