/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.resolve.context;

import java.util.function.Predicate;
import kala.collection.Seq;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.Buffer;
import kala.collection.mutable.MutableMap;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.LocalVar;
import org.aya.api.ref.Var;
import org.aya.api.util.InterruptException;
import org.aya.concrete.resolve.context.BindContext;
import org.aya.concrete.resolve.context.PhysicalModuleContext;
import org.aya.concrete.resolve.error.QualifiedNameNotFoundError;
import org.aya.concrete.resolve.error.ShadowingWarn;
import org.aya.concrete.resolve.error.UnqualifiedNameNotFoundError;
import org.aya.concrete.stmt.QualifiedID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Context {
    public static final ImmutableSeq<String> TOP_LEVEL_MOD_NAME = ImmutableSeq.empty();

    @Nullable
    public Context parent();

    @NotNull
    public Reporter reporter();

    @NotNull
    default public ImmutableSeq<String> moduleName() {
        Context p = this.parent();
        if (p == null) {
            return ImmutableSeq.empty();
        }
        return p.moduleName();
    }

    @Contract(value="_->fail")
    @NotNull
    default public <T> T reportAndThrow(@NotNull Problem problem) {
        this.reporter().report(problem);
        throw new ResolvingInterruptedException();
    }

    @NotNull
    default public Var get(@NotNull QualifiedID name) {
        boolean isUnqualified = name.isUnqualified();
        return isUnqualified ? this.getUnqualified(name.justName(), name.sourcePos()) : this.getQualified(name, name.sourcePos());
    }

    default public Buffer<LocalVar> collect(@NotNull Buffer<LocalVar> container) {
        return container;
    }

    @Nullable
    public Var getUnqualifiedLocalMaybe(@NotNull String var1, @NotNull SourcePos var2);

    @Nullable
    default public Var getUnqualifiedMaybe(@NotNull String name, @NotNull SourcePos sourcePos) {
        Var ref = this.getUnqualifiedLocalMaybe(name, sourcePos);
        if (ref == null) {
            Context p = this.parent();
            if (p == null) {
                return null;
            }
            return p.getUnqualifiedMaybe(name, sourcePos);
        }
        return ref;
    }

    @NotNull
    default public Var getUnqualified(@NotNull String name, @NotNull SourcePos sourcePos) {
        Var result = this.getUnqualifiedMaybe(name, sourcePos);
        if (result == null) {
            this.reportAndThrow(new UnqualifiedNameNotFoundError(name, sourcePos));
        }
        return result;
    }

    @Nullable
    public Var getQualifiedLocalMaybe(@NotNull @NotNull ImmutableSeq<@NotNull String> var1, @NotNull String var2, @NotNull SourcePos var3);

    @Nullable
    default public Var getQualifiedMaybe(@NotNull @NotNull ImmutableSeq<@NotNull String> modName, @NotNull String name, @NotNull SourcePos sourcePos) {
        Var ref = this.getQualifiedLocalMaybe(modName, name, sourcePos);
        if (ref == null) {
            Context p = this.parent();
            if (p == null) {
                return null;
            }
            return p.getQualifiedMaybe(modName, name, sourcePos);
        }
        return ref;
    }

    @NotNull
    default public Var getQualified(@NotNull @NotNull ImmutableSeq<@NotNull String> modName, @NotNull String name, @NotNull SourcePos sourcePos) {
        Var result = this.getQualifiedMaybe(modName, name, sourcePos);
        if (result == null) {
            this.reportAndThrow(new QualifiedNameNotFoundError((Seq<String>)modName, name, sourcePos));
        }
        return result;
    }

    @NotNull
    default public Var getQualified(@NotNull QualifiedID qualifiedID, @NotNull SourcePos sourcePos) {
        SeqView view = qualifiedID.ids().view();
        String name = (String)view.last();
        ImmutableSeq modName = view.dropLast(1).toImmutableSeq();
        return this.getQualified((ImmutableSeq<String>)modName, name, sourcePos);
    }

    @Nullable
    public MutableMap<String, Var> getModuleLocalMaybe(@NotNull ImmutableSeq<String> var1, @NotNull SourcePos var2);

    @Nullable
    default public MutableMap<String, Var> getModuleMaybe(@NotNull ImmutableSeq<String> modName, @NotNull SourcePos sourcePos) {
        MutableMap<String, Var> ref = this.getModuleLocalMaybe(modName, sourcePos);
        if (ref == null) {
            Context p = this.parent();
            if (p == null) {
                return null;
            }
            return p.getModuleMaybe(modName, sourcePos);
        }
        return ref;
    }

    @NotNull
    default public BindContext bind(@NotNull LocalVar ref, @NotNull SourcePos sourcePos, @NotNull Predicate<@Nullable Var> toWarn) {
        return this.bind(ref.name(), ref, sourcePos, toWarn);
    }

    @NotNull
    default public BindContext bind(@NotNull LocalVar ref, @NotNull SourcePos sourcePos) {
        return this.bind(ref.name(), ref, sourcePos, var -> var instanceof LocalVar);
    }

    @NotNull
    default public BindContext bind(@NotNull String name, @NotNull LocalVar ref, @NotNull SourcePos sourcePos, @NotNull Predicate<@Nullable Var> toWarn) {
        if (toWarn.test(this.getUnqualifiedMaybe(name, sourcePos)) && !name.startsWith("_")) {
            this.reporter().report((Problem)new ShadowingWarn(name, sourcePos));
        }
        return new BindContext(this, name, ref);
    }

    @NotNull
    default public PhysicalModuleContext derive(@NotNull String extraName) {
        return new PhysicalModuleContext(this, (ImmutableSeq<String>)this.moduleName().appended((Object)extraName));
    }

    @NotNull
    default public PhysicalModuleContext derive(@NotNull @NotNull Seq<@NotNull String> extraName) {
        return new PhysicalModuleContext(this, (ImmutableSeq<String>)this.moduleName().concat(extraName));
    }

    public static class ResolvingInterruptedException
    extends InterruptException {
        public InterruptException.InterruptStage stage() {
            return InterruptException.InterruptStage.Resolving;
        }
    }
}

