/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.resolve.module;

import java.io.IOException;
import java.nio.file.Path;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.Buffer;
import kala.collection.mutable.MutableMap;
import kala.function.CheckedConsumer;
import org.aya.api.error.DelayedReporter;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourceFileLocator;
import org.aya.api.ref.Var;
import org.aya.api.util.InternalException;
import org.aya.concrete.Expr;
import org.aya.concrete.desugar.BinOpSet;
import org.aya.concrete.parse.AyaParsing;
import org.aya.concrete.remark.Literate;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.resolve.context.EmptyContext;
import org.aya.concrete.resolve.context.ModuleContext;
import org.aya.concrete.resolve.context.PhysicalModuleContext;
import org.aya.concrete.resolve.module.ModuleLoader;
import org.aya.concrete.resolve.visitor.StmtShallowResolver;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Sample;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.def.Def;
import org.aya.tyck.ExprTycker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FileModuleLoader(@NotNull SourceFileLocator locator, @NotNull Path basePath, @NotNull Reporter reporter, @Nullable FileModuleLoaderCallback callback,  @Nullable Trace.Builder builder) implements ModuleLoader
{
    @NotNull
    private Path resolveFile(@NotNull @NotNull Seq<@NotNull String> path) {
        Path withoutExt = (Path)path.foldLeft((Object)this.basePath, Path::resolve);
        return withoutExt.resolveSibling(withoutExt.getFileName() + ".aya");
    }

    @Override
    @Nullable
    public MutableMap<ImmutableSeq<String>, MutableMap<String, Var>> load(@NotNull @NotNull ImmutableSeq<@NotNull String> path, @NotNull ModuleLoader recurseLoader) {
        Path sourcePath = this.resolveFile((Seq<String>)path);
        try {
            ImmutableSeq<Stmt> program = AyaParsing.program(this.locator, this.reporter, sourcePath);
            PhysicalModuleContext context = new EmptyContext(this.reporter).derive((Seq<String>)path);
            FileModuleLoader.tyckModule(context, recurseLoader, program, this.reporter, resolveInfo -> {
                if (this.callback != null) {
                    this.callback.onResolved(sourcePath, (FileResolveInfo)resolveInfo, program);
                }
            }, defs -> {
                if (this.callback != null) {
                    this.callback.onTycked(sourcePath, program, (ImmutableSeq<Def>)defs);
                }
            }, this.builder);
            return context.exports;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception> void tyckModule(@NotNull ModuleContext context, @NotNull ModuleLoader recurseLoader, @NotNull ImmutableSeq<Stmt> program, @NotNull Reporter reporter, @NotNull CheckedConsumer<FileResolveInfo, E> onResolved, @NotNull CheckedConsumer<ImmutableSeq<Def>, E> onTycked,  @Nullable Trace.Builder builder) throws E {
        FileResolveInfo resolveInfo = new FileResolveInfo((Buffer<ImmutableSeq<String>>)Buffer.create());
        StmtShallowResolver shallowResolver = new StmtShallowResolver(recurseLoader, resolveInfo);
        program.forEach(s -> s.accept(shallowResolver, context));
        BinOpSet opSet = new BinOpSet(reporter);
        program.forEach(s -> s.resolve(opSet));
        opSet.sort();
        program.forEach(s -> s.desugar(reporter, opSet));
        try (DelayedReporter delayedReporter = new DelayedReporter(reporter);){
            Buffer wellTyped = Buffer.create();
            for (Stmt stmt : program) {
                if (stmt instanceof Decl) {
                    Decl decl = (Decl)stmt;
                    wellTyped.append((Object)decl.tyck((Reporter)delayedReporter, builder));
                } else if (stmt instanceof Sample) {
                    Sample sample = (Sample)stmt;
                    wellTyped.append((Object)sample.tyck((Reporter)delayedReporter, builder));
                } else if (stmt instanceof Remark) {
                    Remark remark = (Remark)stmt;
                    Literate literate = remark.literate;
                    if (literate != null) {
                        literate.tyck(new ExprTycker((Reporter)delayedReporter, builder));
                    }
                }
                if (!delayedReporter.problems().anyMatch(Problem::isError)) continue;
                break;
            }
            onTycked.acceptChecked((Object)wellTyped.toImmutableSeq());
        }
        finally {
            onResolved.acceptChecked((Object)resolveInfo);
        }
    }

    public static @NotNull ExprTycker.Result tyckExpr(@NotNull ModuleContext context, @NotNull Expr expr, @NotNull Reporter reporter,  @Nullable Trace.Builder builder) {
        Expr resolvedExpr = expr.resolve(context);
        try (DelayedReporter delayedReporter = new DelayedReporter(reporter);){
            ExprTycker tycker = new ExprTycker((Reporter)delayedReporter, builder);
            ExprTycker.Result result = tycker.zonk(expr, tycker.synthesize(resolvedExpr.desugar((Reporter)delayedReporter)));
            return result;
        }
    }

    public static void handleInternalError(@NotNull InternalException e) {
        e.printStackTrace();
        e.printHint();
        System.err.println("Please report the stacktrace to the developers so a better error handling could be made.\nDon't forget to inform the version of Aya you're using and attach your code for reproduction.");
    }

    public static interface FileModuleLoaderCallback {
        public void onResolved(@NotNull Path var1, @NotNull FileResolveInfo var2, @NotNull ImmutableSeq<Stmt> var3);

        public void onTycked(@NotNull Path var1, @NotNull ImmutableSeq<Stmt> var2, @NotNull ImmutableSeq<Def> var3);
    }

    public record FileResolveInfo(@NotNull Buffer<ImmutableSeq<String>> imports) {
    }
}

