/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.resolve.visitor;

import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import kala.value.Ref;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.LocalVar;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.resolve.context.Context;
import org.aya.concrete.resolve.visitor.ExprResolver;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class PatResolver
implements Pattern.Visitor<Context, Tuple2<Context, Pattern>> {
    @NotNull
    public static final PatResolver INSTANCE = new PatResolver();

    private PatResolver() {
    }

    public Pattern.Clause matchy(@NotNull Pattern.Clause match, @NotNull Context context, @NotNull ExprResolver bodyResolver) {
        Ref ctx = new Ref((Object)context);
        ImmutableSeq pats = match.patterns.map(pat -> this.subpatterns((Ref<Context>)ctx, (Pattern)pat));
        return new Pattern.Clause(match.sourcePos, (ImmutableSeq<Pattern>)pats, (Option<Expr>)match.expr.map(e -> e.accept(bodyResolver, ctx.value)));
    }

    Pattern subpatterns(Ref<Context> ctx, Pattern pat) {
        Tuple2<Context, Pattern> res = pat.accept(this, (Context)ctx.value);
        ctx.value = res._1;
        return (Pattern)res._2;
    }

    private Context bindAs(LocalVar as, Context ctx, SourcePos sourcePos) {
        return as != null ? ctx.bind(as, sourcePos) : ctx;
    }

    @Override
    @Contract(value="_, _ -> fail", pure=true)
    public Tuple2<Context, Pattern> visitCtor(@NotNull Pattern.Ctor ctor, Context context) {
        Ref newCtx = new Ref((Object)context);
        ImmutableSeq params = ctor.params().map(p -> this.subpatterns((Ref<Context>)newCtx, (Pattern)p));
        SourcePos sourcePos = ctor.sourcePos();
        return Tuple.of((Object)this.bindAs(ctor.as(), (Context)newCtx.value, sourcePos), (Object)new Pattern.Ctor(sourcePos, ctor.explicit(), ctor.name(), (ImmutableSeq<Pattern>)params, ctor.as(), ctor.resolved()));
    }

    @Override
    public Tuple2<Context, Pattern> visitTuple(@NotNull Pattern.Tuple tuple, Context context) {
        Ref newCtx = new Ref((Object)context);
        ImmutableSeq patterns = tuple.patterns().map(p -> this.subpatterns((Ref<Context>)newCtx, (Pattern)p));
        return Tuple.of((Object)this.bindAs(tuple.as(), (Context)newCtx.value, tuple.sourcePos()), (Object)new Pattern.Tuple(tuple.sourcePos(), tuple.explicit(), (ImmutableSeq<Pattern>)patterns, tuple.as()));
    }

    @Override
    public Tuple2<Context, Pattern> visitNumber(@NotNull Pattern.Number number, Context context) {
        return Tuple.of((Object)context, (Object)number);
    }

    @Override
    public Tuple2<Context, Pattern> visitAbsurd(@NotNull Pattern.Absurd number, Context context) {
        return Tuple.of((Object)context, (Object)number);
    }

    @Override
    public Tuple2<Context, Pattern> visitCalmFace(@NotNull Pattern.CalmFace f, Context context) {
        return Tuple.of((Object)context, (Object)f);
    }

    @Override
    public Tuple2<Context, Pattern> visitBind(@NotNull Pattern.Bind bind, Context context) {
        bind.resolved().value = context.getUnqualifiedMaybe(bind.bind().name(), bind.sourcePos());
        return Tuple.of((Object)context.bind(bind.bind(), bind.sourcePos(), var -> false), (Object)bind);
    }
}

