/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.resolve.visitor;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.Buffer;
import kala.tuple.Tuple2;
import kala.tuple.Unit;
import kala.value.Ref;
import org.aya.api.concrete.ConcreteDecl;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.PreLevelVar;
import org.aya.api.ref.Var;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.desugar.BinOpSet;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.resolve.context.Context;
import org.aya.concrete.resolve.error.UnknownOperatorError;
import org.aya.concrete.resolve.visitor.ExprResolver;
import org.aya.concrete.resolve.visitor.PatResolver;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.OpDecl;
import org.aya.concrete.stmt.QualifiedID;
import org.aya.concrete.stmt.Stmt;
import org.jetbrains.annotations.NotNull;

public final class StmtResolver
implements Stmt.Visitor<BinOpSet, Unit> {
    @NotNull
    public static final StmtResolver INSTANCE = new StmtResolver();

    private StmtResolver() {
    }

    @Override
    public Unit visitModule( @NotNull Command.Module mod, BinOpSet opSet) {
        this.visitAll(mod.contents(), opSet);
        return Unit.unit();
    }

    @Override
    public Unit visitImport( @NotNull Command.Import cmd, BinOpSet opSet) {
        return Unit.unit();
    }

    @Override
    public Unit visitOpen( @NotNull Command.Open cmd, BinOpSet opSet) {
        return Unit.unit();
    }

    @Override
    public Unit visitBind( @NotNull Command.Bind bind, BinOpSet opSet) {
        Context ctx = (Context)bind.context().value;
        if (ctx == null) {
            throw new IllegalStateException("no shallow resolver?");
        }
        OpDecl op = this.resolveOp(opSet.reporter(), ctx, bind.op());
        OpDecl target = this.resolveOp(opSet.reporter(), ctx, bind.target());
        bind.resolvedOp().value = op;
        bind.resolvedTarget().value = target;
        opSet.bind(op, bind.pred(), target, bind.sourcePos());
        return Unit.unit();
    }

    @Override
    public Unit visitRemark(@NotNull Remark remark, BinOpSet binOpSet) {
        remark.doResolve(binOpSet);
        return Unit.unit();
    }

    @NotNull
    private OpDecl resolveOp(@NotNull Reporter reporter, @NotNull Context ctx, @NotNull QualifiedID id) {
        Var var = ctx.get(id);
        if (var instanceof DefVar) {
            DefVar defVar = (DefVar)var;
            ConcreteDecl concreteDecl = defVar.concrete;
            if (concreteDecl instanceof OpDecl) {
                OpDecl op = (OpDecl)concreteDecl;
                return op;
            }
        }
        reporter.report((Problem)new UnknownOperatorError(id.sourcePos(), id.join()));
        throw new Context.ResolvingInterruptedException();
    }

    @Override
    public Unit visitCtor(@NotNull Decl.DataCtor ctor, BinOpSet binOpSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Unit visitField(@NotNull Decl.StructField field, BinOpSet binOpSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Unit visitData( @NotNull Decl.DataDecl decl, BinOpSet opSet) {
        ExprResolver signatureResolver = new ExprResolver(true, (Buffer<PreLevelVar>)Buffer.create());
        Tuple2<ImmutableSeq<Expr.Param>, Context> local = signatureResolver.resolveParams((SeqLike<Expr.Param>)decl.telescope, decl.ctx);
        decl.telescope = (ImmutableSeq)local._1;
        decl.result = decl.result.accept(signatureResolver, (Context)local._2);
        ExprResolver bodyResolver = new ExprResolver(false, signatureResolver.allowedLevels());
        for (Decl.DataCtor ctor : decl.body) {
            Ref localCtxWithPat = new Ref((Object)((Context)local._2));
            ctor.patterns = ctor.patterns.map(pattern -> PatResolver.INSTANCE.subpatterns((Ref<Context>)localCtxWithPat, (Pattern)pattern));
            Tuple2<ImmutableSeq<Expr.Param>, Context> ctorLocal = bodyResolver.resolveParams((SeqLike<Expr.Param>)ctor.telescope, (Context)localCtxWithPat.value);
            ctor.telescope = (ImmutableSeq)ctorLocal._1;
            ctor.clauses = ctor.clauses.map(clause -> PatResolver.INSTANCE.matchy((Pattern.Clause)clause, (Context)ctorLocal._2, bodyResolver));
        }
        return Unit.unit();
    }

    @Override
    public Unit visitStruct( @NotNull Decl.StructDecl decl, BinOpSet opSet) {
        ExprResolver signatureResolver = new ExprResolver(true, (Buffer<PreLevelVar>)Buffer.create());
        Tuple2<ImmutableSeq<Expr.Param>, Context> local = signatureResolver.resolveParams((SeqLike<Expr.Param>)decl.telescope, decl.ctx);
        decl.telescope = (ImmutableSeq)local._1;
        decl.result = decl.result.accept(signatureResolver, (Context)local._2);
        ExprResolver bodyResolver = new ExprResolver(false, signatureResolver.allowedLevels());
        decl.fields.forEach(field -> {
            Tuple2<ImmutableSeq<Expr.Param>, Context> fieldLocal = bodyResolver.resolveParams((SeqLike<Expr.Param>)field.telescope, (Context)local._2);
            field.telescope = (ImmutableSeq)fieldLocal._1;
            field.result = field.result.accept(bodyResolver, (Context)fieldLocal._2);
            field.body = field.body.map(e -> e.accept(bodyResolver, fieldLocal._2));
            field.clauses = field.clauses.map(clause -> PatResolver.INSTANCE.matchy((Pattern.Clause)clause, (Context)fieldLocal._2, bodyResolver));
        });
        return Unit.unit();
    }

    @Override
    public Unit visitFn( @NotNull Decl.FnDecl decl, BinOpSet opSet) {
        ExprResolver signatureResolver = new ExprResolver(true, (Buffer<PreLevelVar>)Buffer.create());
        Tuple2<ImmutableSeq<Expr.Param>, Context> local = signatureResolver.resolveParams((SeqLike<Expr.Param>)decl.telescope, decl.ctx);
        decl.telescope = (ImmutableSeq)local._1;
        decl.result = decl.result.accept(signatureResolver, (Context)local._2);
        ExprResolver bodyResolver = new ExprResolver(false, signatureResolver.allowedLevels());
        decl.body = decl.body.map(expr -> expr.accept(bodyResolver, local._2), pats -> pats.map(clause -> PatResolver.INSTANCE.matchy((Pattern.Clause)clause, (Context)local._2, bodyResolver)));
        return Unit.unit();
    }

    @Override
    public Unit visitPrim(@NotNull Decl.PrimDecl decl, BinOpSet opSet) {
        Tuple2<ImmutableSeq<Expr.Param>, Context> local = ExprResolver.NO_GENERALIZED.resolveParams((SeqLike<Expr.Param>)decl.telescope, decl.ctx);
        decl.telescope = (ImmutableSeq)local._1;
        if (decl.result != null) {
            decl.result = decl.result.accept(ExprResolver.NO_GENERALIZED, (Context)local._2);
        }
        return Unit.unit();
    }

    @Override
    public Unit visitLevels( @NotNull Generalize.Levels levels, BinOpSet binOpSet) {
        return Unit.unit();
    }

    @Override
    public Unit visitExample( @NotNull Sample.Working example, BinOpSet binOpSet) {
        example.delegate().accept(this, binOpSet);
        return Unit.unit();
    }

    @Override
    public Unit visitCounterexample( @NotNull Sample.Counter example, BinOpSet binOpSet) {
        example.delegate().accept(this, binOpSet);
        return Unit.unit();
    }
}

