/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.stmt;

import java.util.EnumSet;
import java.util.function.BiFunction;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Either;
import kala.control.Option;
import org.aya.api.concrete.ConcreteDecl;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.DefVar;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.resolve.context.Context;
import org.aya.concrete.stmt.OpDecl;
import org.aya.concrete.stmt.Signatured;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.generic.Modifier;
import org.aya.tyck.StmtTycker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Decl
extends Signatured
implements Stmt,
ConcreteDecl {
    @NotNull
    public final Stmt.Accessibility accessibility;
    @NotNull
    public final ImmutableSeq<Stmt> abuseBlock;
    @Nullable
    public Context ctx = null;

    @Override
    @NotNull
    public Stmt.Accessibility accessibility() {
        return this.accessibility;
    }

    protected Decl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull Stmt.Accessibility accessibility, @NotNull ImmutableSeq<Stmt> abuseBlock, @NotNull ImmutableSeq<Expr.Param> telescope) {
        super(sourcePos, entireSourcePos, telescope);
        this.accessibility = accessibility;
        this.abuseBlock = abuseBlock;
    }

    @Contract(pure=true)
    @NotNull
    public abstract DefVar<? extends Def, ? extends Decl> ref();

    protected abstract <P, R> R doAccept(@NotNull Visitor<P, R> var1, P var2);

    @NotNull
    public Def tyck(@NotNull Reporter reporter,  @Nullable Trace.Builder builder) {
        return new StmtTycker(reporter, builder).tyck(this);
    }

    @Override
    public final <P, R> R accept(@NotNull Stmt.Visitor<P, R> visitor, P p) {
        return this.accept((Visitor<P, R>)visitor, p);
    }

    public final <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
        visitor.traceEntrance(this, p);
        R ret = this.doAccept(visitor, p);
        visitor.traceExit(p, ret);
        return ret;
    }

    @Override
    @ApiStatus.NonExtendable
    public final <P, R> R doAccept(@NotNull Stmt.Visitor<P, R> visitor, P p) {
        return this.doAccept((Visitor<P, R>)visitor, p);
    }

    public static interface Visitor<P, R> {
        default public void traceEntrance(@NotNull Signatured item, P p) {
        }

        default public void traceExit(P p, R r) {
        }

        @ApiStatus.NonExtendable
        default public <T extends Signatured, RR extends R> RR traced(@NotNull T yeah, P p, @NotNull BiFunction<T, P, RR> f) {
            this.traceEntrance(yeah, p);
            RR r = f.apply(yeah, p);
            this.traceExit(p, r);
            return r;
        }

        @ApiStatus.OverrideOnly
        public R visitCtor(@NotNull DataCtor var1, P var2);

        @ApiStatus.OverrideOnly
        public R visitField(@NotNull StructField var1, P var2);

        public R visitData(@NotNull DataDecl var1, P var2);

        public R visitStruct(@NotNull StructDecl var1, P var2);

        public R visitFn(@NotNull FnDecl var1, P var2);

        public R visitPrim(@NotNull PrimDecl var1, P var2);
    }

    public static final class FnDecl
    extends Decl
    implements OpDecl {
        @NotNull
        public final EnumSet<Modifier> modifiers;
        @Nullable
        public final OpDecl.Operator operator;
        @NotNull
        public final DefVar<FnDef, FnDecl> ref;
        @NotNull
        public Expr result;
        @NotNull
        public Either<Expr, ImmutableSeq<Pattern.Clause>> body;

        public FnDecl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull Stmt.Accessibility accessibility, @NotNull EnumSet<Modifier> modifiers, @Nullable OpDecl.Operator operator, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result, @NotNull Either<Expr, ImmutableSeq<Pattern.Clause>> body, @NotNull ImmutableSeq<Stmt> abuseBlock) {
            super(sourcePos, entireSourcePos, accessibility, abuseBlock, telescope);
            this.modifiers = modifiers;
            this.operator = operator;
            this.ref = DefVar.concrete((ConcreteDecl)this, (String)name);
            this.result = result;
            this.body = body;
        }

        @Override
        protected <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitFn(this, p);
        }

        @NotNull
        public DefVar<FnDef, FnDecl> ref() {
            return this.ref;
        }

        @Override
        @Nullable
        public OpDecl.Operator asOperator() {
            return this.operator;
        }
    }

    public static final class StructField
    extends Signatured {
        @NotNull
        public final DefVar<FieldDef, StructField> ref;
        public DefVar<StructDef, StructDecl> structRef;
        @NotNull
        public ImmutableSeq<Pattern.Clause> clauses;
        @NotNull
        public Expr result;
        @NotNull
        public Option<Expr> body;
        public final boolean coerce;

        public StructField(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result, @NotNull Option<Expr> body, @NotNull ImmutableSeq<Pattern.Clause> clauses, boolean coerce) {
            super(sourcePos, entireSourcePos, telescope);
            this.coerce = coerce;
            this.result = result;
            this.clauses = clauses;
            this.body = body;
            this.ref = DefVar.concrete((ConcreteDecl)this, (String)name);
        }

        @NotNull
        public DefVar<? extends Def, StructField> ref() {
            return this.ref;
        }
    }

    public static final class StructDecl
    extends Decl
    implements OpDecl {
        @NotNull
        public final DefVar<StructDef, StructDecl> ref;
        @NotNull
        public final ImmutableSeq<StructField> fields;
        @Nullable
        public final OpDecl.Operator operator;
        @NotNull
        public Expr result;

        public StructDecl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull Stmt.Accessibility accessibility, @Nullable OpDecl.Operator operator, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result, @NotNull ImmutableSeq<StructField> fields, @NotNull ImmutableSeq<Stmt> abuseBlock) {
            super(sourcePos, entireSourcePos, accessibility, abuseBlock, telescope);
            this.operator = operator;
            this.result = result;
            this.fields = fields;
            this.ref = DefVar.concrete((ConcreteDecl)this, (String)name);
            fields.forEach(field -> {
                field.structRef = this.ref;
            });
        }

        @NotNull
        public DefVar<? extends Def, StructDecl> ref() {
            return this.ref;
        }

        @Override
        protected <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitStruct(this, p);
        }

        @Override
        @Nullable
        public OpDecl.Operator asOperator() {
            return this.operator;
        }
    }

    public static final class DataDecl
    extends Decl
    implements OpDecl {
        @NotNull
        public final DefVar<DataDef, DataDecl> ref;
        @NotNull
        public Expr result;
        @NotNull
        public final ImmutableSeq<DataCtor> body;
        @Nullable
        public OpDecl.Operator operator;

        public DataDecl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @NotNull Stmt.Accessibility accessibility, @Nullable OpDecl.Operator operator, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull Expr result, @NotNull ImmutableSeq<DataCtor> body, @NotNull ImmutableSeq<Stmt> abuseBlock) {
            super(sourcePos, entireSourcePos, accessibility, abuseBlock, telescope);
            this.result = result;
            this.body = body;
            this.operator = operator;
            this.ref = DefVar.concrete((ConcreteDecl)this, (String)name);
            body.forEach(ctors -> {
                ctors.dataRef = this.ref;
            });
        }

        @Override
        protected <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitData(this, p);
        }

        @NotNull
        public DefVar<DataDef, DataDecl> ref() {
            return this.ref;
        }

        @Override
        @Nullable
        public OpDecl.Operator asOperator() {
            return this.operator;
        }
    }

    public static final class DataCtor
    extends Signatured
    implements OpDecl {
        @NotNull
        public final DefVar<CtorDef, DataCtor> ref;
        public DefVar<DataDef, DataDecl> dataRef;
        @NotNull
        public ImmutableSeq<Pattern.Clause> clauses;
        @NotNull
        public ImmutableSeq<Pattern> patterns;
        @Nullable
        public final OpDecl.Operator operator;
        public final boolean coerce;

        public DataCtor(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @Nullable OpDecl.Operator operator, @NotNull String name, @NotNull ImmutableSeq<Expr.Param> telescope, @NotNull ImmutableSeq<Pattern.Clause> clauses, @NotNull ImmutableSeq<Pattern> patterns, boolean coerce) {
            super(sourcePos, entireSourcePos, telescope);
            this.clauses = clauses;
            this.operator = operator;
            this.coerce = coerce;
            this.patterns = patterns;
            this.ref = DefVar.concrete((ConcreteDecl)this, (String)name);
        }

        @NotNull
        public DefVar<CtorDef, DataCtor> ref() {
            return this.ref;
        }

        @Override
        @Nullable
        public OpDecl.Operator asOperator() {
            return this.operator;
        }
    }

    public static final class PrimDecl
    extends Decl
    implements OpDecl {
        @NotNull
        public final DefVar<? extends PrimDef, PrimDecl> ref;
        @Nullable
        public Expr result;
        @Nullable
        public final OpDecl.Operator operator;

        public PrimDecl(@NotNull SourcePos sourcePos, @NotNull SourcePos entireSourcePos, @Nullable OpDecl.Operator operator, @NotNull DefVar<? extends PrimDef, PrimDecl> ref, @NotNull ImmutableSeq<Expr.Param> telescope, @Nullable Expr result) {
            super(sourcePos, entireSourcePos, Stmt.Accessibility.Public, (ImmutableSeq<Stmt>)ImmutableSeq.empty(), telescope);
            this.result = result;
            this.operator = operator;
            ref.concrete = this;
            this.ref = ref;
        }

        @NotNull
        public DefVar<? extends PrimDef, PrimDecl> ref() {
            return this.ref;
        }

        @Override
        protected <P, R> R doAccept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitPrim(this, p);
        }

        @Override
        @Nullable
        public OpDecl.Operator asOperator() {
            return this.operator;
        }
    }
}

