/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.stmt;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import kala.collection.immutable.ImmutableSeq;
import org.aya.api.error.CollectingReporter;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.Var;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Stmt;
import org.aya.core.def.Def;
import org.aya.core.def.UserDef;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.StmtTycker;
import org.aya.tyck.error.CounterexampleError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Sample
extends Stmt {
    @NotNull
    public Stmt delegate();

    @Nullable
    public Def tyck(@NotNull Reporter var1,  @Nullable Trace.Builder var2);

    @Override
    @NotNull
    default public SourcePos sourcePos() {
        return this.delegate().sourcePos();
    }

    @Override
    @NotNull
    default public Stmt.Accessibility accessibility() {
        return Stmt.Accessibility.Private;
    }

    public static final class Counter
    extends Record
    implements Sample {
        @NotNull
        private final Decl delegate;
        @NotNull
        private final CollectingReporter reporter;

        public Counter(@NotNull Decl delegate) {
            this(delegate, new CollectingReporter());
        }

        public Counter(@NotNull Decl delegate, @NotNull CollectingReporter reporter) {
            this.delegate = delegate;
            this.reporter = reporter;
        }

        @Override
        public <P, R> R doAccept(@NotNull Stmt.Visitor<P, R> visitor, P p) {
            return visitor.visitCounterexample(this, p);
        }

        @Override
        @Nullable
        public Def tyck(@NotNull Reporter reporter,  @Nullable Trace.Builder traceBuilder) {
            StmtTycker stmtTycker = new StmtTycker(reporter, traceBuilder);
            Def def = stmtTycker.tyck(this.delegate, new ExprTycker((Reporter)this.reporter, stmtTycker.traceBuilder()));
            ImmutableSeq problems = this.reporter.problems().toImmutableSeq();
            if (problems.isEmpty()) {
                stmtTycker.reporter().report((Problem)new CounterexampleError(this.delegate.sourcePos(), (Var)this.delegate.ref()));
            }
            if (def instanceof UserDef) {
                UserDef userDef = (UserDef)def;
                userDef.problems = problems;
                return userDef;
            }
            return null;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Counter.class, "delegate;reporter", "delegate", "reporter"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Counter.class, "delegate;reporter", "delegate", "reporter"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Counter.class, "delegate;reporter", "delegate", "reporter"}, this, o);
        }

        @Override
        @NotNull
        public Decl delegate() {
            return this.delegate;
        }

        @NotNull
        public CollectingReporter reporter() {
            return this.reporter;
        }
    }

    public record Working(@NotNull Stmt delegate) implements Sample
    {
        @Override
        public <P, R> R doAccept(@NotNull Stmt.Visitor<P, R> visitor, P p) {
            return visitor.visitExample(this, p);
        }

        @Override
        @Nullable
        public Def tyck(@NotNull Reporter reporter,  @Nullable Trace.Builder traceBuilder) {
            Def def;
            Stmt stmt = this.delegate;
            if (stmt instanceof Decl) {
                Decl decl = (Decl)stmt;
                def = new StmtTycker(reporter, traceBuilder).tyck(decl);
            } else {
                def = null;
            }
            return def;
        }
    }
}

