/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.stmt;

import kala.collection.immutable.ImmutableSeq;
import kala.tuple.Unit;
import org.aya.api.distill.AyaDocile;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourcePos;
import org.aya.concrete.desugar.BinOpSet;
import org.aya.concrete.desugar.Desugarer;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.resolve.visitor.StmtResolver;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.Sample;
import org.aya.distill.ConcreteDistiller;
import org.aya.pretty.doc.Doc;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Stmt
extends AyaDocile {
    @Contract(pure=true)
    @NotNull
    public SourcePos sourcePos();

    @Contract(pure=true)
    @NotNull
    public Accessibility accessibility();

    @Contract(mutates="this")
    default public void resolve(@NotNull BinOpSet opSet) {
        this.accept(StmtResolver.INSTANCE, opSet);
    }

    default public void desugar(@NotNull Reporter reporter, @NotNull BinOpSet opSet) {
        this.accept(new Desugarer(reporter, opSet), Unit.unit());
    }

    @NotNull
    default public Doc toDoc(@NotNull DistillerOptions options) {
        return this.accept(new ConcreteDistiller(options), Unit.unit());
    }

    public <P, R> R doAccept(@NotNull Visitor<P, R> var1, P var2);

    default public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
        return this.doAccept(visitor, p);
    }

    public static interface Visitor<P, R>
    extends Decl.Visitor<P, R> {
        default public void visitAll(@NotNull @NotNull ImmutableSeq<@NotNull Stmt> stmts, P p) {
            stmts.forEach(stmt -> stmt.accept(this, p));
        }

        public R visitImport(@NotNull Command.Import var1, P var2);

        public R visitOpen(@NotNull Command.Open var1, P var2);

        public R visitModule(@NotNull Command.Module var1, P var2);

        public R visitBind(@NotNull Command.Bind var1, P var2);

        public R visitRemark(@NotNull Remark var1, P var2);

        public R visitLevels(@NotNull Generalize.Levels var1, P var2);

        public R visitExample(@NotNull Sample.Working var1, P var2);

        public R visitCounterexample(@NotNull Sample.Counter var1, P var2);
    }

    public static enum Accessibility {
        Private("private"),
        Public("public");

        @NotNull
        public final String keyword;

        private Accessibility(String keyword) {
            this.keyword = keyword;
        }

        public boolean lessThan(Accessibility accessibility) {
            return this.ordinal() < accessibility.ordinal();
        }
    }
}

