/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.visitor;

import kala.collection.immutable.ImmutableSeq;
import org.aya.api.distill.AyaDocile;
import org.aya.api.util.Arg;
import org.aya.concrete.Expr;
import org.aya.concrete.desugar.BinOpParser;
import org.jetbrains.annotations.NotNull;

public interface ExprFixpoint<P>
extends Expr.Visitor<P, Expr> {
    @Override
    @NotNull
    default public Expr visitRef(@NotNull Expr.RefExpr expr, P p) {
        return expr;
    }

    @Override
    @NotNull
    default public Expr visitUnresolved(@NotNull Expr.UnresolvedExpr expr, P p) {
        return expr;
    }

    @Override
    @NotNull
    default public Expr visitHole(@NotNull Expr.HoleExpr expr, P p) {
        Expr h;
        Expr expr2 = h = expr.filling() != null ? (Expr)expr.filling().accept(this, p) : null;
        if (h == expr.filling()) {
            return expr;
        }
        return new Expr.HoleExpr(expr.sourcePos(), expr.explicit(), h);
    }

    @NotNull
    default public @NotNull ImmutableSeq<@NotNull Expr.Param> visitParams(@NotNull @NotNull ImmutableSeq<@NotNull Expr.Param> params, P p) {
        return params.map(param -> {
            Expr oldType = param.type();
            if (oldType == null) {
                return param;
            }
            Expr type = (Expr)oldType.accept(this, p);
            if (type == oldType) {
                return param;
            }
            return new Expr.Param(param.sourcePos(), param.ref(), type, param.explicit());
        });
    }

    @Override
    @NotNull
    default public Expr visitLam(@NotNull Expr.LamExpr expr, P p) {
        Expr.Param bind = (Expr.Param)this.visitParams((ImmutableSeq<Expr.Param>)ImmutableSeq.of((Object)expr.param()), p).get(0);
        Expr body = (Expr)expr.body().accept(this, p);
        if (bind == expr.param() && body == expr.body()) {
            return expr;
        }
        return new Expr.LamExpr(expr.sourcePos(), bind, body);
    }

    @Override
    @NotNull
    default public Expr visitError(@NotNull Expr.ErrorExpr error, P p) {
        return error;
    }

    @Override
    @NotNull
    default public Expr visitPi(@NotNull Expr.PiExpr expr, P p) {
        Expr.Param bind = (Expr.Param)this.visitParams((ImmutableSeq<Expr.Param>)ImmutableSeq.of((Object)expr.param()), p).get(0);
        Expr body = (Expr)expr.last().accept(this, p);
        if (bind == expr.param() && body == expr.last()) {
            return expr;
        }
        return new Expr.PiExpr(expr.sourcePos(), expr.co(), bind, body);
    }

    @Override
    @NotNull
    default public Expr visitSigma(@NotNull Expr.SigmaExpr expr, P p) {
        ImmutableSeq<Expr.Param> binds = this.visitParams(expr.params(), p);
        if (binds.sameElements(expr.params(), true)) {
            return expr;
        }
        return new Expr.SigmaExpr(expr.sourcePos(), expr.co(), binds);
    }

    @Override
    @NotNull
    default public Expr visitRawUniv(@NotNull Expr.RawUnivExpr expr, P p) {
        return expr;
    }

    @Override
    @NotNull
    default public Expr visitRawUnivArgs(@NotNull Expr.RawUnivArgsExpr expr, P p) {
        ImmutableSeq args = expr.univArgs().map(e -> (Expr)e.accept(this, p));
        if (args.sameElements(expr.univArgs(), true)) {
            return expr;
        }
        return new Expr.RawUnivArgsExpr(expr.sourcePos(), (ImmutableSeq<Expr>)args);
    }

    @Override
    @NotNull
    default public Expr visitUnivArgs(@NotNull Expr.UnivArgsExpr expr, P p) {
        return expr;
    }

    @Override
    @NotNull
    default public Expr visitUniv(@NotNull Expr.UnivExpr expr, P p) {
        return expr;
    }

    @NotNull
    default public Arg<Expr.NamedArg> visitArg(@NotNull Arg<Expr.NamedArg> arg, P p) {
        Expr term = (Expr)((Expr.NamedArg)arg.term()).expr().accept(this, p);
        if (term == ((Expr.NamedArg)arg.term()).expr()) {
            return arg;
        }
        return new Arg((AyaDocile)new Expr.NamedArg(((Expr.NamedArg)arg.term()).name(), term), arg.explicit());
    }

    @Override
    @NotNull
    default public Expr visitApp(@NotNull Expr.AppExpr expr, P p) {
        Expr function = (Expr)expr.function().accept(this, p);
        Arg<Expr.NamedArg> arg = this.visitArg(expr.argument(), p);
        if (function == expr.function() && arg == expr.argument()) {
            return expr;
        }
        return new Expr.AppExpr(expr.sourcePos(), function, arg);
    }

    @Override
    @NotNull
    default public Expr visitTup(@NotNull Expr.TupExpr expr, P p) {
        ImmutableSeq items = expr.items().map(item -> (Expr)item.accept(this, p));
        if (items.sameElements(expr.items(), true)) {
            return expr;
        }
        return new Expr.TupExpr(expr.sourcePos(), (ImmutableSeq<Expr>)items);
    }

    @Override
    @NotNull
    default public Expr visitProj(@NotNull Expr.ProjExpr expr, P p) {
        Expr tup = (Expr)expr.tup().accept(this, p);
        if (tup == expr.tup()) {
            return expr;
        }
        return new Expr.ProjExpr(expr.sourcePos(), tup, expr.ix(), expr.resolvedIx());
    }

    @Override
    @NotNull
    default public Expr visitLsuc(@NotNull Expr.LSucExpr expr, P p) {
        Expr lvl = (Expr)expr.expr().accept(this, p);
        if (lvl == expr.expr()) {
            return expr;
        }
        return new Expr.LSucExpr(expr.sourcePos(), lvl);
    }

    @Override
    @NotNull
    default public Expr visitLmax(@NotNull Expr.LMaxExpr expr, P p) {
        ImmutableSeq fields = expr.levels().map(t -> (Expr)t.accept(this, p));
        if (fields.sameElements(expr.levels(), true)) {
            return expr;
        }
        return new Expr.LMaxExpr(expr.sourcePos(), (ImmutableSeq<Expr>)fields);
    }

    @Override
    @NotNull
    default public Expr visitNew(@NotNull Expr.NewExpr expr, P p) {
        Expr struct = (Expr)expr.struct().accept(this, p);
        ImmutableSeq fields = expr.fields().map(t -> this.visitField((Expr.Field)t, p));
        if (expr.struct() == struct && fields.sameElements(expr.fields(), true)) {
            return expr;
        }
        return new Expr.NewExpr(expr.sourcePos(), struct, (ImmutableSeq<Expr.Field>)fields);
    }

    default public @NotNull Expr.Field visitField(@NotNull Expr.Field t, P p) {
        Expr accept = (Expr)t.body().accept(this, p);
        if (accept == t.body()) {
            return t;
        }
        return new Expr.Field(t.name(), t.bindings(), accept);
    }

    @Override
    @NotNull
    default public Expr visitLitInt(@NotNull Expr.LitIntExpr expr, P p) {
        return expr;
    }

    @Override
    @NotNull
    default public Expr visitLitString(@NotNull Expr.LitStringExpr expr, P p) {
        return expr;
    }

    @Override
    @NotNull
    default public Expr visitBinOpSeq(@NotNull Expr.BinOpSeq binOpSeq, P p) {
        return new Expr.BinOpSeq(binOpSeq.sourcePos(), (ImmutableSeq<BinOpParser.Elem>)binOpSeq.seq().map(e -> new BinOpParser.Elem(e.name(), (Expr)e.expr().accept(this, p), e.explicit())));
    }
}

