/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.visitor;

import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableHashSet;
import kala.control.Option;
import kala.tuple.Unit;
import org.aya.api.distill.AyaDocile;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.ref.Var;
import org.aya.concrete.Expr;
import org.aya.concrete.resolve.error.UnqualifiedNameNotFoundError;
import org.aya.concrete.visitor.ExprFixpoint;
import org.jetbrains.annotations.NotNull;

public record ExprRefSubst(@NotNull Reporter reporter, @NotNull MutableHashMap<Var, Var> good, @NotNull MutableHashSet<Var> bad) implements ExprFixpoint<Unit>,
Cloneable
{
    public ExprRefSubst(@NotNull Reporter reporter) {
        this(reporter, (MutableHashMap<Var, Var>)MutableHashMap.of(), (MutableHashSet<Var>)MutableHashSet.of());
    }

    @Override
    @NotNull
    public Expr visitRef(@NotNull Expr.RefExpr expr, Unit unit) {
        Var v = expr.resolvedVar();
        if (this.bad.contains((Object)v)) {
            this.reporter.report((Problem)new UnqualifiedNameNotFoundError(v.name(), expr.sourcePos()));
            return new Expr.ErrorExpr(expr.sourcePos(), (AyaDocile)expr);
        }
        Option rv = this.good.getOption((Object)v);
        if (rv.isDefined()) {
            return new Expr.RefExpr(expr.sourcePos(), (Var)rv.get()).accept(this, unit);
        }
        return expr;
    }

    public void clear() {
        this.good.clear();
        this.bad.clear();
    }

    public void resetTo(@NotNull ExprRefSubst subst) {
        this.good.clear();
        this.bad.clear();
        this.good.putAll(subst.good);
        this.bad.addAll(subst.bad);
    }

    @NotNull
    public ExprRefSubst clone() {
        return new ExprRefSubst(this.reporter, this.good, this.bad);
    }
}

