/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.visitor;

import kala.tuple.Unit;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.Sample;
import org.aya.concrete.stmt.Signatured;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.visitor.ExprConsumer;
import org.jetbrains.annotations.NotNull;

public interface StmtConsumer<P>
extends Stmt.Visitor<P, Unit>,
ExprConsumer<P>,
Pattern.Visitor<P, Unit> {
    default public void visitSignatured(@NotNull Signatured signatured, P pp) {
        signatured.telescope.forEach(p -> {
            Expr type = p.type();
            if (type != null) {
                type.accept(this, pp);
            }
        });
    }

    default public void visitDecl(@NotNull Decl decl, P pp) {
        this.visitSignatured(decl, pp);
        decl.abuseBlock.forEach(stmt -> stmt.accept(this, pp));
    }

    default public void visitClause(@NotNull Pattern.Clause c, P pp) {
        c.patterns.forEach(pattern -> pattern.accept(this, pp));
        c.expr.forEach(expr -> expr.accept(this, pp));
    }

    @Override
    default public Unit visitData(@NotNull Decl.DataDecl decl, P p) {
        this.visitDecl(decl, p);
        decl.result.accept(this, p);
        decl.body.forEach(ctor -> this.traced(ctor, p, this::visitCtor));
        return Unit.unit();
    }

    @Override
    default public Unit visitStruct(@NotNull Decl.StructDecl decl, P p) {
        this.visitDecl(decl, p);
        decl.result.accept(this, p);
        decl.fields.forEach(field -> this.traced(field, p, this::visitField));
        return Unit.unit();
    }

    @Override
    default public Unit visitFn(@NotNull Decl.FnDecl decl, P p) {
        this.visitDecl(decl, p);
        decl.result.accept(this, p);
        decl.body.forEach(expr -> expr.accept(this, p), clauses -> clauses.forEach(clause -> this.visitClause((Pattern.Clause)clause, p)));
        return Unit.unit();
    }

    @Override
    default public Unit visitPrim(@NotNull Decl.PrimDecl decl, P p) {
        this.visitDecl(decl, p);
        if (decl.result != null) {
            decl.result.accept(this, p);
        }
        return Unit.unit();
    }

    @Override
    default public Unit visitImport(@NotNull Command.Import cmd, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitOpen(@NotNull Command.Open cmd, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitModule(@NotNull Command.Module mod, P p) {
        mod.contents().forEach(stmt -> stmt.accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitCtor(@NotNull Decl.DataCtor ctor, P p) {
        this.visitSignatured(ctor, p);
        ctor.patterns.forEach(pattern -> pattern.accept(this, p));
        ctor.clauses.forEach(clause -> this.visitClause((Pattern.Clause)clause, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitField(@NotNull Decl.StructField field, P p) {
        this.visitSignatured(field, p);
        field.result.accept(this, p);
        field.clauses.forEach(clause -> this.visitClause((Pattern.Clause)clause, p));
        field.body.forEach(expr -> expr.accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitBind(@NotNull Command.Bind bind, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitRemark(@NotNull Remark remark, P p) {
        if (remark.literate != null) {
            remark.literate.visit(this, p);
        }
        return Unit.unit();
    }

    @Override
    default public Unit visitLevels(@NotNull Generalize.Levels levels, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitTuple(@NotNull Pattern.Tuple tuple, P p) {
        tuple.patterns().forEach(pattern -> pattern.accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitNumber(@NotNull Pattern.Number number, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitAbsurd(@NotNull Pattern.Absurd absurd, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitCalmFace(@NotNull Pattern.CalmFace calmFace, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitBind(@NotNull Pattern.Bind bind, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitCtor(@NotNull Pattern.Ctor ctor, P p) {
        ctor.params().forEach(pattern -> pattern.accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitExample(@NotNull Sample.Working example, P p) {
        return (Unit)example.delegate().accept(this, p);
    }

    @Override
    default public Unit visitCounterexample(@NotNull Sample.Counter example, P p) {
        return (Unit)example.delegate().accept(this, p);
    }
}

