/*
 * Decompiled with CFR 0.152.
 */
package org.aya.concrete.visitor;

import kala.control.Option;
import kala.tuple.Unit;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.Sample;
import org.aya.concrete.stmt.Signatured;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.visitor.ExprFixpoint;
import org.jetbrains.annotations.NotNull;

public interface StmtFixpoint<P>
extends ExprFixpoint<P>,
Stmt.Visitor<P, Unit> {
    default public void visitSignatured(@NotNull Signatured signatured, P pp) {
        signatured.telescope = signatured.telescope.map(p -> p.mapExpr(expr -> (Expr)expr.accept(this, pp)));
    }

    @Override
    default public Unit visitRemark(@NotNull Remark remark, P p) {
        if (remark.literate != null) {
            remark.literate.modify(this, p);
        }
        return Unit.unit();
    }

    default public void visitDecl(@NotNull Decl decl, P pp) {
        this.visitSignatured(decl, pp);
        decl.abuseBlock.forEach(stmt -> stmt.accept(this, pp));
    }

    @NotNull
    default public Pattern.Clause visitClause(@NotNull Pattern.Clause c, P pp) {
        return new Pattern.Clause(c.sourcePos, c.patterns, (Option<Expr>)c.expr.map(expr -> (Expr)expr.accept(this, pp)));
    }

    @Override
    default public Unit visitData(@NotNull Decl.DataDecl decl, P p) {
        this.visitDecl(decl, p);
        decl.result = (Expr)decl.result.accept(this, p);
        decl.body.forEach(ctor -> this.traced(ctor, p, this::visitCtor));
        return Unit.unit();
    }

    @Override
    default public Unit visitStruct(@NotNull Decl.StructDecl decl, P p) {
        this.visitDecl(decl, p);
        decl.result = (Expr)decl.result.accept(this, p);
        decl.fields.forEach(field -> this.traced(field, p, this::visitField));
        return Unit.unit();
    }

    @Override
    default public Unit visitFn(@NotNull Decl.FnDecl decl, P p) {
        this.visitDecl(decl, p);
        decl.result = (Expr)decl.result.accept(this, p);
        decl.body = decl.body.map(expr -> (Expr)expr.accept(this, p), clauses -> clauses.map(clause -> this.visitClause((Pattern.Clause)clause, p)));
        return Unit.unit();
    }

    @Override
    default public Unit visitPrim(@NotNull Decl.PrimDecl decl, P p) {
        this.visitDecl(decl, p);
        if (decl.result != null) {
            decl.result = (Expr)decl.result.accept(this, p);
        }
        return Unit.unit();
    }

    @Override
    default public Unit visitImport(@NotNull Command.Import cmd, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitOpen(@NotNull Command.Open cmd, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitModule(@NotNull Command.Module mod, P p) {
        mod.contents().forEach(stmt -> stmt.accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitCtor(@NotNull Decl.DataCtor ctor, P p) {
        this.visitSignatured(ctor, p);
        ctor.clauses = ctor.clauses.map(clause -> this.visitClause((Pattern.Clause)clause, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitField(@NotNull Decl.StructField field, P p) {
        this.visitSignatured(field, p);
        field.result = (Expr)field.result.accept(this, p);
        field.clauses = field.clauses.map(clause -> this.visitClause((Pattern.Clause)clause, p));
        field.body = field.body.map(expr -> (Expr)expr.accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitBind(@NotNull Command.Bind bind, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitLevels(@NotNull Generalize.Levels levels, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitExample(@NotNull Sample.Working example, P p) {
        return (Unit)example.delegate().accept(this, p);
    }

    @Override
    default public Unit visitCounterexample(@NotNull Sample.Counter example, P p) {
        return (Unit)example.delegate().accept(this, p);
    }
}

