/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.term;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import kala.collection.Map;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.Buffer;
import kala.collection.mutable.MutableMap;
import kala.tuple.Tuple3;
import kala.tuple.Unit;
import org.aya.api.core.CoreTerm;
import org.aya.api.distill.AyaDocile;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.Bind;
import org.aya.api.ref.LocalVar;
import org.aya.api.ref.Var;
import org.aya.api.util.Arg;
import org.aya.api.util.NormalizeMode;
import org.aya.core.Meta;
import org.aya.core.ops.TermToPat;
import org.aya.core.pat.Pat;
import org.aya.core.sort.LevelSubst;
import org.aya.core.sort.Sort;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.visitor.Normalizer;
import org.aya.core.visitor.Renamer;
import org.aya.core.visitor.Substituter;
import org.aya.core.visitor.TermFixpoint;
import org.aya.core.visitor.VarConsumer;
import org.aya.core.visitor.Zonker;
import org.aya.distill.CoreDistiller;
import org.aya.generic.ParamLike;
import org.aya.pretty.doc.Doc;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.LittleTyper;
import org.aya.tyck.TyckState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Term
extends CoreTerm {
    public <P, R> R doAccept(@NotNull Visitor<P, R> var1, P var2);

    default public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
        visitor.traceEntrance(this, p);
        R ret = this.doAccept(visitor, p);
        visitor.traceExit(ret);
        return ret;
    }

    @Nullable
    default public Pat toPat(boolean explicit) {
        return TermToPat.toPat(this, explicit);
    }

    @NotNull
    default public Term subst(@NotNull Var var, @NotNull Term term) {
        return this.subst(new Substituter.TermSubst(var, term));
    }

    @NotNull
    default public Term subst(@NotNull Substituter.TermSubst subst) {
        return this.subst(subst, LevelSubst.EMPTY);
    }

    @NotNull
    default public Term subst(@NotNull Map<Var, Term> subst) {
        return this.accept(new Substituter(subst, LevelSubst.EMPTY), Unit.unit());
    }

    @NotNull
    default public Term subst(@NotNull Substituter.TermSubst subst, @NotNull LevelSubst levelSubst) {
        return this.accept(new Substituter(subst, levelSubst), Unit.unit());
    }

    @NotNull
    default public Term zonk(@NotNull ExprTycker tycker, @Nullable SourcePos pos) {
        return new Zonker(tycker.state, tycker.reporter).zonk(this, pos);
    }

    @NotNull
    default public Term rename() {
        return this.accept(new Renamer(), Unit.unit());
    }

    default public int findUsages(@NotNull Var var) {
        VarConsumer.UsageCounter counter = new VarConsumer.UsageCounter(var);
        this.accept(counter, Unit.unit());
        return counter.usageCount();
    }

    @NotNull
    default public Buffer<LocalVar> scopeCheck(@NotNull ImmutableSeq<LocalVar> allowed) {
        VarConsumer.ScopeChecker checker = new VarConsumer.ScopeChecker(allowed);
        this.accept(checker, Unit.unit());
        if (!2.$assertionsDisabled && !checker.isCleared()) {
            throw new AssertionError((Object)"The scope checker is not properly cleared up");
        }
        return checker.invalidVars;
    }

    @NotNull
    default public Term normalize(@Nullable TyckState state, @NotNull NormalizeMode mode) {
        if (mode == NormalizeMode.NULL) {
            return this;
        }
        return this.accept(new Normalizer(state), mode);
    }

    @NotNull
    default public Term freezeHoles(final @Nullable TyckState state) {
        return this.accept(new TermFixpoint<Unit>(){

            @Override
            @NotNull
            public Term visitHole(@NotNull CallTerm.Hole term, Unit unit) {
                if (state == null) {
                    return TermFixpoint.super.visitHole(term, unit);
                }
                Meta sol = term.ref();
                MutableMap<Meta, Term> metas = state.metas();
                if (!metas.containsKey((Object)sol)) {
                    return TermFixpoint.super.visitHole(term, unit);
                }
                return ((Term)metas.get((Object)sol)).accept(this, Unit.unit());
            }

            @Override
            @NotNull
            public Sort visitSort(@NotNull Sort sort, Unit unit) {
                return state != null ? state.levelEqns().applyTo(sort) : sort;
            }
        }, Unit.unit());
    }

    @NotNull
    default public Doc toDoc(@NotNull DistillerOptions options) {
        return this.accept(new CoreDistiller(options), false);
    }

    @NotNull
    default public Term computeType(@Nullable TyckState state) {
        return this.accept(new LittleTyper(state), Unit.unit());
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface Visitor<P, R> {
        default public void traceEntrance(@NotNull Term term, P p) {
        }

        default public void traceExit(R r) {
        }

        public R visitRef(@NotNull RefTerm var1, P var2);

        public R visitLam(@NotNull IntroTerm.Lambda var1, P var2);

        public R visitPi(@NotNull FormTerm.Pi var1, P var2);

        public R visitSigma(@NotNull FormTerm.Sigma var1, P var2);

        public R visitUniv(@NotNull FormTerm.Univ var1, P var2);

        public R visitApp(@NotNull ElimTerm.App var1, P var2);

        public R visitFnCall(@NotNull CallTerm.Fn var1, P var2);

        public R visitDataCall(@NotNull CallTerm.Data var1, P var2);

        public R visitConCall(@NotNull CallTerm.Con var1, P var2);

        public R visitStructCall(@NotNull CallTerm.Struct var1, P var2);

        public R visitPrimCall(@NotNull CallTerm.Prim var1, P var2);

        public R visitTup(@NotNull IntroTerm.Tuple var1, P var2);

        public R visitNew(@NotNull IntroTerm.New var1, P var2);

        public R visitProj(@NotNull ElimTerm.Proj var1, P var2);

        public R visitAccess(@NotNull CallTerm.Access var1, P var2);

        public R visitHole(@NotNull CallTerm.Hole var1, P var2);

        public R visitFieldRef(@NotNull RefTerm.Field var1, P var2);

        public R visitError(@NotNull ErrorTerm var1, P var2);
    }

    public static final class Param
    extends Record
    implements Bind,
    ParamLike<Term> {
        @NotNull
        private final LocalVar ref;
        @NotNull
        private final Term type;
        private final boolean explicit;

        public Param(@NotNull LocalVar ref, @NotNull Term type, boolean explicit) {
            this.ref = ref;
            this.type = type;
            this.explicit = explicit;
        }

        @NotNull
        public static @NotNull ImmutableSeq<@NotNull Param> fromBuffer(Buffer<Tuple3<LocalVar, Boolean, Term>> buf) {
            return buf.view().map(tup -> new Param((LocalVar)tup._1, (Term)tup._3, (Boolean)tup._2)).toImmutableSeq();
        }

        @Contract(value=" -> new")
        @NotNull
        public Param implicitify() {
            return new Param(this.ref, this.type, false);
        }

        @Contract(value=" -> new")
        @NotNull
        public Param rename() {
            return new Param(this.renameVar(), this.type, this.explicit);
        }

        @Contract(value=" -> new")
        @NotNull
        public LocalVar renameVar() {
            return new LocalVar(this.ref.name(), this.ref.definition());
        }

        @Contract(value=" -> new")
        @NotNull
        public @NotNull Arg<@NotNull Term> toArg() {
            return new Arg((AyaDocile)this.toTerm(), this.explicit);
        }

        @Contract(value=" -> new")
        @NotNull
        public RefTerm toTerm() {
            return new RefTerm(this.ref, this.type);
        }

        @NotNull
        public Param subst(@NotNull Var var, @NotNull Term term) {
            return this.subst(new Substituter.TermSubst(var, term));
        }

        @NotNull
        public Param subst(@NotNull Substituter.TermSubst subst) {
            return this.subst(subst, LevelSubst.EMPTY);
        }

        @NotNull
        public static ImmutableSeq<Param> subst(@NotNull @NotNull ImmutableSeq<@NotNull Param> params, @NotNull Substituter.TermSubst subst, @NotNull LevelSubst levelSubst) {
            return params.map(param -> param.subst(subst, levelSubst));
        }

        @NotNull
        public static ImmutableSeq<Param> subst(@NotNull @NotNull ImmutableSeq<@NotNull Param> params, @NotNull LevelSubst levelSubst) {
            return params.map(param -> param.subst(Substituter.TermSubst.EMPTY, levelSubst));
        }

        @NotNull
        public Param subst(@NotNull LevelSubst levelSubst) {
            return this.subst(Substituter.TermSubst.EMPTY, levelSubst);
        }

        @NotNull
        public Param subst(@NotNull Substituter.TermSubst subst, @NotNull LevelSubst levelSubst) {
            return new Param(this.ref, this.type.subst(subst, levelSubst), this.explicit);
        }

        @TestOnly
        @Contract(pure=true)
        public static boolean checkSubst(@NotNull @NotNull SeqLike<@NotNull Param> params, @NotNull SeqLike<Arg<Term>> args) {
            var obj = new Object(){
                boolean ok = true;
            };
            params.forEachIndexed((i, param) -> {
                obj.ok = obj.ok && param.explicit() == ((Arg)args.get(i)).explicit();
            });
            return obj.ok;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Param.class, "ref;type;explicit", "ref", "type", "explicit"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Param.class, "ref;type;explicit", "ref", "type", "explicit"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Param.class, "ref;type;explicit", "ref", "type", "explicit"}, this, o);
        }

        @NotNull
        public LocalVar ref() {
            return this.ref;
        }

        @Override
        @NotNull
        public Term type() {
            return this.type;
        }

        @Override
        public boolean explicit() {
            return this.explicit;
        }
    }
}

