/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import kala.collection.SeqLike;
import kala.collection.mutable.Buffer;
import kala.tuple.Unit;
import org.aya.api.core.CoreDef;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.Var;
import org.aya.core.Matching;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.term.Term;
import org.aya.core.visitor.VarConsumer;
import org.jetbrains.annotations.NotNull;

public record RefFinder(boolean withBody) implements Def.Visitor<Buffer<Def>, Unit>,
VarConsumer<Buffer<Def>>
{
    @NotNull
    public static final RefFinder HEADER_ONLY = new RefFinder(false);
    @NotNull
    public static final RefFinder HEADER_AND_BODY = new RefFinder(true);

    @Override
    public void visitVar(Var usage, @NotNull Buffer<Def> defs) {
        if (usage instanceof DefVar) {
            DefVar ref = (DefVar)usage;
            CoreDef coreDef = ref.core;
            if (coreDef instanceof Def) {
                Def def = (Def)coreDef;
                defs.append((Object)def);
            }
        }
    }

    @Override
    public Unit visitFn(@NotNull FnDef fn, @NotNull Buffer<Def> references) {
        this.tele(references, (SeqLike<Term.Param>)fn.telescope());
        fn.result().accept(this, references);
        if (this.withBody) {
            fn.body.map(term -> term.accept(this, references), clauses -> {
                clauses.forEach(clause -> this.matchy((Matching)clause, references));
                return Unit.unit();
            });
        }
        return Unit.unit();
    }

    @Override
    public Unit visitCtor(@NotNull CtorDef def, @NotNull Buffer<Def> references) {
        this.tele(references, (SeqLike<Term.Param>)def.selfTele);
        if (this.withBody) {
            for (Matching clause : def.clauses) {
                this.matchy(clause, references);
            }
        }
        return Unit.unit();
    }

    @Override
    public Unit visitStruct(@NotNull StructDef def, @NotNull Buffer<Def> references) {
        this.tele(references, (SeqLike<Term.Param>)def.telescope());
        def.result().accept(this, references);
        if (this.withBody) {
            def.fields.forEach(t -> t.accept(this, references));
        }
        return Unit.unit();
    }

    @Override
    public Unit visitField(@NotNull FieldDef def, @NotNull Buffer<Def> references) {
        this.tele(references, (SeqLike<Term.Param>)def.telescope());
        def.body.forEach(t -> t.accept(this, references));
        def.result().accept(this, references);
        if (this.withBody) {
            for (Matching clause : def.clauses) {
                clause.body().accept(this, references);
            }
        }
        return Unit.unit();
    }

    @Override
    public Unit visitPrim(@NotNull PrimDef def, @NotNull Buffer<Def> defs) {
        this.tele(defs, (SeqLike<Term.Param>)def.telescope());
        return Unit.unit();
    }

    @Override
    public Unit visitData(@NotNull DataDef def, @NotNull Buffer<Def> references) {
        this.tele(references, (SeqLike<Term.Param>)def.telescope());
        def.result().accept(this, references);
        if (this.withBody) {
            def.body.forEach(t -> t.accept(this, references));
        }
        return Unit.unit();
    }

    public void matchy(@NotNull Matching match, @NotNull Buffer<Def> defs) {
        match.body().accept(this, defs);
    }

    private void tele(@NotNull Buffer<Def> references, @NotNull SeqLike<Term.Param> telescope) {
        telescope.forEach(param -> param.type().accept(this, references));
    }
}

