/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import kala.collection.Map;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableHashMap;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableTreeMap;
import kala.tuple.Unit;
import org.aya.api.distill.AyaDocile;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.ref.Var;
import org.aya.core.sort.LevelSubst;
import org.aya.core.sort.Sort;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.TermFixpoint;
import org.aya.distill.BaseDistiller;
import org.aya.pretty.doc.Doc;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

public record Substituter(@NotNull Map<Var, Term> termSubst, @NotNull LevelSubst levelSubst) implements TermFixpoint<Unit>
{
    public Substituter(@NotNull TermSubst termSubst, @NotNull LevelSubst levelSubst) {
        this((Map<Var, Term>)termSubst.map, levelSubst);
    }

    @Override
    @NotNull
    public Sort visitSort(@NotNull Sort sort, Unit unit) {
        return this.levelSubst.applyTo(sort);
    }

    @Override
    @NotNull
    public Term visitFieldRef(@NotNull RefTerm.Field term, Unit unit) {
        return (Term)this.termSubst.getOption(term.ref()).map(Term::rename).getOrDefault((Object)term);
    }

    @Override
    @NotNull
    public Term visitRef(@NotNull RefTerm term, Unit unused) {
        return (Term)this.termSubst.getOption((Object)term.var()).map(Term::rename).getOrElse(() -> TermFixpoint.super.visitRef(term, Unit.unit()));
    }

    @Debug.Renderer(text="map.toString()", childrenArray="map.asJava().entrySet().toArray()", hasChildren="map.isNotEmpty()")
    public record TermSubst(@NotNull @NotNull MutableMap<@NotNull Var, @NotNull Term> map) implements AyaDocile
    {
        @NotNull
        public static final TermSubst EMPTY = new TermSubst((MutableMap<Var, Term>)MutableTreeMap.of((o1, o2) -> {
            throw new UnsupportedOperationException("Shall not modify LevelSubst.EMPTY");
        }));

        public TermSubst(@NotNull Var var, @NotNull Term term) {
            this((MutableMap<Var, Term>)MutableHashMap.of((Object)var, (Object)term));
        }

        public void subst(@NotNull TermSubst subst) {
            if (this.map.isEmpty()) {
                return;
            }
            this.map.replaceAll((var, term) -> term.subst(subst));
        }

        public ImmutableSeq<Var> overlap(@NotNull TermSubst subst) {
            if (subst.map.isEmpty() || this.map.isEmpty()) {
                return ImmutableSeq.empty();
            }
            return this.map.keysView().filter(arg_0 -> subst.map.containsKey(arg_0)).toImmutableSeq();
        }

        @NotNull
        public TermSubst addDirectly(@NotNull Var var, @NotNull Term term) {
            this.map.put((Object)var, (Object)term);
            return this;
        }

        @NotNull
        public TermSubst add(@NotNull Var var, @NotNull Term term) {
            this.subst(new TermSubst(var, term));
            return this.addDirectly(var, term);
        }

        @NotNull
        public TermSubst add(@NotNull TermSubst subst) {
            if (subst.map.isEmpty()) {
                return this;
            }
            this.subst(subst);
            this.map.putAll(subst.map);
            return this;
        }

        public void clear() {
            this.map.clear();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @NotNull
        public Doc toDoc(@NotNull DistillerOptions options) {
            return Doc.join((Doc)Doc.cat((Doc[])new Doc[]{Doc.plain((String)","), Doc.ONE_WS}), (SeqLike)this.map.view().map((var, term) -> Doc.sep((Doc[])new Doc[]{BaseDistiller.varDoc(var), Doc.symbol((String)"=>"), term.toDoc(options)})).toImmutableSeq());
        }
    }
}

