/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import kala.collection.SeqLike;
import kala.tuple.Unit;
import org.aya.api.util.Arg;
import org.aya.core.sort.Sort;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.jetbrains.annotations.NotNull;

public interface TermConsumer<P>
extends Term.Visitor<P, Unit> {
    @Override
    default public Unit visitHole(@NotNull CallTerm.Hole term, P p) {
        this.visitArgs(p, (SeqLike<Arg<Term>>)term.args());
        this.visitArgs(p, (SeqLike<Arg<Term>>)term.contextArgs());
        for (Sort sortArg : term.sortArgs()) {
            this.visitSort(sortArg, p);
        }
        return Unit.unit();
    }

    default public void visitSort(@NotNull Sort sort, P p) {
    }

    @Override
    default public Unit visitFieldRef(@NotNull RefTerm.Field term, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitLam(@NotNull IntroTerm.Lambda term, P p) {
        term.param().type().accept(this, p);
        return (Unit)term.body().accept(this, p);
    }

    @Override
    default public Unit visitUniv(@NotNull FormTerm.Univ term, P p) {
        this.visitSort(term.sort(), p);
        return Unit.unit();
    }

    @Override
    default public Unit visitPi(@NotNull FormTerm.Pi term, P p) {
        term.param().type().accept(this, p);
        return (Unit)term.body().accept(this, p);
    }

    @Override
    default public Unit visitSigma(@NotNull FormTerm.Sigma term, P p) {
        term.params().forEach(param -> param.type().accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitRef(@NotNull RefTerm term, P p) {
        term.type().accept(this, p);
        return Unit.unit();
    }

    default public void visitArg(@NotNull Arg<? extends Term> arg, P p) {
        ((Term)arg.term()).accept(this, p);
    }

    @Override
    default public Unit visitApp(@NotNull ElimTerm.App term, P p) {
        this.visitArg(term.arg(), p);
        return (Unit)term.of().accept(this, p);
    }

    @Override
    default public Unit visitFnCall(@NotNull CallTerm.Fn fnCall, P p) {
        this.visitArgs(p, (SeqLike<Arg<Term>>)fnCall.args());
        for (Sort sortArg : fnCall.sortArgs()) {
            this.visitSort(sortArg, p);
        }
        return Unit.unit();
    }

    @Override
    default public Unit visitPrimCall(@NotNull CallTerm.Prim prim, P p) {
        this.visitArgs(p, (SeqLike<Arg<Term>>)prim.args());
        for (Sort sortArg : prim.sortArgs()) {
            this.visitSort(sortArg, p);
        }
        return Unit.unit();
    }

    @Override
    default public Unit visitDataCall(@NotNull CallTerm.Data dataCall, P p) {
        this.visitArgs(p, (SeqLike<Arg<Term>>)dataCall.args());
        for (Sort sortArg : dataCall.sortArgs()) {
            this.visitSort(sortArg, p);
        }
        return Unit.unit();
    }

    @Override
    default public Unit visitConCall(@NotNull CallTerm.Con conCall, P p) {
        this.visitArgs(p, (SeqLike<Arg<Term>>)conCall.head().dataArgs());
        this.visitArgs(p, (SeqLike<Arg<Term>>)conCall.conArgs());
        for (Sort sortArg : conCall.sortArgs()) {
            this.visitSort(sortArg, p);
        }
        return Unit.unit();
    }

    @Override
    default public Unit visitStructCall(@NotNull CallTerm.Struct structCall, P p) {
        this.visitArgs(p, (SeqLike<Arg<Term>>)structCall.args());
        for (Sort sortArg : structCall.sortArgs()) {
            this.visitSort(sortArg, p);
        }
        return Unit.unit();
    }

    @Override
    default public Unit visitTup(@NotNull IntroTerm.Tuple term, P p) {
        term.items().forEach(item -> item.accept(this, p));
        return Unit.unit();
    }

    default public void visitArgs(P p, SeqLike<Arg<@NotNull Term>> args) {
        args.forEach(arg -> this.visitArg((Arg<Term>)arg, p));
    }

    @Override
    default public Unit visitNew(@NotNull IntroTerm.New newTerm, P p) {
        newTerm.struct().accept(this, p);
        newTerm.params().forEach((k, v) -> v.accept(this, p));
        return Unit.unit();
    }

    @Override
    default public Unit visitError(@NotNull ErrorTerm term, P p) {
        return Unit.unit();
    }

    @Override
    default public Unit visitProj(@NotNull ElimTerm.Proj term, P p) {
        return (Unit)term.of().accept(this, p);
    }

    @Override
    default public Unit visitAccess(@NotNull CallTerm.Access term, P p) {
        this.visitArgs(p, (SeqLike<Arg<Term>>)term.fieldArgs());
        for (Sort sortArg : term.sortArgs()) {
            this.visitSort(sortArg, p);
        }
        return (Unit)term.of().accept(this, p);
    }
}

