/*
 * Decompiled with CFR 0.152.
 */
package org.aya.core.visitor;

import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.Buffer;
import kala.collection.mutable.MutableMap;
import kala.tuple.Unit;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourcePos;
import org.aya.core.Meta;
import org.aya.core.sort.Sort;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.TermFixpoint;
import org.aya.pretty.doc.Doc;
import org.aya.tyck.TyckState;
import org.aya.tyck.error.LevelMismatchError;
import org.aya.tyck.unify.level.LevelEqnSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Zonker
implements TermFixpoint<Unit> {
    @NotNull
    public final TyckState state;
    @NotNull
    public final Reporter reporter;
    private boolean reported = false;

    public Zonker(@NotNull TyckState state, @NotNull Reporter reporter) {
        this.state = state;
        this.reporter = reporter;
    }

    @NotNull
    public Term zonk(@NotNull Term term, @Nullable SourcePos pos) {
        term = term.accept(this, Unit.unit());
        Buffer<LevelEqnSet.Eqn> eqns = this.state.levelEqns().eqns();
        if (eqns.isNotEmpty() && !this.reported) {
            this.reporter.report((Problem)new LevelMismatchError(pos, (ImmutableSeq<LevelEqnSet.Eqn>)eqns.toImmutableSeq()));
            eqns.clear();
        }
        return term;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Term visitHole(@NotNull CallTerm.Hole term, Unit unit) {
        Meta sol = term.ref();
        MutableMap<Meta, Term> metas = this.state.metas();
        if (!metas.containsKey((Object)sol)) {
            this.reporter.report((Problem)new UnsolvedMeta(sol.sourcePos));
            return new ErrorTerm(term);
        }
        return ((Term)metas.get((Object)sol)).accept(this, Unit.unit());
    }

    @Override
    @Nullable
    public Sort visitSort(@NotNull Sort sort, Unit unit) {
        sort = this.state.levelEqns().applyTo(sort);
        SourcePos sourcePos = sort.unsolvedPos();
        if (sourcePos != null) {
            this.reportLevelSolverError(sourcePos);
            return null;
        }
        return sort;
    }

    private void reportLevelSolverError(@NotNull SourcePos pos) {
        if (this.reported) {
            return;
        }
        this.reporter.report((Problem)new LevelMismatchError(pos, (ImmutableSeq<LevelEqnSet.Eqn>)this.state.levelEqns().eqns().toImmutableSeq()));
        this.reported = true;
    }

    @Override
    @NotNull
    public Term visitUniv(@NotNull FormTerm.Univ term, Unit unit) {
        Sort sort = this.state.levelEqns().applyTo(term.sort());
        SourcePos sourcePos = sort.unsolvedPos();
        if (sourcePos != null) {
            this.reportLevelSolverError(sourcePos);
            return new ErrorTerm(term);
        }
        if (sort == term.sort()) {
            return term;
        }
        return new FormTerm.Univ(sort);
    }

    public record UnsolvedMeta(@NotNull SourcePos sourcePos) implements Problem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.plain((String)"Unsolved meta");
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }
    }
}

