/*
 * Decompiled with CFR 0.152.
 */
package org.aya.distill;

import java.util.Objects;
import java.util.function.BiFunction;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.mutable.Buffer;
import kala.control.Option;
import org.aya.api.distill.AyaDocile;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.ref.LocalVar;
import org.aya.api.ref.Var;
import org.aya.api.util.Arg;
import org.aya.generic.ParamLike;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface BaseDistiller {
    @NotNull
    public static final Style KEYWORD = Style.preset((String)"aya:Keyword");
    @NotNull
    public static final Style FN_CALL = Style.preset((String)"aya:FnCall");
    @NotNull
    public static final Style DATA_CALL = Style.preset((String)"aya:DataCall");
    @NotNull
    public static final Style STRUCT_CALL = Style.preset((String)"aya:StructCall");
    @NotNull
    public static final Style CON_CALL = Style.preset((String)"aya:ConCall");
    @NotNull
    public static final Style FIELD_CALL = Style.preset((String)"aya:FieldCall");
    @NotNull
    public static final Style GENERALIZED = Style.preset((String)"aya:Generalized");

    @Contract(pure=true)
    @NotNull
    public DistillerOptions options();

    @NotNull
    default public Doc univDoc(boolean nestedCall, String head, @NotNull AyaDocile lvl) {
        Doc hd = Doc.styled((Style)KEYWORD, (String)head);
        if (!this.options().showLevels()) {
            return hd;
        }
        return this.visitCalls(hd, (SeqLike)Seq.of((Object)new Arg(lvl, true)), (BiFunction)(nc, l) -> l.toDoc(this.options()), nestedCall);
    }

    @NotNull
    default public <T extends AyaDocile> Doc visitCalls(@NotNull Doc fn, @NotNull @NotNull SeqLike<@NotNull Arg<@NotNull T>> args, @NotNull BiFunction<Boolean, T, Doc> formatter, boolean nestedCall) {
        if (args.isEmpty()) {
            return fn;
        }
        Doc call = Doc.sep((Doc[])new Doc[]{fn, Doc.sep((SeqLike)args.view().flatMap(arg -> {
            if (arg.explicit()) {
                return Option.of((Object)((Doc)formatter.apply(true, arg.term())));
            }
            if (this.options().showImplicitArgs()) {
                return Option.of((Object)Doc.braced((Doc)((Doc)formatter.apply(false, arg.term()))));
            }
            return Option.none();
        }))});
        return nestedCall ? Doc.parened((Doc)call) : call;
    }

    @NotNull
    default public Doc ctorDoc(boolean nestedCall, boolean ex, Doc ctorDoc, LocalVar ctorAs, boolean noParams) {
        Doc withAs;
        boolean as = ctorAs != null;
        Doc withEx = ex ? ctorDoc : Doc.braced((Doc)ctorDoc);
        Doc doc = withAs = !as ? withEx : Doc.sep((Doc[])new Doc[]{Doc.parened((Doc)withEx), Doc.plain((String)"as"), BaseDistiller.linkDef((Var)ctorAs)});
        return !ex && !as ? withAs : (nestedCall && !noParams ? Doc.parened((Doc)withAs) : withAs);
    }

    default public Doc visitTele(@NotNull SeqLike<? extends ParamLike<?>> telescope) {
        if (telescope.isEmpty()) {
            return Doc.empty();
        }
        ParamLike last = (ParamLike)telescope.first();
        Buffer buf = Buffer.create();
        Buffer names = Buffer.of((Object)last.nameDoc());
        for (ParamLike param : telescope.view().drop(1)) {
            if (!Objects.equals(param.type(), last.type())) {
                buf.append((Object)last.toDoc(Doc.sep((SeqLike)names), this.options()));
                names.clear();
                last = param;
            }
            names.append((Object)param.nameDoc());
        }
        buf.append((Object)last.toDoc(Doc.sep((SeqLike)names), this.options()));
        return Doc.sep((SeqLike)buf);
    }

    @NotNull
    default public Doc lambdaParam(@NotNull ParamLike<?> param) {
        return this.options().showLambdaTypes() ? param.toDoc(this.options()) : (param.explicit() ? param.nameDoc() : Doc.braced((Doc)param.nameDoc()));
    }

    @NotNull
    public static Doc varDoc(@NotNull Var ref) {
        return Doc.linkRef((Doc)Doc.plain((String)ref.name()), (int)ref.hashCode());
    }

    @NotNull
    public static Doc coe(boolean coerce) {
        return coerce ? Doc.styled((Style)KEYWORD, (String)"coerce") : Doc.empty();
    }

    @NotNull
    public static Doc primDoc(Var ref) {
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"prim"), BaseDistiller.linkDef(ref, FN_CALL)});
    }

    @NotNull
    public static Doc linkDef(@NotNull Var ref, @NotNull Style color) {
        return Doc.linkDef((Doc)Doc.styled((Style)color, (String)ref.name()), (int)ref.hashCode());
    }

    @NotNull
    public static Doc linkRef(@NotNull Var ref, @NotNull Style color) {
        return Doc.linkRef((Doc)Doc.styled((Style)color, (String)ref.name()), (int)ref.hashCode());
    }

    @NotNull
    public static Doc linkDef(@NotNull Var ref) {
        return Doc.linkDef((Doc)Doc.plain((String)ref.name()), (int)ref.hashCode());
    }
}

