/*
 * Decompiled with CFR 0.152.
 */
package org.aya.distill;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.Buffer;
import kala.tuple.Unit;
import org.aya.api.concrete.ConcretePat;
import org.aya.api.distill.AyaDocile;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.PreLevelVar;
import org.aya.api.ref.Var;
import org.aya.api.util.Arg;
import org.aya.api.util.WithPos;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.concrete.desugar.BinOpParser;
import org.aya.concrete.remark.Literate;
import org.aya.concrete.remark.Remark;
import org.aya.concrete.stmt.Command;
import org.aya.concrete.stmt.Decl;
import org.aya.concrete.stmt.Generalize;
import org.aya.concrete.stmt.Sample;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.visitor.ExprConsumer;
import org.aya.distill.BaseDistiller;
import org.aya.generic.Modifier;
import org.aya.generic.ParamLike;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.util.StringEscapeUtil;
import org.jetbrains.annotations.NotNull;

public record ConcreteDistiller(@NotNull DistillerOptions options) implements Stmt.Visitor<Unit, Doc>,
Pattern.Visitor<Boolean, Doc>,
Expr.Visitor<Boolean, Doc>,
BaseDistiller
{
    @Override
    public Doc visitRef(@NotNull Expr.RefExpr expr, Boolean nestedCall) {
        Var ref = expr.resolvedVar();
        if (ref instanceof DefVar) {
            DefVar defVar = (DefVar)ref;
            return this.visitDefVar(defVar, defVar.concrete);
        }
        if (ref instanceof PreLevelVar) {
            PreLevelVar levelVar = (PreLevelVar)ref;
            return BaseDistiller.linkRef((Var)levelVar, GENERALIZED);
        }
        return BaseDistiller.varDoc(ref);
    }

    @NotNull
    private Doc visitDefVar(DefVar<?, ?> ref, Object concrete) {
        Object object = concrete;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.FnDecl.class, Decl.DataDecl.class, Decl.DataCtor.class, Decl.StructDecl.class, Decl.StructField.class, Decl.PrimDecl.class, Sample.class}, (Object)object, n)) {
            case 0 -> {
                Decl.FnDecl d = (Decl.FnDecl)object;
                yield BaseDistiller.linkRef(ref, FN_CALL);
            }
            case 1 -> {
                Decl.DataDecl d = (Decl.DataDecl)object;
                yield BaseDistiller.linkRef(ref, DATA_CALL);
            }
            case 2 -> {
                Decl.DataCtor d = (Decl.DataCtor)object;
                yield BaseDistiller.linkRef(ref, CON_CALL);
            }
            case 3 -> {
                Decl.StructDecl d = (Decl.StructDecl)object;
                yield BaseDistiller.linkRef(ref, STRUCT_CALL);
            }
            case 4 -> {
                Decl.StructField d = (Decl.StructField)object;
                yield BaseDistiller.linkRef(ref, FIELD_CALL);
            }
            case 5 -> {
                Decl.PrimDecl d = (Decl.PrimDecl)object;
                yield BaseDistiller.linkRef(ref, FN_CALL);
            }
            case 6 -> {
                Sample sample = (Sample)object;
                yield this.visitDefVar(ref, sample.delegate());
            }
            default -> BaseDistiller.varDoc(ref);
        };
    }

    @Override
    public Doc visitUnresolved(@NotNull Expr.UnresolvedExpr expr, Boolean nestedCall) {
        return Doc.plain((String)expr.name().join());
    }

    @Override
    public Doc visitLam(@NotNull Expr.LamExpr expr, Boolean nestedCall) {
        if (!this.options.showImplicitPats() && !expr.param().explicit()) {
            return expr.body().accept(this, nestedCall);
        }
        Buffer prelude = Buffer.of((Object)Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"\\")), (Object)this.lambdaParam(expr.param()));
        if (!(expr.body() instanceof Expr.HoleExpr)) {
            prelude.append((Object)Doc.symbol((String)"=>"));
            prelude.append((Object)expr.body().accept(this, false));
        }
        return Doc.sep((SeqLike)prelude);
    }

    @Override
    public Doc visitPi(final @NotNull Expr.PiExpr expr, Boolean nestedCall) {
        final boolean[] data = new boolean[]{false, false};
        expr.last().accept(new ExprConsumer<Unit>(){

            @Override
            public Unit visitRef(@NotNull Expr.RefExpr ref, Unit unit) {
                if (ref.resolvedVar() == expr.param().ref()) {
                    data[0] = true;
                }
                return unit;
            }

            @Override
            public Unit visitUnresolved(@NotNull Expr.UnresolvedExpr expr2, Unit unit) {
                data[1] = true;
                return unit;
            }
        }, Unit.unit());
        if (!data[0] && !data[1]) {
            Expr type = expr.param().type();
            Doc tyDoc = type != null ? type.toDoc(this.options) : Doc.symbol((String)"?");
            return Doc.sep((Doc[])new Doc[]{expr.param().explicit() ? tyDoc : Doc.braced((Doc)tyDoc), Doc.symbol((String)"->"), expr.last().accept(this, false)});
        }
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Pi")), expr.param().toDoc(this.options), Doc.symbol((String)"->"), expr.last().accept(this, false)});
    }

    @Override
    public Doc visitSigma(@NotNull Expr.SigmaExpr expr, Boolean nestedCall) {
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Sig")), this.visitTele((SeqLike<? extends ParamLike<?>>)expr.params().dropLast(1)), Doc.symbol((String)"**"), Objects.requireNonNull(((Expr.Param)expr.params().last()).type()).accept(this, false)});
    }

    @Override
    public Doc visitRawUniv(@NotNull Expr.RawUnivExpr expr, Boolean nestedCall) {
        return Doc.styled((Style)KEYWORD, (String)"Type");
    }

    @Override
    public Doc visitRawUnivArgs(@NotNull Expr.RawUnivArgsExpr expr, Boolean aBoolean) {
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"universe"), Doc.commaList((SeqLike)expr.univArgs().view().map(e -> e.accept(this, false)))});
    }

    @Override
    public Doc visitUnivArgs(@NotNull Expr.UnivArgsExpr expr, Boolean aBoolean) {
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"universe"), Doc.commaList((SeqLike)expr.univArgs().view().map(e -> e.toDoc(this.options)))});
    }

    @Override
    public Doc visitUniv(@NotNull Expr.UnivExpr expr, Boolean nestedCall) {
        Doc fn = Doc.styled((Style)KEYWORD, (String)"Type");
        if (!this.options.showLevels()) {
            return fn;
        }
        return this.visitCalls(fn, Seq.of(expr.level()).view().map(t -> new Arg((AyaDocile)t, true)), (nc, l) -> l.toDoc(this.options), nestedCall);
    }

    @Override
    public Doc visitApp(@NotNull Expr.AppExpr expr, Boolean nestedCall) {
        return this.visitCalls(expr.function().accept(this, false), Seq.of(expr.argument()), (nest, arg) -> arg.expr().accept(this, nest), nestedCall);
    }

    @Override
    public Doc visitLsuc(@NotNull Expr.LSucExpr expr, Boolean nestedCall) {
        return this.visitCalls(Doc.styled((Style)KEYWORD, (String)"lsuc"), ImmutableSeq.of((Object)new Arg((AyaDocile)expr.expr(), true)), (nest, arg) -> arg.accept(this, nest), nestedCall);
    }

    @Override
    public Doc visitLmax(@NotNull Expr.LMaxExpr expr, Boolean nestedCall) {
        return this.visitCalls(Doc.styled((Style)KEYWORD, (String)"lmax"), expr.levels().map(term -> new Arg((AyaDocile)term, true)), (nest, arg) -> arg.accept(this, nest), nestedCall);
    }

    @Override
    public Doc visitHole(@NotNull Expr.HoleExpr expr, Boolean nestedCall) {
        if (!expr.explicit()) {
            return Doc.symbol((String)"_");
        }
        Expr filling = expr.filling();
        if (filling == null) {
            return Doc.symbol((String)"{??}");
        }
        return Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"{?"), filling.accept(this, false), Doc.symbol((String)"?}")});
    }

    @Override
    public Doc visitTup(@NotNull Expr.TupExpr expr, Boolean nestedCall) {
        return Doc.parened((Doc)Doc.commaList((SeqLike)expr.items().view().map(e -> e.accept(this, false))));
    }

    @Override
    public Doc visitProj(@NotNull Expr.ProjExpr expr, Boolean nestedCall) {
        return Doc.cat((Doc[])new Doc[]{expr.tup().accept(this, false), Doc.plain((String)"."), Doc.plain((String)((String)expr.ix().fold(Objects::toString, WithPos::data)))});
    }

    @Override
    public Doc visitNew(@NotNull Expr.NewExpr expr, Boolean aBoolean) {
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"new"), expr.struct().accept(this, false), Doc.symbol((String)"{"), Doc.sep((SeqLike)expr.fields().view().map(t -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), Doc.plain((String)t.name()), Doc.emptyIf((boolean)t.bindings().isEmpty(), () -> Doc.sep((SeqLike)t.bindings().map(v -> BaseDistiller.varDoc((Var)v.data())))), Doc.plain((String)"=>"), t.body().accept(this, false)}))), Doc.symbol((String)"}")});
    }

    @Override
    public Doc visitLitInt(@NotNull Expr.LitIntExpr expr, Boolean nestedCall) {
        return Doc.plain((String)String.valueOf(expr.integer()));
    }

    @Override
    public Doc visitLitString(@NotNull Expr.LitStringExpr expr, Boolean nestedCall) {
        return Doc.plain((String)("\"" + StringEscapeUtil.escapeStringCharacters(expr.string()) + "\""));
    }

    @Override
    public Doc visitError(@NotNull Expr.ErrorExpr error, Boolean nestedCall) {
        return Doc.angled((Doc)error.description().toDoc(this.options));
    }

    @Override
    public Doc visitBinOpSeq(@NotNull Expr.BinOpSeq binOpSeq, Boolean nestedCall) {
        ImmutableSeq<BinOpParser.Elem> seq = binOpSeq.seq();
        if (seq.sizeEquals(1)) {
            return ((BinOpParser.Elem)seq.first()).expr().accept(this, nestedCall);
        }
        return this.visitCalls(((BinOpParser.Elem)seq.first()).expr().accept(this, false), seq.view().drop(1).map(e -> new Arg((AyaDocile)e.expr(), e.explicit())), (nest, arg) -> arg.accept(this, nest), nestedCall);
    }

    @Override
    public Doc visitTuple(@NotNull Pattern.Tuple tuple, Boolean nestedCall) {
        Doc tup = Doc.licit((boolean)tuple.explicit(), (Doc)Doc.commaList((SeqLike)tuple.patterns().view().map(p -> p.accept(this, false))));
        return tuple.as() == null ? tup : Doc.sep((Doc[])new Doc[]{tup, Doc.styled((Style)KEYWORD, (String)"as"), BaseDistiller.linkDef((Var)tuple.as())});
    }

    @Override
    public Doc visitNumber(@NotNull Pattern.Number number, Boolean nestedCall) {
        Doc doc = Doc.plain((String)String.valueOf(number.number()));
        return number.explicit() ? doc : Doc.braced((Doc)doc);
    }

    @Override
    public Doc visitBind(@NotNull Pattern.Bind bind, Boolean nestedCall) {
        Doc doc = BaseDistiller.linkDef((Var)bind.bind());
        return bind.explicit() ? doc : Doc.braced((Doc)doc);
    }

    @Override
    public Doc visitAbsurd(@NotNull Pattern.Absurd absurd, Boolean aBoolean) {
        Doc doc = Doc.styled((Style)KEYWORD, (String)"impossible");
        return absurd.explicit() ? doc : Doc.braced((Doc)doc);
    }

    @Override
    public Doc visitCalmFace(@NotNull Pattern.CalmFace calmFace, Boolean nestedCall) {
        Doc doc = Doc.plain((String)"_");
        return calmFace.explicit() ? doc : Doc.braced((Doc)doc);
    }

    @Override
    public Doc visitCtor(@NotNull Pattern.Ctor ctor, Boolean nestedCall) {
        Doc name = Doc.styled((Style)CON_CALL, (String)((String)ctor.name().data()));
        Doc ctorDoc = ctor.params().isEmpty() ? name : Doc.sep((Doc[])new Doc[]{name, this.visitMaybeCtorPatterns((SeqLike<Pattern>)ctor.params(), true, Doc.ALT_WS)});
        return this.ctorDoc(nestedCall, ctor.explicit(), ctorDoc, ctor.as(), ctor.params().isEmpty());
    }

    private Doc visitMaybeCtorPatterns(SeqLike<Pattern> patterns, boolean nestedCall, @NotNull Doc delim) {
        patterns = this.options.showImplicitPats() ? patterns : patterns.view().filter(ConcretePat::explicit);
        return Doc.join((Doc)delim, (SeqLike)patterns.view().map(p -> p.accept(this, nestedCall)));
    }

    public Doc matchy(@NotNull Pattern.Clause match) {
        Doc doc = this.visitMaybeCtorPatterns((SeqLike<Pattern>)match.patterns, false, Doc.plain((String)", "));
        return (Doc)match.expr.map(e -> Doc.sep((Doc[])new Doc[]{doc, Doc.plain((String)"=>"), e.accept(this, false)})).getOrDefault((Object)doc);
    }

    private Doc visitAccess(@NotNull Stmt.Accessibility accessibility, Stmt.Accessibility def) {
        if (accessibility == def) {
            return Doc.empty();
        }
        return Doc.styled((Style)KEYWORD, (String)accessibility.keyword);
    }

    @Override
    public Doc visitImport(@NotNull Command.Import cmd, Unit unit) {
        Buffer prelude = Buffer.of((Object)Doc.styled((Style)KEYWORD, (String)"import"), (Object)Doc.symbol((String)cmd.path().join()));
        if (cmd.asName() != null) {
            prelude.append((Object)Doc.styled((Style)KEYWORD, (String)"as"));
            prelude.append((Object)Doc.plain((String)cmd.asName()));
        }
        return Doc.sep((SeqLike)prelude);
    }

    @Override
    public Doc visitOpen(@NotNull Command.Open cmd, Unit unit) {
        Doc[] docArray = new Doc[5];
        docArray[0] = this.visitAccess(cmd.accessibility(), Stmt.Accessibility.Private);
        docArray[1] = Doc.styled((Style)KEYWORD, (String)"open");
        docArray[2] = Doc.plain((String)cmd.path().join());
        docArray[3] = Doc.styled((Style)KEYWORD, (String)(switch (cmd.useHide().strategy()) {
            default -> throw new IncompatibleClassChangeError();
            case Command.Open.UseHide.Strategy.Using -> "using";
            case Command.Open.UseHide.Strategy.Hiding -> "hiding";
        }));
        docArray[4] = Doc.parened((Doc)Doc.commaList((SeqLike)cmd.useHide().list().view().map(Doc::plain)));
        return Doc.sepNonEmpty((Doc[])docArray);
    }

    @Override
    public Doc visitModule(@NotNull Command.Module mod, Unit unit) {
        return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{this.visitAccess(mod.accessibility(), Stmt.Accessibility.Public), Doc.styled((Style)KEYWORD, (String)"module"), Doc.plain((String)mod.name()), Doc.plain((String)"{")}), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)mod.contents().view().map(stmt -> stmt.accept(this, Unit.unit())))), Doc.plain((String)"}")});
    }

    @Override
    public Doc visitBind(@NotNull Command.Bind bind, Unit unit) {
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"bind"), Doc.plain((String)bind.op().join()), Doc.styled((Style)KEYWORD, (String)bind.pred().keyword), Doc.plain((String)bind.target().join())});
    }

    @Override
    public Doc visitRemark(@NotNull Remark remark, Unit unit) {
        Literate literate = remark.literate;
        return literate != null ? literate.toDoc() : Doc.plain((String)remark.raw);
    }

    @Override
    public Doc visitData(@NotNull Decl.DataDecl decl, Unit unit) {
        Buffer prelude = Buffer.of((Object)this.visitAccess(decl.accessibility(), Stmt.Accessibility.Public), (Object)Doc.styled((Style)KEYWORD, (String)"data"), (Object)BaseDistiller.linkDef(decl.ref, DATA_CALL), (Object)this.visitTele((SeqLike<? extends ParamLike<?>>)decl.telescope));
        this.appendResult((Buffer<Doc>)prelude, decl.result);
        return Doc.cat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)prelude), Doc.emptyIf((boolean)decl.body.isEmpty(), () -> Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)decl.body.view().map(ctor -> this.visitCtor((Decl.DataCtor)ctor, Unit.unit()))))}))});
    }

    @Override
    public Doc visitCtor(@NotNull Decl.DataCtor ctor, Unit unit) {
        Buffer prelude = Buffer.of((Object)BaseDistiller.coe(ctor.coerce), (Object)BaseDistiller.linkDef(ctor.ref, CON_CALL), (Object)this.visitTele((SeqLike<? extends ParamLike<?>>)ctor.telescope), (Object)this.visitClauses(ctor.clauses, true));
        Doc doc = Doc.sepNonEmpty((SeqLike)prelude);
        if (ctor.patterns.isNotEmpty()) {
            Doc pats = Doc.commaList((SeqLike)ctor.patterns.view().map(pattern -> pattern.accept(this, false)));
            return Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), pats, Doc.plain((String)"=>"), doc});
        }
        return Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), doc});
    }

    private Doc visitClauses(@NotNull ImmutableSeq<Pattern.Clause> clauses, boolean wrapInBraces) {
        if (clauses.isEmpty()) {
            return Doc.empty();
        }
        Doc clausesDoc = Doc.vcat((SeqLike)clauses.view().map(this::matchy).map(doc -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), doc})));
        return wrapInBraces ? Doc.braced((Doc)clausesDoc) : clausesDoc;
    }

    @Override
    public Doc visitStruct(@NotNull Decl.StructDecl decl, Unit unit) {
        Buffer prelude = Buffer.of((Object)this.visitAccess(decl.accessibility(), Stmt.Accessibility.Public), (Object)Doc.styled((Style)KEYWORD, (String)"struct"), (Object)BaseDistiller.linkDef(decl.ref, STRUCT_CALL), (Object)this.visitTele((SeqLike<? extends ParamLike<?>>)decl.telescope));
        this.appendResult((Buffer<Doc>)prelude, decl.result);
        return Doc.cat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)prelude), Doc.emptyIf((boolean)decl.fields.isEmpty(), () -> Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)decl.fields.view().map(field -> this.visitField((Decl.StructField)field, Unit.unit()))))}))});
    }

    private void appendResult(Buffer<Doc> prelude, Expr result) {
        if (result instanceof Expr.HoleExpr) {
            return;
        }
        prelude.append((Object)Doc.symbol((String)":"));
        prelude.append((Object)result.accept(this, false));
    }

    @Override
    public Doc visitField(@NotNull Decl.StructField field, Unit unit) {
        Buffer doc = Buffer.of((Object)Doc.symbol((String)"|"), (Object)BaseDistiller.coe(field.coerce), (Object)BaseDistiller.linkDef(field.ref, FIELD_CALL), (Object)this.visitTele((SeqLike<? extends ParamLike<?>>)field.telescope));
        this.appendResult((Buffer<Doc>)doc, field.result);
        if (field.body.isDefined()) {
            doc.append((Object)Doc.symbol((String)"=>"));
            doc.append((Object)((Expr)field.body.get()).accept(this, false));
        }
        doc.append((Object)this.visitClauses(field.clauses, true));
        return Doc.sepNonEmpty((SeqLike)doc);
    }

    @Override
    public Doc visitFn(@NotNull Decl.FnDecl decl, Unit unit) {
        Buffer prelude = Buffer.of((Object)this.visitAccess(decl.accessibility(), Stmt.Accessibility.Public), (Object)Doc.styled((Style)KEYWORD, (String)"def"));
        prelude.appendAll((Iterable)Seq.from(decl.modifiers).view().map(this::visitModifier));
        prelude.append((Object)BaseDistiller.linkDef(decl.ref, FN_CALL));
        prelude.append((Object)this.visitTele((SeqLike<? extends ParamLike<?>>)decl.telescope));
        this.appendResult((Buffer<Doc>)prelude, decl.result);
        return Doc.cat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)prelude), (Doc)decl.body.fold(expr -> Doc.cat((Doc[])new Doc[]{Doc.ONE_WS, Doc.symbol((String)"=>"), Doc.ONE_WS, expr.accept(this, false)}), clauses -> Doc.cat((Doc[])new Doc[]{Doc.line(), Doc.nest((int)2, (Doc)this.visitClauses((ImmutableSeq<Pattern.Clause>)clauses, false))})), Doc.emptyIf((boolean)decl.abuseBlock.isEmpty(), () -> Doc.cat((Doc[])new Doc[]{Doc.ONE_WS, Doc.styled((Style)KEYWORD, (String)"abusing"), Doc.ONE_WS, this.visitAbuse((ImmutableSeq<Stmt>)decl.abuseBlock)}))});
    }

    @Override
    public Doc visitPrim(@NotNull Decl.PrimDecl decl, Unit unit) {
        return BaseDistiller.primDoc(decl.ref);
    }

    private Doc visitModifier(@NotNull Modifier modifier) {
        return Doc.styled((Style)KEYWORD, (String)(switch (modifier) {
            default -> throw new IncompatibleClassChangeError();
            case Modifier.Inline -> "inline";
            case Modifier.Erase -> "erase";
        }));
    }

    private Doc visitAbuse(@NotNull ImmutableSeq<Stmt> block) {
        return Doc.vcat((SeqLike)block.view().map(stmt -> stmt.accept(this, Unit.unit())));
    }

    @Override
    public Doc visitLevels(@NotNull Generalize.Levels levels, Unit unit) {
        ImmutableSeq vars = levels.levels().map(t -> BaseDistiller.linkDef((Var)t.data(), GENERALIZED));
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"universe"), Doc.sep((SeqLike)vars)});
    }

    @Override
    public Doc visitExample(@NotNull Sample.Working example, Unit unit) {
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"example"), example.delegate().accept(this, unit)});
    }

    @Override
    public Doc visitCounterexample(@NotNull Sample.Counter example, Unit unit) {
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"counterexample"), example.delegate().accept(this, unit)});
    }
}

