/*
 * Decompiled with CFR 0.152.
 */
package org.aya.distill;

import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.Buffer;
import kala.tuple.Unit;
import org.aya.api.core.CorePat;
import org.aya.api.distill.AyaDocile;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.ref.DefVar;
import org.aya.api.ref.Var;
import org.aya.api.util.Arg;
import org.aya.concrete.stmt.Decl;
import org.aya.core.Matching;
import org.aya.core.Meta;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.def.FieldDef;
import org.aya.core.def.FnDef;
import org.aya.core.def.PrimDef;
import org.aya.core.def.StructDef;
import org.aya.core.pat.Pat;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ElimTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.Term;
import org.aya.distill.BaseDistiller;
import org.aya.generic.ParamLike;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.jetbrains.annotations.NotNull;

public record CoreDistiller(@NotNull DistillerOptions options) implements Pat.Visitor<Boolean, Doc>,
Def.Visitor<Unit, Doc>,
Term.Visitor<Boolean, Doc>,
BaseDistiller
{
    @Override
    public Doc visitRef(@NotNull RefTerm term, Boolean nestedCall) {
        return BaseDistiller.varDoc((Var)term.var());
    }

    @Override
    public Doc visitLam(@NotNull IntroTerm.Lambda term, Boolean nestedCall) {
        if (!this.options.showImplicitPats() && !term.param().explicit()) {
            return term.body().accept(this, nestedCall);
        }
        Doc doc = Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"\\")), this.lambdaParam(term.param()), Doc.symbol((String)"=>"), term.body().accept(this, false)});
        return nestedCall != false ? Doc.parened((Doc)doc) : doc;
    }

    @Override
    public Doc visitPi(@NotNull FormTerm.Pi term, Boolean nestedCall) {
        if (!this.options.showImplicitPats() && !term.param().explicit()) {
            return term.body().accept(this, nestedCall);
        }
        Doc doc = Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Pi")), term.param().toDoc(this.options), Doc.symbol((String)"->"), term.body().accept(this, false)});
        return nestedCall != false ? Doc.parened((Doc)doc) : doc;
    }

    @Override
    public Doc visitSigma(@NotNull FormTerm.Sigma term, Boolean nestedCall) {
        Doc doc = Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (Doc)Doc.symbol((String)"Sig")), this.visitTele((SeqLike<? extends ParamLike<?>>)term.params().view().dropLast(1)), Doc.symbol((String)"**"), ((Term.Param)term.params().last()).toDoc(this.options)});
        return nestedCall != false ? Doc.parened((Doc)doc) : doc;
    }

    @Override
    public Doc visitUniv(@NotNull FormTerm.Univ term, Boolean nestedCall) {
        Doc fn = Doc.styled((Style)KEYWORD, (String)"Type");
        if (!this.options.showLevels()) {
            return fn;
        }
        return this.visitCalls(fn, Seq.of((Object)term.sort()).view().map(t -> new Arg((AyaDocile)t, true)), (Boolean nest, T t) -> t.toDoc(this.options), (boolean)nestedCall);
    }

    @Override
    public Doc visitApp(@NotNull ElimTerm.App term, Boolean nestedCall) {
        return this.visitCalls(term.of(), term.arg(), nestedCall);
    }

    @Override
    public Doc visitFnCall(@NotNull CallTerm.Fn fnCall, Boolean nestedCall) {
        return this.visitCalls(fnCall.ref(), FN_CALL, (SeqLike<Arg<Term>>)fnCall.args(), (boolean)nestedCall);
    }

    @Override
    public Doc visitPrimCall(@NotNull CallTerm.Prim prim, Boolean nestedCall) {
        return this.visitCalls(prim.ref(), FN_CALL, (SeqLike<Arg<Term>>)prim.args(), (boolean)nestedCall);
    }

    @Override
    public Doc visitDataCall(@NotNull CallTerm.Data dataCall, Boolean nestedCall) {
        return this.visitCalls(dataCall.ref(), DATA_CALL, (SeqLike<Arg<Term>>)dataCall.args(), (boolean)nestedCall);
    }

    @Override
    public Doc visitStructCall(@NotNull CallTerm.Struct structCall, Boolean nestedCall) {
        return this.visitCalls(structCall.ref(), STRUCT_CALL, (SeqLike<Arg<Term>>)structCall.args(), (boolean)nestedCall);
    }

    @Override
    public Doc visitConCall(@NotNull CallTerm.Con conCall, Boolean nestedCall) {
        return this.visitCalls(conCall.ref(), CON_CALL, (SeqLike<Arg<Term>>)conCall.conArgs(), (boolean)nestedCall);
    }

    @Override
    public Doc visitTup(@NotNull IntroTerm.Tuple term, Boolean nestedCall) {
        return Doc.parened((Doc)Doc.commaList((SeqLike)term.items().view().map(t -> t.accept(this, false))));
    }

    @Override
    public Doc visitNew(@NotNull IntroTerm.New newTerm, Boolean aBoolean) {
        return Doc.sep((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"new"), Doc.symbol((String)"{"), Doc.sep((SeqLike)newTerm.params().view().map((k, v) -> Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), BaseDistiller.linkRef((Var)k, FIELD_CALL), Doc.symbol((String)"=>"), v.accept(this, false)})).toImmutableSeq()), Doc.symbol((String)"}")});
    }

    @Override
    public Doc visitProj(@NotNull ElimTerm.Proj term, Boolean nestedCall) {
        return Doc.cat((Doc[])new Doc[]{term.of().accept(this, false), Doc.symbol((String)"."), Doc.plain((String)String.valueOf(term.ix()))});
    }

    @Override
    public Doc visitAccess(@NotNull CallTerm.Access term, Boolean nestedCall) {
        DefVar<FieldDef, Decl.StructField> ref = term.ref();
        Doc doc = Doc.cat((Doc[])new Doc[]{term.of().accept(this, false), Doc.symbol((String)"."), BaseDistiller.linkRef(ref, FIELD_CALL)});
        return this.visitCalls(doc, term.fieldArgs(), (Boolean n, T t) -> t.accept(this, n), (boolean)nestedCall);
    }

    @Override
    public Doc visitHole(@NotNull CallTerm.Hole term, Boolean nestedCall) {
        Meta name = term.ref();
        Doc inner = BaseDistiller.varDoc(name);
        if (this.options.inlineMetas()) {
            return this.visitCalls(inner, term.args(), (Boolean nest, T t) -> t.accept(this, nest), (boolean)nestedCall);
        }
        return Doc.wrap((String)"{?", (String)"?}", (Doc)this.visitCalls(inner, term.args(), (Boolean nest, T t) -> t.accept(this, nest), false));
    }

    @Override
    public Doc visitFieldRef(@NotNull RefTerm.Field term, Boolean aBoolean) {
        return BaseDistiller.linkRef(term.ref(), FIELD_CALL);
    }

    @Override
    public Doc visitError(@NotNull ErrorTerm term, Boolean aBoolean) {
        Doc doc = term.description().toDoc(this.options);
        return !term.isReallyError() ? doc : Doc.angled((Doc)doc);
    }

    private Doc visitCalls(@NotNull Term fn, @NotNull @NotNull Arg<@NotNull Term> arg, boolean nestedCall) {
        return this.visitCalls(fn.accept(this, false), Seq.of(arg), (Boolean nest, T term) -> term.accept(this, nest), nestedCall);
    }

    private Doc visitCalls(@NotNull DefVar<?, ?> fn, @NotNull Style style, @NotNull @NotNull SeqLike<@NotNull Arg<@NotNull Term>> args, boolean nestedCall) {
        Doc hyperLink = BaseDistiller.linkRef(fn, style);
        return this.visitCalls(hyperLink, args, (Boolean nest, T term) -> term.accept(this, nest), nestedCall);
    }

    @Override
    public Doc visitTuple(@NotNull Pat.Tuple tuple, Boolean nested) {
        Doc tup = Doc.licit((boolean)tuple.explicit(), (Doc)Doc.commaList((SeqLike)tuple.pats().view().map(pat -> pat.accept(this, false))));
        return tuple.as() == null ? tup : Doc.sep((Doc[])new Doc[]{tup, Doc.styled((Style)KEYWORD, (String)"as"), BaseDistiller.linkDef((Var)tuple.as())});
    }

    @Override
    public Doc visitBind(@NotNull Pat.Bind bind, Boolean aBoolean) {
        Doc doc = BaseDistiller.linkDef((Var)bind.as());
        return bind.explicit() ? doc : Doc.braced((Doc)doc);
    }

    @Override
    public Doc visitAbsurd(@NotNull Pat.Absurd absurd, Boolean aBoolean) {
        Doc doc = Doc.styled((Style)KEYWORD, (String)"impossible");
        return absurd.explicit() ? doc : Doc.braced((Doc)doc);
    }

    @Override
    public Doc visitPrim(@NotNull Pat.Prim prim, Boolean aBoolean) {
        Doc link = BaseDistiller.linkRef(prim.ref(), CON_CALL);
        return prim.explicit() ? link : Doc.braced((Doc)link);
    }

    @Override
    public Doc visitCtor(@NotNull Pat.Ctor ctor, Boolean nestedCall) {
        Doc ctorDoc = Doc.cat((Doc[])new Doc[]{BaseDistiller.linkRef(ctor.ref(), CON_CALL), this.visitMaybeCtorPatterns((SeqLike<Pat>)ctor.params(), true, Doc.ONE_WS)});
        return this.ctorDoc(nestedCall, ctor.explicit(), ctorDoc, ctor.as(), ctor.params().isEmpty());
    }

    public Doc visitMaybeCtorPatterns(SeqLike<Pat> patterns, boolean nestedCall, @NotNull Doc delim) {
        SeqView pats = this.options.showImplicitPats() ? patterns : patterns.view().filter(CorePat::explicit);
        return Doc.emptyIf((boolean)pats.isEmpty(), () -> this.lambda$visitMaybeCtorPatterns$11(delim, (SeqLike)pats, nestedCall));
    }

    @Override
    public Doc visitFn(@NotNull FnDef def, Unit unit) {
        Buffer line1 = Buffer.of((Object)Doc.styled((Style)KEYWORD, (String)"def"), (Object)BaseDistiller.linkDef(def.ref(), FN_CALL), (Object)this.visitTele((SeqLike<? extends ParamLike<?>>)def.telescope()), (Object)Doc.symbol((String)":"), (Object)def.result().accept(this, false));
        return (Doc)def.body.fold(term -> Doc.sep((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)line1), Doc.symbol((String)"=>"), term.accept(this, false)}), clauses -> Doc.vcat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)line1), Doc.nest((int)2, (Doc)this.visitClauses((ImmutableSeq<Matching>)clauses))}));
    }

    private Doc visitConditions(Doc line1, @NotNull ImmutableSeq<Matching> clauses) {
        if (clauses.isEmpty()) {
            return line1;
        }
        return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{line1, Doc.symbol((String)"{")}), Doc.nest((int)2, (Doc)this.visitClauses(clauses)), Doc.symbol((String)"}")});
    }

    private Doc visitClauses(@NotNull ImmutableSeq<Matching> clauses) {
        return Doc.vcat((SeqLike)clauses.view().map(matching -> matching.toDoc(this.options)).map(doc -> Doc.cat((Doc[])new Doc[]{Doc.symbol((String)"|"), doc})));
    }

    @Override
    public Doc visitData(@NotNull DataDef def, Unit unit) {
        Buffer line1 = Buffer.of((Object)Doc.styled((Style)KEYWORD, (String)"data"), (Object)BaseDistiller.linkDef(def.ref(), DATA_CALL), (Object)this.visitTele((SeqLike<? extends ParamLike<?>>)def.telescope()), (Object)Doc.symbol((String)":"), (Object)def.result().accept(this, false));
        return Doc.vcat((Doc[])new Doc[]{Doc.sepNonEmpty((SeqLike)line1), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)def.body.view().map(ctor -> ctor.accept(this, Unit.unit()))))});
    }

    @Override
    public Doc visitCtor(@NotNull CtorDef ctor, Unit unit) {
        Doc line1;
        Doc doc = Doc.sepNonEmpty((Doc[])new Doc[]{BaseDistiller.coe(ctor.coerce), BaseDistiller.linkDef(ctor.ref(), CON_CALL), this.visitTele((SeqLike<? extends ParamLike<?>>)ctor.selfTele)});
        if (ctor.pats.isNotEmpty()) {
            Doc pats = Doc.commaList((SeqLike)ctor.pats.view().map(pat -> pat.accept(this, false)));
            line1 = Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), pats, Doc.symbol((String)"=>"), doc});
        } else {
            line1 = Doc.sep((Doc[])new Doc[]{Doc.symbol((String)"|"), doc});
        }
        return this.visitConditions(line1, (ImmutableSeq<Matching>)ctor.clauses);
    }

    @Override
    public Doc visitStruct(@NotNull StructDef def, Unit unit) {
        return Doc.vcat((Doc[])new Doc[]{Doc.sepNonEmpty((Doc[])new Doc[]{Doc.styled((Style)KEYWORD, (String)"struct"), BaseDistiller.linkDef(def.ref(), STRUCT_CALL), this.visitTele((SeqLike<? extends ParamLike<?>>)def.telescope()), Doc.symbol((String)":"), def.result().accept(this, false)}), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)def.fields.view().map(field -> field.accept(this, Unit.unit()))))});
    }

    @Override
    public Doc visitField(@NotNull FieldDef field, Unit unit) {
        return this.visitConditions(Doc.sepNonEmpty((Doc[])new Doc[]{Doc.symbol((String)"|"), BaseDistiller.coe(field.coerce), BaseDistiller.linkDef(field.ref(), FIELD_CALL), this.visitTele((SeqLike<? extends ParamLike<?>>)field.selfTele), Doc.symbol((String)":"), field.result.accept(this, false)}), (ImmutableSeq<Matching>)field.clauses);
    }

    @Override
    @NotNull
    public Doc visitPrim(@NotNull PrimDef def, Unit unit) {
        return BaseDistiller.primDoc(def.ref());
    }

    private /* synthetic */ Doc lambda$visitMaybeCtorPatterns$11(Doc delim, SeqLike pats, boolean nestedCall) {
        return Doc.cat((Doc[])new Doc[]{Doc.ONE_WS, Doc.join((Doc)delim, (SeqLike)pats.view().map(p -> p.accept(this, nestedCall)))});
    }
}

