/*
 * Decompiled with CFR 0.152.
 */
package org.aya.generic;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import kala.collection.mutable.Buffer;
import org.jetbrains.annotations.NotNull;

public abstract class GenericBuilder<T extends Tree<T>> {
    protected final Deque<@NotNull Buffer<@NotNull T>> tops = new ArrayDeque<Buffer<T>>();

    public GenericBuilder() {
        this.tops.addLast(Buffer.create());
    }

    @NotNull
    public @NotNull Buffer<@NotNull T> root() {
        return this.tops.getFirst();
    }

    public void append(@NotNull T trace) {
        this.shift(trace);
        this.reduce();
    }

    public void shift(@NotNull T trace) {
        Objects.requireNonNull(this.tops.getLast()).append(trace);
        this.tops.addLast(trace.children());
    }

    public void unshift() {
        Buffer<T> buffer = Objects.requireNonNull(this.tops.getLast());
        buffer.removeAt(buffer.size() - 1);
    }

    public void reduce() {
        this.tops.removeLast();
    }

    public static interface Tree<T extends Tree<T>> {
        @NotNull
        public Buffer<T> children();
    }
}

