/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.function.Supplier;
import kala.collection.base.Growable;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.Buffer;
import kala.collection.mutable.MutableMap;
import kala.tuple.Tuple2;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.LocalVar;
import org.aya.api.util.Arg;
import org.aya.core.Meta;
import org.aya.core.term.CallTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.Term;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(hasChildren="true", childrenArray="extract().toArray()")
public record LocalCtx(@NotNull MutableMap<LocalVar, Term> localMap, @Nullable LocalCtx parent) {
    public LocalCtx() {
        this((MutableMap<LocalVar, Term>)MutableMap.wrapJava(new LinkedHashMap()), null);
    }

    @NotNull
    public Tuple2<CallTerm.Hole, Term> freshHole(@NotNull Term type, @NotNull SourcePos sourcePos) {
        return this.freshHole(type, "_", sourcePos);
    }

    @NotNull
    public Tuple2<CallTerm.Hole, Term> freshHole(@NotNull Term type, @NotNull String name, @NotNull SourcePos sourcePos) {
        ImmutableSeq<Term.Param> ctxTele = this.extract();
        Meta meta = Meta.from(ctxTele, name, type, sourcePos);
        CallTerm.Hole hole = new CallTerm.Hole(meta, (ImmutableSeq<Arg<Term>>)ctxTele.map(Term.Param::toArg), (ImmutableSeq<Arg<Term>>)meta.telescope.map(Term.Param::toArg));
        return Tuple2.of((Object)hole, (Object)IntroTerm.Lambda.make(meta.telescope, hole));
    }

    public <T> T with(@NotNull Term.Param param, @NotNull Supplier<T> action) {
        return this.with(param.ref(), param.type(), action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T with(@NotNull ImmutableSeq<Term.Param> params, @NotNull Supplier<T> action) {
        for (Term.Param param : params) {
            this.localMap.put((Object)param.ref(), (Object)param.type());
        }
        try {
            Iterator<Object> iterator = action.get();
            return (T)iterator;
        }
        finally {
            for (Term.Param param : params) {
                this.localMap.remove((Object)param.ref());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T with(@NotNull LocalVar var, @NotNull Term type, @NotNull Supplier<T> action) {
        this.localMap.put((Object)var, (Object)type);
        try {
            T t = action.get();
            return t;
        }
        finally {
            this.localMap.remove((Object)var);
        }
    }

    @NotNull
    public ImmutableSeq<Term.Param> extract() {
        Buffer ctx = Buffer.create();
        LocalCtx map = this;
        while (map != null) {
            map.localMap.mapTo((Growable)ctx, (k, v) -> new Term.Param((LocalVar)k, (Term)v, false));
            map = map.parent;
        }
        return ctx.toImmutableSeq();
    }

    @Contract(pure=true)
    @NotNull
    public Term get(LocalVar var) {
        Term result = (Term)this.localMap.getOrElse((Object)var, () -> this.parentGet(var));
        assert (result != null) : var.name();
        return result;
    }

    @Contract(pure=true)
    @Nullable
    private Term parentGet(LocalVar var) {
        return this.parent != null ? this.parent.get(var) : null;
    }

    public void put(@NotNull LocalVar var, @NotNull Term term) {
        this.localMap.set((Object)var, (Object)term);
    }

    public boolean isEmpty() {
        return this.localMap.isEmpty() && (this.parent == null || this.parent.isEmpty());
    }

    @Contract(value=" -> new")
    @NotNull
    public LocalCtx derive() {
        return new LocalCtx((MutableMap<LocalVar, Term>)MutableMap.wrapJava(new LinkedHashMap()), this);
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }
}

