/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.ExprProblem;
import org.aya.api.error.Problem;
import org.aya.api.util.NormalizeMode;
import org.aya.concrete.Expr;
import org.aya.core.term.Term;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.jetbrains.annotations.NotNull;

public final class BadTypeError
extends Record
implements ExprProblem {
    @NotNull
    private final Expr expr;
    @NotNull
    private final Term actualType;
    @NotNull
    private final Doc action;
    @NotNull
    private final Doc thing;
    @NotNull
    private final Doc desired;

    public BadTypeError(@NotNull Expr expr, @NotNull Term actualType, @NotNull Doc action, @NotNull Doc thing, @NotNull Doc desired) {
        this.expr = expr;
        this.actualType = actualType;
        this.action = action;
        this.thing = thing;
        this.desired = desired;
    }

    @NotNull
    public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    @NotNull
    public Doc describe(@NotNull DistillerOptions options) {
        return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unable to"), this.action, Doc.english((String)"the expression")}), Doc.par((int)1, (Doc)this.expr.toDoc(options)), Doc.sep((Doc[])new Doc[]{Doc.english((String)"because the type"), this.thing, Doc.english((String)"is not a"), Doc.cat((Doc[])new Doc[]{this.desired, Doc.plain((String)",")}), Doc.english((String)"but instead:")}), Doc.par((int)1, (Doc)this.actualType.toDoc(options)), Doc.par((int)1, (Doc)Doc.parened((Doc)Doc.sep((Doc[])new Doc[]{Doc.plain((String)"Normalized:"), this.actualType.normalize(null, NormalizeMode.NF).toDoc(options)})))});
    }

    @NotNull
    public static BadTypeError pi(@NotNull Expr expr, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.plain((String)"apply"), Doc.english((String)"of what you applied"), Doc.english((String)"Pi type"));
    }

    @NotNull
    public static BadTypeError sigmaAcc(@NotNull Expr expr, int ix, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.sep((Doc[])new Doc[]{Doc.english((String)"project the"), Doc.ordinal((int)ix), Doc.english((String)"element of")}), Doc.english((String)"of what you projected on"), Doc.english((String)"Sigma type"));
    }

    @NotNull
    public static BadTypeError sigmaCon(@NotNull Expr expr, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.sep((Doc[])new Doc[]{Doc.plain((String)"construct")}), Doc.english((String)"you checks it against"), Doc.english((String)"Sigma type"));
    }

    @NotNull
    public static BadTypeError structAcc(@NotNull Expr expr, @NotNull String fieldName, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.sep((Doc[])new Doc[]{Doc.english((String)"access field"), Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)fieldName)), Doc.plain((String)"of")}), Doc.english((String)"of what you accessed"), Doc.english((String)"struct type"));
    }

    @NotNull
    public static BadTypeError structCon(@NotNull Expr expr, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.sep((Doc[])new Doc[]{Doc.plain((String)"construct")}), Doc.english((String)"you gave"), Doc.english((String)"struct type"));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{BadTypeError.class, "expr;actualType;action;thing;desired", "expr", "actualType", "action", "thing", "desired"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BadTypeError.class, "expr;actualType;action;thing;desired", "expr", "actualType", "action", "thing", "desired"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BadTypeError.class, "expr;actualType;action;thing;desired", "expr", "actualType", "action", "thing", "desired"}, this, o);
    }

    @NotNull
    public Expr expr() {
        return this.expr;
    }

    @NotNull
    public Term actualType() {
        return this.actualType;
    }

    @NotNull
    public Doc action() {
        return this.action;
    }

    @NotNull
    public Doc thing() {
        return this.thing;
    }

    @NotNull
    public Doc desired() {
        return this.desired;
    }
}

