/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.Problem;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.Var;
import org.aya.distill.BaseDistiller;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface FieldProblem
extends Problem {
    @NotNull
    default public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    public record NoSuchFieldError(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<String> notFound) implements FieldProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"No such field(s):"), Doc.commaList((SeqLike)this.notFound.view().map(m -> Doc.styled((Style)Style.code(), (Doc)Doc.plain((String)m))))});
        }
    }

    public record MissingFieldError(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<Var> missing) implements FieldProblem
    {
        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Missing field(s):"), Doc.commaList((SeqLike)this.missing.view().map(BaseDistiller::varDoc).map(m -> Doc.styled((Style)Style.code(), (Doc)m)))});
        }
    }
}

