/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.ExprProblem;
import org.aya.api.error.Problem;
import org.aya.api.util.NormalizeMode;
import org.aya.concrete.Expr;
import org.aya.core.term.Term;
import org.aya.pretty.doc.Doc;
import org.jetbrains.annotations.NotNull;

public final class UnifyError
extends Record
implements ExprProblem {
    @NotNull
    private final Expr expr;
    @NotNull
    private final Term expected;
    @NotNull
    private final Term actual;

    public UnifyError(@NotNull Expr expr, @NotNull Term expected, @NotNull Term actual) {
        this.expr = expr;
        this.expected = expected;
        this.actual = actual;
    }

    @NotNull
    public Doc describe(@NotNull DistillerOptions options) {
        return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Cannot check the expression of type"), Doc.par((int)1, (Doc)this.actual.toDoc(options)), Doc.par((int)1, (Doc)Doc.parened((Doc)Doc.sep((Doc[])new Doc[]{Doc.plain((String)"Normalized:"), this.actual.normalize(null, NormalizeMode.NF).toDoc(options)}))), Doc.english((String)"against the type"), Doc.par((int)1, (Doc)this.expected.toDoc(options)), Doc.par((int)1, (Doc)Doc.parened((Doc)Doc.sep((Doc[])new Doc[]{Doc.plain((String)"Normalized:"), this.expected.normalize(null, NormalizeMode.NF).toDoc(options)})))});
    }

    @NotNull
    public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{UnifyError.class, "expr;expected;actual", "expr", "expected", "actual"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{UnifyError.class, "expr;expected;actual", "expr", "expected", "actual"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{UnifyError.class, "expr;expected;actual", "expr", "expected", "actual"}, this, o);
    }

    @NotNull
    public Expr expr() {
        return this.expr;
    }

    @NotNull
    public Term expected() {
        return this.expected;
    }

    @NotNull
    public Term actual() {
        return this.actual;
    }
}

