/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.aya.api.distill.DistillerOptions;
import org.aya.api.error.ExprProblem;
import org.aya.api.error.Problem;
import org.aya.concrete.Expr;
import org.aya.pretty.doc.Doc;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface UnivArgsError
extends ExprProblem {
    @NotNull
    default public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    public static final class Misplaced
    extends Record
    implements UnivArgsError {
        @NotNull
        private final Expr.UnivArgsExpr expr;

        public Misplaced(@NotNull Expr.UnivArgsExpr expr) {
            this.expr = expr;
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.english((String)"Universe argument should not be placed here");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Misplaced.class, "expr", "expr"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Misplaced.class, "expr", "expr"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Misplaced.class, "expr", "expr"}, this, o);
        }

        @NotNull
        public Expr.UnivArgsExpr expr() {
            return this.expr;
        }
    }

    public static final class SizeMismatch
    extends Record
    implements UnivArgsError {
        @NotNull
        private final Expr.UnivArgsExpr expr;
        private final int expected;

        public SizeMismatch(@NotNull Expr.UnivArgsExpr expr, int expected) {
            this.expr = expr;
            this.expected = expected;
        }

        @NotNull
        public Doc describe(@NotNull DistillerOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.plain((String)"Expected"), Doc.plain((String)String.valueOf(this.expected)), Doc.english((String)"universe arguments, but"), Doc.plain((String)String.valueOf(this.expr.univArgs().size())), Doc.english((String)"are provided")});
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SizeMismatch.class, "expr;expected", "expr", "expected"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SizeMismatch.class, "expr;expected", "expr", "expected"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SizeMismatch.class, "expr;expected", "expr", "expected"}, this, o);
        }

        @NotNull
        public Expr.UnivArgsExpr expr() {
            return this.expr;
        }

        public int expected() {
            return this.expected;
        }
    }
}

