/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.tuple.Tuple;
import kala.tuple.Unit;
import org.aya.api.distill.AyaDocile;
import org.aya.api.error.Problem;
import org.aya.api.error.SourcePos;
import org.aya.api.util.Arg;
import org.aya.api.util.NormalizeMode;
import org.aya.api.util.WithPos;
import org.aya.core.Matching;
import org.aya.core.def.CtorDef;
import org.aya.core.def.Def;
import org.aya.core.def.PrimDef;
import org.aya.core.pat.Pat;
import org.aya.core.pat.PatMatcher;
import org.aya.core.pat.PatToTerm;
import org.aya.core.sort.LevelSubst;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Normalizer;
import org.aya.core.visitor.Substituter;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.pat.ClausesProblem;
import org.aya.util.Ordering;
import org.jetbrains.annotations.NotNull;

public record Conquer(@NotNull ImmutableSeq<Matching> matchings, @NotNull SourcePos sourcePos, @NotNull Def.Signature signature, @NotNull ExprTycker tycker) implements Pat.Visitor<Integer, Unit>
{
    public static void against(@NotNull ImmutableSeq<Matching> matchings, @NotNull ExprTycker tycker, @NotNull SourcePos pos, @NotNull Def.Signature signature) {
        int size = matchings.size();
        for (int i = 0; i < size; ++i) {
            Matching matching = (Matching)matchings.get(i);
            for (Pat pat : matching.patterns()) {
                pat.accept(new Conquer(matchings, pos, signature, tycker), i);
            }
        }
    }

    @Override
    public Unit visitBind(@NotNull Pat.Bind bind, Integer nth) {
        return Unit.unit();
    }

    @Override
    public Unit visitTuple(@NotNull Pat.Tuple tuple, Integer nth) {
        for (Pat pat : tuple.pats()) {
            pat.accept(this, nth);
        }
        return Unit.unit();
    }

    @Override
    public Unit visitCtor(@NotNull Pat.Ctor ctor, Integer nth) {
        ImmutableSeq<Pat> params = ctor.params();
        for (Pat pat : params) {
            pat.accept(this, nth);
        }
        ImmutableSeq conditions = ((CtorDef)ctor.ref().core).clauses;
        int size = conditions.size();
        for (int i = 0; i < size; ++i) {
            Matching condition = (Matching)conditions.get(i);
            Substituter.TermSubst matchy = PatMatcher.tryBuildSubstTerms(params, (SeqLike<Term>)condition.patterns().view().map(Pat::toTerm));
            if (matchy == null) continue;
            this.checkConditions(ctor, nth, i + 1, condition.body(), matchy, condition.sourcePos());
        }
        return Unit.unit();
    }

    private void checkConditions(final Pat ctor, int nth, int i, final Term condition, Substituter.TermSubst matchy, SourcePos conditionPos) {
        ErrorTerm error;
        Object object;
        Matching currentClause = (Matching)this.matchings.get(nth);
        Term newBody = currentClause.body().subst(matchy);
        ImmutableSeq newArgs = currentClause.patterns().map(pat -> new Arg((AyaDocile)pat.accept(new PatToTerm(){

            @Override
            public Term visitCtor(@NotNull Pat.Ctor newCtor, Unit unit) {
                return newCtor == ctor ? condition : super.visitCtor(newCtor, unit);
            }
        }, Unit.unit()), pat.explicit()));
        WithPos<Term> volynskaya = new Normalizer(this.tycker.state).tryUnfoldClauses(NormalizeMode.WHNF, (SeqLike<Arg<Term>>)newArgs, LevelSubst.EMPTY, this.matchings);
        if (volynskaya == null) {
            this.tycker.reporter.report((Problem)new ClausesProblem.Conditions(this.sourcePos, nth + 1, i, newBody, null, conditionPos, currentClause.sourcePos(), null));
            return;
        }
        if (newBody instanceof ErrorTerm && (object = (error = (ErrorTerm)newBody).description()) instanceof CallTerm.Hole) {
            CallTerm.Hole hole = (CallTerm.Hole)object;
            hole.ref().conditions.append((Object)Tuple.of((Object)matchy, (Object)((Term)volynskaya.data())));
        } else {
            ErrorTerm error2;
            object = volynskaya.data();
            if (object instanceof ErrorTerm && (object = (error2 = (ErrorTerm)object).description()) instanceof CallTerm.Hole) {
                CallTerm.Hole hole = (CallTerm.Hole)object;
                hole.ref().conditions.append((Object)Tuple.of((Object)matchy, (Object)newBody));
            }
        }
        boolean unification = this.tycker.unifier(this.sourcePos, Ordering.Eq).compare(newBody, (Term)volynskaya.data(), this.signature.result().subst(matchy));
        if (!unification) {
            this.tycker.reporter.report((Problem)new ClausesProblem.Conditions(this.sourcePos, nth + 1, i, newBody, (Term)volynskaya.data(), conditionPos, currentClause.sourcePos(), volynskaya.sourcePos()));
        }
    }

    @Override
    public Unit visitAbsurd(@NotNull Pat.Absurd absurd, Integer nth) {
        return Unit.unit();
    }

    @Override
    public Unit visitPrim(@NotNull Pat.Prim prim, Integer nth) {
        PrimDef core = (PrimDef)prim.ref().core;
        assert (PrimDef.Factory.INSTANCE.leftOrRight(core));
        return Unit.unit();
    }
}

