/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.Buffer;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.tuple.Tuple;
import kala.tuple.primitive.IntObjTuple2;
import org.aya.api.distill.AyaDocile;
import org.aya.api.error.Problem;
import org.aya.api.error.Reporter;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.Var;
import org.aya.api.util.Arg;
import org.aya.api.util.NormalizeMode;
import org.aya.concrete.Pattern;
import org.aya.core.Matching;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.PrimDef;
import org.aya.core.pat.Pat;
import org.aya.core.pat.PatMatcher;
import org.aya.core.pat.PatUnify;
import org.aya.core.sort.Sort;
import org.aya.core.term.CallTerm;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.FormTerm;
import org.aya.core.term.IntroTerm;
import org.aya.core.term.Term;
import org.aya.core.visitor.Substituter;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.TyckState;
import org.aya.tyck.pat.ClausesProblem;
import org.aya.tyck.pat.PatTree;
import org.aya.util.Ordering;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PatClassifier(@NotNull Reporter reporter, @NotNull SourcePos pos, @NotNull TyckState state, @NotNull PatTree.Builder builder) {
    @NotNull
    public static ImmutableSeq<PatClass> classify(@NotNull @NotNull ImmutableSeq<@NotNull Pat.PrototypeClause> clauses, @NotNull ImmutableSeq<Term.Param> telescope, @NotNull TyckState state, @NotNull Reporter reporter, @NotNull SourcePos pos, boolean coverage) {
        PatClassifier classifier = new PatClassifier(reporter, pos, state, new PatTree.Builder());
        ImmutableSeq<PatClass> classification = classifier.classifySub(telescope, (ImmutableSeq<SubPats>)clauses.mapIndexed((index, clause) -> new SubPats((SeqView<Pat>)clause.patterns().view(), index)), coverage);
        for (PatClass pats : classification) {
            if (!(pats instanceof PatClass.Err)) continue;
            PatClass.Err err = (PatClass.Err)pats;
            reporter.report((Problem)new ClausesProblem.MissingCase(pos, err.errorMessage));
            return ImmutableSeq.empty();
        }
        return classification;
    }

    public static void confluence(@NotNull @NotNull ImmutableSeq<@NotNull Pat.PrototypeClause> clauses, @NotNull ExprTycker tycker, @NotNull SourcePos pos, @NotNull Term result, @NotNull ImmutableSeq<PatClass> classification) {
        for (PatClass results : classification) {
            ImmutableSeq contents = results.contents().flatMap(i -> Pat.PrototypeClause.deprototypify((Pat.PrototypeClause)clauses.get(i.intValue())).map(matching -> IntObjTuple2.of((int)i, (Object)matching)));
            int size = contents.size();
            for (int i2 = 1; i2 < size; ++i2) {
                ErrorTerm error;
                ErrorTerm error2;
                AyaDocile ayaDocile;
                IntObjTuple2 lhsInfo = (IntObjTuple2)contents.get(i2 - 1);
                IntObjTuple2 rhsInfo = (IntObjTuple2)contents.get(i2);
                Substituter.TermSubst lhsSubst = new Substituter.TermSubst((MutableMap<Var, Term>)MutableMap.create());
                Substituter.TermSubst rhsSubst = new Substituter.TermSubst((MutableMap<Var, Term>)MutableMap.create());
                PatUnify.unifyPat(((Matching)lhsInfo._2).patterns(), ((Matching)rhsInfo._2).patterns(), lhsSubst, rhsSubst);
                PatClassifier.domination(rhsSubst, tycker.reporter, lhsInfo._1, rhsInfo._1, (Matching)rhsInfo._2);
                PatClassifier.domination(lhsSubst, tycker.reporter, rhsInfo._1, lhsInfo._1, (Matching)lhsInfo._2);
                Term lhsTerm = ((Matching)lhsInfo._2).body().subst(lhsSubst);
                Term rhsTerm = ((Matching)rhsInfo._2).body().subst(rhsSubst);
                if (lhsTerm instanceof ErrorTerm && (ayaDocile = (error2 = (ErrorTerm)lhsTerm).description()) instanceof CallTerm.Hole) {
                    CallTerm.Hole hole = (CallTerm.Hole)ayaDocile;
                    hole.ref().conditions.append((Object)Tuple.of((Object)lhsSubst, (Object)rhsTerm));
                } else if (rhsTerm instanceof ErrorTerm && (ayaDocile = (error = (ErrorTerm)rhsTerm).description()) instanceof CallTerm.Hole) {
                    CallTerm.Hole hole = (CallTerm.Hole)ayaDocile;
                    hole.ref().conditions.append((Object)Tuple.of((Object)rhsSubst, (Object)lhsTerm));
                }
                boolean unification = tycker.unifier(pos, Ordering.Eq).compare(lhsTerm, rhsTerm, result);
                if (unification) continue;
                tycker.reporter.report((Problem)new ClausesProblem.Confluence(pos, lhsInfo._1 + 1, rhsInfo._1 + 1, lhsTerm, rhsTerm, ((Matching)lhsInfo._2).sourcePos(), ((Matching)rhsInfo._2).sourcePos()));
            }
        }
    }

    private static void domination(Substituter.TermSubst rhsSubst, Reporter reporter, int lhsIx, int rhsIx, Matching matching) {
        if (rhsSubst.isEmpty()) {
            reporter.report((Problem)new ClausesProblem.Domination(lhsIx + 1, rhsIx + 1, matching.sourcePos()));
        }
    }

    @NotNull
    private ImmutableSeq<PatClass> classifySub(@NotNull ImmutableSeq<Term.Param> telescope, @NotNull ImmutableSeq<SubPats> subPatsSeq, boolean coverage) {
        if (telescope.isEmpty()) {
            ImmutableSeq oneClass = subPatsSeq.map(SubPats::ix);
            return ImmutableSeq.of((Object)new PatClass.Ok((ImmutableSeq<Integer>)oneClass));
        }
        Term.Param target = (Term.Param)telescope.first();
        boolean explicit = target.explicit();
        Term term = target.type().normalize(this.state, NormalizeMode.WHNF);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FormTerm.Sigma.class, CallTerm.Prim.class, CallTerm.Data.class}, (Object)term, n)) {
            default: {
                break;
            }
            case 0: {
                FormTerm.Sigma sigma = (FormTerm.Sigma)term;
                ImmutableSeq hasTuple = subPatsSeq.mapIndexedNotNull((index, subPats) -> {
                    SubPats subPats2;
                    Pat patt5368$temp = subPats.head();
                    if (patt5368$temp instanceof Pat.Tuple) {
                        Pat.Tuple tuple = (Pat.Tuple)patt5368$temp;
                        subPats2 = new SubPats((SeqView<Pat>)tuple.pats().view(), index);
                    } else {
                        subPats2 = null;
                    }
                    return subPats2;
                });
                if (!hasTuple.isNotEmpty()) break;
                this.builder.shiftEmpty(explicit);
                IntroTerm.Tuple thatTuple = new IntroTerm.Tuple((ImmutableSeq<Term>)sigma.params().map(Term.Param::toTerm));
                ImmutableSeq newTele = telescope.view().drop(1).map(param -> param.subst((Var)target.ref(), thatTuple)).toImmutableSeq();
                return this.classifySub(sigma.params(), (ImmutableSeq<SubPats>)hasTuple, coverage).flatMap(pat -> this.mapClass((PatClass)pat, this.classifySub((ImmutableSeq<Term.Param>)newTele, (ImmutableSeq<SubPats>)PatClass.extract(pat, subPatsSeq).map(SubPats::drop), coverage)));
            }
            case 1: {
                CallTerm.Prim primCall = (CallTerm.Prim)term;
                assert (((PrimDef)primCall.ref().core).id == PrimDef.ID.INTERVAL);
                Option lrSplit = subPatsSeq.mapNotNull(subPats -> {
                    Pat.Prim prim;
                    Pat patt6686$temp = subPats.head();
                    return patt6686$temp instanceof Pat.Prim ? (prim = (Pat.Prim)patt6686$temp) : null;
                }).firstOption();
                if (!lrSplit.isDefined()) break;
                Buffer buffer = Buffer.create();
                if (coverage) {
                    this.reporter.report((Problem)new ClausesProblem.SplitInterval(this.pos, (Pat)lrSplit.get()));
                }
                for (PrimDef.ID primName : PrimDef.Factory.LEFT_RIGHT) {
                    this.builder.append(new PatTree(primName.id, explicit, 0));
                    Option<PrimDef> prim = PrimDef.Factory.INSTANCE.getOption(primName);
                    PatClass.Ok patClass = new PatClass.Ok((ImmutableSeq<Integer>)subPatsSeq.view().mapIndexedNotNull((ix, subPats) -> PatClassifier.matches(subPats, ix, prim)).map(SubPats::ix).toImmutableSeq());
                    ImmutableSeq classes = PatClass.extract(patClass, subPatsSeq).map(SubPats::drop);
                    if (classes.isNotEmpty()) {
                        CallTerm.Prim lrCall = new CallTerm.Prim(((PrimDef)prim.get()).ref, (ImmutableSeq<Sort>)ImmutableSeq.empty(), (ImmutableSeq<Arg<Term>>)ImmutableSeq.empty());
                        ImmutableSeq newTele = telescope.view().drop(1).map(param -> param.subst((Var)target.ref(), lrCall)).toImmutableSeq();
                        ImmutableSeq<PatClass> rest = this.classifySub((ImmutableSeq<Term.Param>)newTele, (ImmutableSeq<SubPats>)classes, false);
                        buffer.appendAll(rest);
                    }
                    this.builder.unshift();
                }
                return buffer.toImmutableSeq();
            }
            case -1: 
            case 2: {
                CallTerm.Data dataCall = (CallTerm.Data)term;
                if (subPatsSeq.anyMatch(subPats -> subPats.pats.isNotEmpty()) && subPatsSeq.noneMatch(subPats -> subPats.head() instanceof Pat.Ctor)) break;
                Buffer buffer = Buffer.create();
                for (CtorDef ctor : ((DataDef)dataCall.ref().core).body) {
                    ImmutableSeq conTele = ctor.selfTele;
                    if (ctor.pats.isNotEmpty()) {
                        Substituter.TermSubst matchy = PatMatcher.tryBuildSubstArgs(ctor.pats, dataCall.args());
                        if (matchy == null) continue;
                        conTele = conTele.map(param -> param.subst(matchy));
                    }
                    ImmutableSeq conTeleCapture = conTele;
                    ImmutableSeq matches = subPatsSeq.mapIndexedNotNull((ix, subPats) -> PatClassifier.matches(subPats, ix, (ImmutableSeq<Term.Param>)conTeleCapture, ctor.ref()));
                    this.builder.shift(new PatTree(ctor.ref().name(), explicit, conTele.count(Term.Param::explicit)));
                    if (telescope.sizeEquals(1) && matches.isEmpty()) {
                        if (coverage) {
                            buffer.append((Object)new PatClass.Err((ImmutableSeq<Integer>)ImmutableSeq.empty(), (ImmutableSeq<Pattern>)this.builder.root().view().map(PatTree::toPattern).toImmutableSeq()));
                        }
                        this.builder.reduce();
                        this.builder.unshift();
                        continue;
                    }
                    ImmutableSeq<PatClass> classified = this.classifySub((ImmutableSeq<Term.Param>)conTele, (ImmutableSeq<SubPats>)matches, coverage);
                    this.builder.reduce();
                    CallTerm.Con conCall = new CallTerm.Con(dataCall.conHead(ctor.ref), (ImmutableSeq<Arg<Term>>)conTeleCapture.map(Term.Param::toArg));
                    ImmutableSeq newTele = telescope.view().drop(1).map(param -> param.subst((Var)target.ref(), conCall)).toImmutableSeq();
                    ImmutableSeq rest = classified.flatMap(pat -> this.mapClass((PatClass)pat, this.classifySub((ImmutableSeq<Term.Param>)newTele, (ImmutableSeq<SubPats>)PatClass.extract(pat, subPatsSeq).map(SubPats::drop), coverage)));
                    this.builder.unshift();
                    buffer.appendAll((Iterable)rest);
                }
                return buffer.toImmutableSeq();
            }
        }
        this.builder.shiftEmpty(explicit);
        this.builder.unshift();
        return this.classifySub((ImmutableSeq<Term.Param>)telescope.drop(1), (ImmutableSeq<SubPats>)subPatsSeq.map(SubPats::drop), coverage);
    }

    private ImmutableSeq<PatClass> mapClass(@NotNull PatClass pat, @NotNull ImmutableSeq<PatClass> classes) {
        PatClass patClass = pat;
        Objects.requireNonNull(patClass);
        PatClass patClass2 = patClass;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PatClass.Ok.class, PatClass.Err.class}, (Object)patClass2, n)) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                PatClass.Ok ok = (PatClass.Ok)patClass2;
                yield classes;
            }
            case 1 -> {
                PatClass.Err err = (PatClass.Err)patClass2;
                yield classes.map(newClz -> new PatClass.Err(newClz.contents(), err.errorMessage));
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static SubPats matches(SubPats subPats, int ix, Option<PrimDef> existedPrim) {
        block3: {
            Pat head;
            block2: {
                head = subPats.head();
                if (!(head instanceof Pat.Prim)) break block2;
                Pat.Prim prim = (Pat.Prim)head;
                if (existedPrim.isNotEmpty() && prim.ref() == ((PrimDef)existedPrim.get()).ref()) break block3;
            }
            if (!(head instanceof Pat.Bind)) return null;
        }
        SubPats subPats2 = new SubPats(subPats.pats, ix);
        return subPats2;
    }

    @Nullable
    private static SubPats matches(SubPats subPats, int ix, ImmutableSeq<Term.Param> conTele, Var ctorRef) {
        Pat.Ctor ctorPat;
        Pat head = subPats.head();
        if (head instanceof Pat.Ctor && (ctorPat = (Pat.Ctor)head).ref() == ctorRef) {
            return new SubPats((SeqView<Pat>)ctorPat.params().view(), ix);
        }
        if (head instanceof Pat.Bind) {
            return new SubPats((SeqView<Pat>)conTele.view().map(p -> new Pat.Bind(p.explicit(), p.ref(), p.type())), ix);
        }
        return null;
    }

    /*
     * Uses preview features.  Disable with feature flag or --previewfeatures false
     */
    public static sealed interface PatClass {
        @NotNull
        public ImmutableSeq<Integer> contents();

        @NotNull
        private static ImmutableSeq<SubPats> extract(PatClass pats, @NotNull ImmutableSeq<SubPats> subPatsSeq) {
            return pats.contents().map(arg_0 -> subPatsSeq.get(arg_0));
        }

        public record Err(@NotNull ImmutableSeq<Integer> contents, @NotNull ImmutableSeq<Pattern> errorMessage) implements PatClass
        {
        }

        public record Ok(@NotNull ImmutableSeq<Integer> contents) implements PatClass
        {
        }
    }

    record SubPats(@NotNull SeqView<Pat> pats, int ix) {
        @Contract(pure=true)
        @NotNull
        public Pat head() {
            return (Pat)this.pats.first();
        }

        @Contract(pure=true)
        @NotNull
        public SubPats drop() {
            return new SubPats((SeqView<Pat>)this.pats.drop(1), this.ix);
        }
    }
}

