/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.trace;

import java.util.Deque;
import kala.collection.mutable.Buffer;
import org.aya.api.error.SourcePos;
import org.aya.api.ref.DefVar;
import org.aya.concrete.Expr;
import org.aya.concrete.Pattern;
import org.aya.core.term.Term;
import org.aya.generic.GenericBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Trace
extends GenericBuilder.Tree<Trace> {
    public <P, R> R accept(@NotNull Visitor<P, R> var1, P var2);

    public record PatT(@NotNull Term term, @NotNull Pattern pat, @NotNull SourcePos pos, @NotNull @NotNull Buffer<@NotNull Trace> children) implements Trace
    {
        public PatT(@NotNull Term term, @NotNull Pattern pat, @NotNull SourcePos pos) {
            this(term, pat, pos, (Buffer<Trace>)Buffer.create());
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitPat(this, p);
        }
    }

    public record TyckT(@NotNull Term term, @NotNull Term type, @NotNull SourcePos pos, @NotNull @NotNull Buffer<@NotNull Trace> children) implements Trace
    {
        public TyckT(@NotNull Term term, @NotNull Term type, @NotNull SourcePos pos) {
            this(term, type, pos, (Buffer<Trace>)Buffer.create());
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitTyck(this, p);
        }
    }

    public record UnifyT(@NotNull Term lhs, @NotNull Term rhs, @NotNull SourcePos pos, @Nullable Term type, @NotNull @NotNull Buffer<@NotNull Trace> children) implements Trace
    {
        public UnifyT(@NotNull Term lhs, @NotNull Term rhs, @NotNull SourcePos pos) {
            this(lhs, rhs, pos, null);
        }

        public UnifyT(@NotNull Term lhs, @NotNull Term rhs, @NotNull SourcePos pos, @Nullable Term type) {
            this(lhs, rhs, pos, type, (Buffer<Trace>)Buffer.create());
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitUnify(this, p);
        }
    }

    public record ExprT(@NotNull Expr expr, @Nullable Term term, @NotNull @NotNull Buffer<@NotNull Trace> children) implements Trace
    {
        public ExprT(@NotNull Expr expr, @Nullable Term term) {
            this(expr, term, (Buffer<Trace>)Buffer.create());
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitExpr(this, p);
        }
    }

    public record DeclT(@NotNull DefVar<?, ?> var, @NotNull SourcePos pos, @NotNull @NotNull Buffer<@NotNull Trace> children) implements Trace
    {
        public DeclT(@NotNull DefVar<?, ?> var, @NotNull SourcePos pos) {
            this(var, pos, (Buffer<Trace>)Buffer.create());
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitDecl(this, p);
        }
    }

    public record LabelT(@NotNull SourcePos pos, @NotNull String label, @NotNull @NotNull Buffer<@NotNull Trace> children) implements Trace
    {
        public LabelT(@NotNull SourcePos pos, @NotNull String label) {
            this(pos, label, (Buffer<Trace>)Buffer.create());
        }

        @Override
        public <P, R> R accept(@NotNull Visitor<P, R> visitor, P p) {
            return visitor.visitLabel(this, p);
        }
    }

    public static final class Builder
    extends GenericBuilder<Trace> {
        @VisibleForTesting
        @NotNull
        public Deque<Buffer<Trace>> getTops() {
            return this.tops;
        }
    }

    public static interface Visitor<P, R> {
        public R visitExpr(@NotNull ExprT var1, P var2);

        public R visitUnify(@NotNull UnifyT var1, P var2);

        public R visitDecl(@NotNull DeclT var1, P var2);

        public R visitTyck(@NotNull TyckT var1, P var2);

        public R visitPat(@NotNull PatT var1, P var2);

        public R visitLabel(@NotNull LabelT var1, P var2);
    }
}

